/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.core.element;

import de.tomalbrc.bil.core.element.PolymerDisplayElementLike;
import de.tomalbrc.bil.mixin.accessor.SimpleDataTrackerAccessor;
import de.tomalbrc.bil.util.Utils;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.tracker.DataTrackerLike;
import eu.pb4.polymer.virtualentity.api.tracker.DisplayTrackedData;
import eu.pb4.polymer.virtualentity.api.tracker.SimpleDataTracker;
import java.util.List;
import java.util.Map;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2739;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_4590;
import net.minecraft.class_7837;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3f;
import org.joml.Matrix4x3fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public interface PerPlayerTransformableElement
extends PolymerDisplayElementLike {
    public Map<class_3222, Data> playerDataTrackers();

    default public void addDataTracker(class_3222 serverPlayer) {
        this.playerDataTrackers().get(serverPlayer).setDataTracker(PerPlayerTransformableElement.copyEntries((SimpleDataTracker)this.getDataTracker(), (SimpleDataTracker)this.createDataTracker()));
    }

    default public void resetDataTracker(class_3222 serverPlayer) {
        Data map = this.playerDataTrackers().get(serverPlayer);
        if (map != null) {
            map.setDataTracker(null);
        }
    }

    default public DataTrackerLike dataTrackerOrDefault(class_3222 serverPlayer) {
        if (serverPlayer == null) {
            return this.getDataTracker();
        }
        Data playerData = this.playerDataTrackers().get(serverPlayer);
        if (playerData == null || playerData.getDataTracker() == null) {
            return this.getDataTracker();
        }
        return playerData.getDataTracker();
    }

    default public void setTransformation(class_3222 serverPlayer, class_4590 transformation) {
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.TRANSLATION, (Object)transformation.method_35865());
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.LEFT_ROTATION, (Object)transformation.method_22937());
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.SCALE, (Object)transformation.method_35866());
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.RIGHT_ROTATION, (Object)transformation.method_35867());
    }

    default public void setTransformation(class_3222 serverPlayer, Matrix4f matrix) {
        float f = 1.0f / matrix.m33();
        Triple triple = class_7837.method_46412((Matrix3f)new Matrix3f((Matrix4fc)matrix).scale(f));
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.TRANSLATION, (Object)matrix.getTranslation(new Vector3f()));
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.LEFT_ROTATION, (Object)new Quaternionf((Quaternionfc)triple.getLeft()));
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.SCALE, (Object)new Vector3f((Vector3fc)triple.getMiddle()));
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.RIGHT_ROTATION, (Object)new Quaternionf((Quaternionfc)triple.getRight()));
    }

    default public void setTransformation(class_3222 serverPlayer, Matrix4x3f matrix) {
        Triple triple = class_7837.method_46412((Matrix3f)new Matrix3f().set((Matrix4x3fc)matrix));
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.TRANSLATION, (Object)matrix.getTranslation(new Vector3f()));
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.LEFT_ROTATION, (Object)new Quaternionf((Quaternionfc)triple.getLeft()));
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.SCALE, (Object)new Vector3f((Vector3fc)triple.getMiddle()));
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.RIGHT_ROTATION, (Object)new Quaternionf((Quaternionfc)triple.getRight()));
    }

    default public boolean isTransformationDirty(class_3222 serverPlayer) {
        DataTrackerLike dataTracker = this.dataTrackerOrDefault(serverPlayer);
        return dataTracker.isDirty(DisplayTrackedData.TRANSLATION) || dataTracker.isDirty(DisplayTrackedData.LEFT_ROTATION) || dataTracker.isDirty(DisplayTrackedData.SCALE) || dataTracker.isDirty(DisplayTrackedData.RIGHT_ROTATION);
    }

    default public void setTranslation(class_3222 serverPlayer, Vector3fc vector3f) {
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.TRANSLATION, (Object)new Vector3f(vector3f));
    }

    default public Vector3fc getTranslation(class_3222 serverPlayer) {
        return (Vector3fc)this.dataTrackerOrDefault(serverPlayer).get(DisplayTrackedData.TRANSLATION);
    }

    default public void setScale(class_3222 serverPlayer, Vector3fc vector3f) {
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.SCALE, (Object)new Vector3f(vector3f));
    }

    default public Vector3fc getScale(class_3222 serverPlayer) {
        return (Vector3fc)this.dataTrackerOrDefault(serverPlayer).get(DisplayTrackedData.SCALE);
    }

    default public void setLeftRotation(class_3222 serverPlayer, Quaternionfc quaternion) {
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.LEFT_ROTATION, (Object)new Quaternionf(quaternion));
    }

    default public Quaternionfc getLeftRotation(class_3222 serverPlayer) {
        return (Quaternionfc)this.dataTrackerOrDefault(serverPlayer).get(DisplayTrackedData.LEFT_ROTATION);
    }

    default public void setRightRotation(class_3222 serverPlayer, Quaternionfc quaternion) {
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.RIGHT_ROTATION, (Object)new Quaternionf(quaternion));
    }

    default public Quaternionfc getRightRotation(class_3222 serverPlayer) {
        return (Quaternionfc)this.dataTrackerOrDefault(serverPlayer).get(DisplayTrackedData.RIGHT_ROTATION);
    }

    default public Integer getInterpolationDuration(class_3222 serverPlayer) {
        return (Integer)this.dataTrackerOrDefault(serverPlayer).get(DisplayTrackedData.INTERPOLATION_DURATION);
    }

    default public void setInterpolationDuration(class_3222 serverPlayer, int interpolationDuration) {
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.INTERPOLATION_DURATION, (Object)interpolationDuration);
    }

    default public Integer getTeleportDuration(class_3222 serverPlayer) {
        return (Integer)this.dataTrackerOrDefault(serverPlayer).get(DisplayTrackedData.TELEPORTATION_DURATION);
    }

    default public void setTeleportDuration(class_3222 serverPlayer, int interpolationDuration) {
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.TELEPORTATION_DURATION, (Object)interpolationDuration);
    }

    default public Integer getStartInterpolation(class_3222 serverPlayer) {
        return (Integer)this.dataTrackerOrDefault(serverPlayer).get(DisplayTrackedData.START_INTERPOLATION);
    }

    default public void startInterpolation(class_3222 serverPlayer) {
        this.dataTrackerOrDefault(serverPlayer).setDirty(DisplayTrackedData.START_INTERPOLATION, true);
    }

    default public void setStartInterpolation(class_3222 serverPlayer, int startInterpolation) {
        this.dataTrackerOrDefault(serverPlayer).set(DisplayTrackedData.START_INTERPOLATION, (Object)startInterpolation, true);
    }

    default public void startInterpolationIfDirty(class_3222 serverPlayer) {
        if (this.isTransformationDirty(serverPlayer)) {
            this.startInterpolation(serverPlayer);
        }
    }

    default public void sendTrackerIfDirty(class_3244 serverPlayer, List<class_2945.class_7834<?>> list) {
        if (list != null && serverPlayer != null) {
            serverPlayer.method_14364((class_2596)new class_2739(this.getEntityId(), list));
        }
    }

    default public void sendTrackerUpdatesPerPlayer() {
        class_3244[] arr;
        ElementHolder holder = this.getHolder();
        if (holder == null) {
            return;
        }
        List defaultDirty = this.getDataTracker().getDirtyEntries();
        for (class_3244 watchingPlayer : arr = holder.getWatchingPlayers().toArray(Utils.EMPTY_CONNECTION_ARRAY)) {
            Data data = this.playerDataTrackers().get(watchingPlayer.field_14140);
            if (data != null && data.dataTracker != null) {
                this.sendTrackerIfDirty(watchingPlayer, data.dataTracker.getDirtyEntries());
                continue;
            }
            this.sendTrackerIfDirty(watchingPlayer, defaultDirty);
        }
    }

    public static SimpleDataTracker copyEntries(SimpleDataTracker from, SimpleDataTracker to) {
        for (SimpleDataTracker.Entry<?> entry : ((SimpleDataTrackerAccessor)from).getEntries()) {
            if (entry.isUnchanged()) continue;
            to.set(entry.getData(), entry.get());
        }
        return to;
    }

    public static class Data {
        SimpleDataTracker dataTracker;
        float yRot;
        float xRot;
        class_243 pos;

        public Data() {
        }

        public Data(float yRot, float xRot, class_243 pos) {
            this.dataTracker = null;
            this.yRot = yRot;
            this.xRot = xRot;
            this.pos = pos;
        }

        public class_243 getPos() {
            return this.pos;
        }

        public float getxRot() {
            return this.xRot;
        }

        public float getyRot() {
            return this.yRot;
        }

        public SimpleDataTracker getDataTracker() {
            return this.dataTracker;
        }

        public class_243 pos() {
            return this.pos;
        }

        public void setDataTracker(SimpleDataTracker dataTracker) {
            this.dataTracker = dataTracker;
        }

        public void setYaw(float yRot) {
            this.yRot = yRot;
        }

        public void setPitch(float xRot) {
            this.xRot = xRot;
        }

        public void setPos(class_243 pos) {
            this.pos = pos;
        }
    }
}

