/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.core.holder.base;

import de.tomalbrc.bil.BIL;
import de.tomalbrc.bil.util.Utils;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2739;
import net.minecraft.class_3244;
import net.minecraft.class_3532;
import net.minecraft.class_8609;

public class VisiblityAwareElementHolder
extends ElementHolder {
    protected static final double FOV = 1.3962633609771729;
    protected static final double MAX_DISTANCE_SQR = class_3532.method_34954((int)144);
    protected static final double MIN_DISTANCE_SQR = class_3532.method_34954((int)112);
    protected final List<class_2596<? super class_2602>> stagedPackets = new ObjectArrayList();

    public void sendPacket(class_2596<? extends class_2602> packet) {
        this.stagedPackets.add(packet);
    }

    public void tick() {
        super.tick();
    }

    protected double getFov() {
        return 1.3962633609771729;
    }

    protected double getMaxAnimationDistance() {
        return MAX_DISTANCE_SQR;
    }

    protected double getMinAnimationDistance() {
        return MIN_DISTANCE_SQR;
    }

    protected boolean isInFov(class_3244 player) {
        double pitchTarget;
        class_243 horizontalToTarget;
        boolean inVRange;
        class_243 holderPos = this.getPos();
        double dist = player.field_14140.method_5649(holderPos.field_1352, player.field_14140.method_23318(), holderPos.field_1350);
        boolean bl = inVRange = Math.abs(player.field_14140.method_23318() - holderPos.field_1350) / 2.0 > this.getMaxAnimationDistance();
        if (dist > this.getMaxAnimationDistance() && !inVRange) {
            return false;
        }
        if (dist <= this.getMinAnimationDistance() || inVRange) {
            return true;
        }
        class_243 directionFacing = player.field_14140.method_5828(1.0f).method_1029();
        class_243 directionToTarget = holderPos.method_1020(player.field_14140.method_19538()).method_1029();
        class_243 horizontalFacing = new class_243(directionFacing.field_1352, 0.0, directionFacing.field_1350).method_1029();
        double horizontalAngle = Math.acos(horizontalFacing.method_1026(horizontalToTarget = new class_243(directionToTarget.field_1352, 0.0, directionToTarget.field_1350).method_1029()));
        if (horizontalAngle > this.getFov()) {
            return false;
        }
        double pitchFacing = Math.asin(directionFacing.field_1351);
        double verticalAngle = Math.abs(pitchFacing - (pitchTarget = Math.asin(directionToTarget.field_1351)));
        return verticalAngle <= this.getFov();
    }

    protected List<class_2596<? super class_2602>> filterForPlayer(List<class_2596<? super class_2602>> packetList, class_3244 packetListener) {
        if (!this.isInFov(packetListener)) {
            ObjectArrayList filteredList = new ObjectArrayList(packetList.size());
            for (int i = 0; i < filteredList.size(); ++i) {
                class_2596 packet = (class_2596)filteredList.get(i);
                if (packet instanceof class_2739) continue;
                filteredList.add(packet);
            }
            return filteredList;
        }
        return packetList;
    }

    protected void flushPackets(class_3244[] watchingPlayers) {
        if (this.stagedPackets.isEmpty()) {
            return;
        }
        for (int i = 0; i < watchingPlayers.length; ++i) {
            List<class_2596<? super class_2602>> list;
            class_3244 player = watchingPlayers[i];
            if (player == null) continue;
            List<class_2596<? super class_2602>> playerPackets = this.filterForPlayer(this.stagedPackets, player);
            List<class_2596<? super class_2602>> list2 = list = playerPackets != this.stagedPackets ? playerPackets : this.stagedPackets;
            if (playerPackets != this.stagedPackets) {
                list = playerPackets;
            }
            for (class_2596<? super class_2602> packet : list) {
                this.sendPacketDirect(player, packet);
            }
        }
        this.stagedPackets.clear();
    }

    public void sendPacketDirect(class_3244 player, class_2596<? extends class_2602> packet) {
        if (player != null) {
            if (BIL.SERVER.method_18854()) {
                player.method_14364(packet);
            } else {
                Utils.sendPacketNoFlush((class_8609)player, packet);
            }
        }
    }

    public void destroy() {
        this.flushPackets(this.getWatchingPlayers().toArray(new class_3244[0]));
        super.destroy();
    }
}

