/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.core.holder.wrapper;

import de.tomalbrc.bil.core.element.PerPlayerTextDisplayElement;
import de.tomalbrc.bil.core.holder.wrapper.Bone;
import de.tomalbrc.bil.core.model.Node;
import de.tomalbrc.bil.core.model.Pose;
import eu.pb4.polymer.virtualentity.api.tracker.DisplayTrackedData;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class TextBone
extends Bone<PerPlayerTextDisplayElement> {
    private class_2561 text;
    private final byte opacity;
    private Integer backgroundColor;
    private boolean invisible;

    protected TextBone(PerPlayerTextDisplayElement element, Node node, Pose defaultPose, boolean isHead) {
        super(element, node, defaultPose, isHead);
        this.text = element.getText();
        this.opacity = element.getTextOpacity();
        this.backgroundColor = (Integer)element.getDataTracker().get(DisplayTrackedData.Text.BACKGROUND);
    }

    public static TextBone of(PerPlayerTextDisplayElement element, Node node, Pose defaultPose, boolean isHead) {
        return new TextBone(element, node, defaultPose, isHead);
    }

    public static TextBone of(PerPlayerTextDisplayElement element, @NotNull Node node, Pose defaultPose) {
        boolean head = false;
        for (Node current = node; current != null; current = current.parent()) {
            if (!current.headTag()) continue;
            head = true;
            break;
        }
        return new TextBone(element, node, defaultPose, head);
    }

    public void setInvisible(boolean invisible) {
        if (this.invisible == invisible) {
            return;
        }
        this.invisible = invisible;
        if (invisible) {
            this.setTrackedBackground(0);
            this.setTrackedOpacity((byte)0);
        } else {
            this.setTrackedBackground(this.backgroundColor);
            this.setTrackedOpacity(this.opacity);
        }
    }

    public void updateBackgroundColor(int color) {
        this.backgroundColor = color;
        this.setTrackedBackground(color);
    }

    public void updateText(class_2561 text) {
        this.text = text;
        this.setTrackedText(text);
    }

    private void setTrackedBackground(int color) {
        ((PerPlayerTextDisplayElement)this.element()).getDataTracker().set(DisplayTrackedData.Text.BACKGROUND, (Object)color, true);
    }

    private void setTrackedOpacity(byte opacity) {
        ((PerPlayerTextDisplayElement)this.element()).getDataTracker().set(DisplayTrackedData.Text.TEXT_OPACITY, (Object)opacity, true);
    }

    private void setTrackedText(class_2561 text) {
        ((PerPlayerTextDisplayElement)this.element()).getDataTracker().set(DisplayTrackedData.Text.TEXT, (Object)text, true);
    }
}

