/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.core.model;

import de.tomalbrc.bil.file.bbmodel.BbElement;
import java.util.UUID;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record Node(@NotNull NodeType type, @Nullable Node parent, @NotNull Transform transform, @NotNull String name, @NotNull UUID uuid, @Nullable class_2960 modelData, boolean headTag, @Nullable BbElement displayDataElement) {

    public static enum NodeType {
        BONE,
        LOCATOR,
        ITEM,
        BLOCK,
        TEXT;

    }

    public static final class Transform {
        private final Vector3f origin;
        private final Quaternionf rotation;
        private final float scale;
        private Matrix4f globalTransform;

        public Transform(Vector3f origin, Quaternionf rotation, float scale) {
            this.origin = origin;
            this.rotation = rotation;
            this.scale = scale;
            this.globalTransform = new Matrix4f().translate((Vector3fc)origin).rotate((Quaternionfc)rotation);
        }

        public Transform mul(Transform other) {
            this.globalTransform = other.globalTransform.mul((Matrix4fc)this.globalTransform, new Matrix4f());
            return this;
        }

        public Transform mul(Matrix4f other) {
            this.globalTransform = other.mul((Matrix4fc)this.globalTransform);
            return this;
        }

        public Vector3fc origin() {
            return this.origin;
        }

        public Quaternionfc rotation() {
            return this.rotation;
        }

        public float scale() {
            return this.scale;
        }

        public Matrix4fc globalTransform() {
            return this.globalTransform;
        }
    }
}

