/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.file.importer;

import de.tomalbrc.bil.core.model.Node;
import de.tomalbrc.bil.core.model.Pose;
import de.tomalbrc.bil.file.bbmodel.BbAnimation;
import de.tomalbrc.bil.file.bbmodel.BbAnimator;
import de.tomalbrc.bil.file.bbmodel.BbElement;
import de.tomalbrc.bil.file.bbmodel.BbFace;
import de.tomalbrc.bil.file.bbmodel.BbGroup;
import de.tomalbrc.bil.file.bbmodel.BbModel;
import de.tomalbrc.bil.file.bbmodel.BbOutliner;
import de.tomalbrc.bil.file.bbmodel.BbTexture;
import de.tomalbrc.bil.file.extra.BbModelUtils;
import de.tomalbrc.bil.file.importer.BbModelImporter;
import de.tomalbrc.bil.file.importer.Sampler;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.exception.MolangRuntimeException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BbModel5Importer
extends BbModelImporter {
    public BbModel5Importer(BbModel model) {
        super(model);
    }

    @Override
    protected void postProcess(BbModel model) {
        for (BbElement element : model.elements) {
            if (element.type != BbElement.ElementType.CUBE_MODEL) continue;
            element.faces.entrySet().removeIf(entry -> ((BbFace)entry.getValue()).texture == null);
            this.rescaleUV(model.resolution, (List<BbTexture>)model.textures, element);
            this.inflateElement(element);
            BbOutliner parent = BbModelUtils.getParent(model, element);
            if (parent == null) continue;
            BbGroup group = BbModelUtils.getGroup(model, parent);
            element.from.sub((Vector3fc)group.origin);
            element.to.sub((Vector3fc)group.origin);
        }
        for (BbOutliner parent : BbModelUtils.modelOutliner(model)) {
            BbElement element;
            Vector3f min = new Vector3f();
            Vector3f max = new Vector3f();
            for (BbOutliner.ChildEntry childEntry : parent.children) {
                if (childEntry.isNode() || (element = BbModelUtils.getElement(model, childEntry.uuid)) == null || element.type != BbElement.ElementType.CUBE_MODEL) continue;
                min.min((Vector3fc)element.from);
                max.max((Vector3fc)element.to);
            }
            for (BbOutliner.ChildEntry childEntry : parent.children) {
                if (childEntry.isNode() || (element = BbModelUtils.getElement(model, childEntry.uuid)) == null || element.type != BbElement.ElementType.CUBE_MODEL) continue;
                Vector3f diff = min.sub((Vector3fc)max, new Vector3f()).absolute();
                float m = diff.get(diff.maxComponent());
                float scale = Math.min(1.0f, 24.0f / m);
                BbGroup group = BbModelUtils.getGroup(model, parent);
                group.scale = 1.0f / scale;
                element.from.mul(scale).add(8.0f, 8.0f, 8.0f);
                element.to.mul(scale).add(8.0f, 8.0f, 8.0f);
                element.origin.sub((Vector3fc)group.origin).mul(scale).add(8.0f, 8.0f, 8.0f);
            }
        }
    }

    @Override
    protected void createBones(Node parent, BbOutliner parentOutliner, Collection<BbOutliner.ChildEntry> children, Object2ObjectOpenHashMap<UUID, Node> nodeMap) {
        BbGroup parentGroup = BbModelUtils.getGroup(this.model, parentOutliner);
        for (BbOutliner.ChildEntry entry : children) {
            if (!entry.isNode()) continue;
            BbOutliner outliner = entry.outliner;
            class_2960 modelPath = null;
            BbGroup group = BbModelUtils.getGroup(this.model, entry.outliner);
            if (group == null) continue;
            if (outliner.hasModel() && group.export && !outliner.isHitbox()) {
                modelPath = this.generateModel(outliner);
            }
            Vector3f localPos = parentGroup != null ? group.origin.sub((Vector3fc)parentGroup.origin, new Vector3f()) : new Vector3f((Vector3fc)group.origin);
            Quaternionf localRot = this.createQuaternion(group.rotation);
            Node.Transform tr = new Node.Transform(localPos.div(16.0f), localRot, group.scale);
            if (parentOutliner != null) {
                tr.mul(parent.transform());
            } else {
                tr.mul(new Matrix4f().rotateY((float)Math.PI));
            }
            Node node = new Node(Node.NodeType.BONE, parent, tr, group.name, outliner.uuid, modelPath, group.name.startsWith("head"), null);
            nodeMap.put((Object)outliner.uuid, (Object)node);
            this.processLocators(nodeMap, outliner, node);
            this.processTextDisplays(nodeMap, outliner, node);
            this.processBlockDisplays(nodeMap, outliner, node);
            this.processItemDisplays(nodeMap, outliner, node);
            this.createBones(node, outliner, outliner.children, nodeMap);
        }
    }

    @Override
    protected void processLocators(Object2ObjectOpenHashMap<UUID, Node> nodeMap, BbOutliner outliner, Node node) {
        List<BbElement> locatorElements = BbModelUtils.elementsForOutliner(this.model, outliner, BbElement.ElementType.LOCATOR);
        for (BbElement element : locatorElements) {
            BbGroup group = BbModelUtils.getGroup(this.model, outliner);
            if (group == null) continue;
            Vector3f localPos2 = element.position.sub((Vector3fc)group.origin, new Vector3f());
            Node.Transform locatorTransform = new Node.Transform(localPos2.div(16.0f), this.createQuaternion(element.rotation), 1.0f);
            locatorTransform.mul(node.transform());
            Node locatorNode = new Node(Node.NodeType.LOCATOR, node, locatorTransform, element.name, element.uuid, null, false, null);
            nodeMap.put((Object)element.uuid, (Object)locatorNode);
        }
    }

    @Override
    protected void processTextDisplays(Object2ObjectOpenHashMap<UUID, Node> nodeMap, BbOutliner outliner, Node node) {
        List<BbElement> locatorElements = BbModelUtils.elementsForOutliner(this.model, outliner, BbElement.ElementType.TEXT_DISPLAY);
        for (BbElement element : locatorElements) {
            BbGroup group = BbModelUtils.getGroup(this.model, outliner);
            if (group == null) continue;
            Vector3f localPos2 = element.position.sub((Vector3fc)group.origin, new Vector3f());
            Node.Transform locatorTransform = new Node.Transform(localPos2.div(16.0f), this.createQuaternion(element.rotation), 1.0f);
            locatorTransform.mul(node.transform());
            Node locatorNode = new Node(Node.NodeType.TEXT, node, locatorTransform, element.name, element.uuid, null, false, element);
            nodeMap.put((Object)element.uuid, (Object)locatorNode);
        }
    }

    @Override
    protected void processBlockDisplays(Object2ObjectOpenHashMap<UUID, Node> nodeMap, BbOutliner outliner, Node node) {
        List<BbElement> locatorElements = BbModelUtils.elementsForOutliner(this.model, outliner, BbElement.ElementType.BLOCK_DISPLAY);
        for (BbElement element : locatorElements) {
            BbGroup group = BbModelUtils.getGroup(this.model, outliner);
            if (group == null) continue;
            Vector3f localPos2 = element.position.sub((Vector3fc)group.origin, new Vector3f());
            Node.Transform locatorTransform = new Node.Transform(localPos2.div(16.0f), this.createQuaternion(element.rotation), 1.0f);
            locatorTransform.mul(node.transform());
            Node locatorNode = new Node(Node.NodeType.BLOCK, node, locatorTransform, element.name, element.uuid, null, false, element);
            nodeMap.put((Object)element.uuid, (Object)locatorNode);
        }
    }

    @Override
    protected void processItemDisplays(Object2ObjectOpenHashMap<UUID, Node> nodeMap, BbOutliner outliner, Node node) {
        List<BbElement> locatorElements = BbModelUtils.elementsForOutliner(this.model, outliner, BbElement.ElementType.ITEM_DISPLAY);
        for (BbElement element : locatorElements) {
            BbGroup group = BbModelUtils.getGroup(this.model, outliner);
            if (group == null) continue;
            Vector3f localPos2 = element.position.sub((Vector3fc)group.origin, new Vector3f());
            Node.Transform locatorTransform = new Node.Transform(localPos2.div(16.0f), this.createQuaternion(element.rotation), 1.0f);
            locatorTransform.mul(node.transform());
            Node locatorNode = new Node(Node.NodeType.ITEM, node, locatorTransform, element.name, element.uuid, null, false, element);
            nodeMap.put((Object)element.uuid, (Object)locatorNode);
        }
    }

    @Override
    @NotNull
    protected Reference2ObjectOpenHashMap<UUID, Pose> poses(BbAnimation animation, Object2ObjectOpenHashMap<UUID, Node> nodeMap, MolangEnvironment environment, float time) throws MolangRuntimeException {
        Reference2ObjectOpenHashMap poses = new Reference2ObjectOpenHashMap();
        for (Map.Entry entry : nodeMap.entrySet()) {
            Matrix4f matrix4f = new Matrix4f().rotateY((float)Math.PI);
            List<Node> nodePath = this.nodePath((Node)entry.getValue());
            for (Node node : nodePath) {
                BbAnimator animator = animation.animators != null ? animation.animators.get(node.uuid()) : null;
                Vector3fc origin = node.transform().origin();
                Triple triple = animator == null ? Triple.of((Object)new Vector3f(), (Object)new Vector3f(), (Object)new Vector3f(1.0f)) : Sampler.sample(animator.keyframes, this.model.animationVariablePlaceholders, environment, time);
                Quaternionf localRot = this.createQuaternion((Vector3f)triple.getMiddle()).mul(node.transform().rotation());
                Vector3f localPos = ((Vector3f)triple.getLeft()).div(16.0f).add(origin);
                matrix4f.translate((Vector3fc)localPos);
                matrix4f.rotate((Quaternionfc)localRot);
                matrix4f.scale((Vector3fc)triple.getRight());
            }
            poses.put((Object)((UUID)entry.getKey()), (Object)Pose.of(matrix4f.scale(((Node)entry.getValue()).transform().scale())));
        }
        return poses;
    }
}

