/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.file.importer;

import de.tomalbrc.bil.core.model.Animation;
import de.tomalbrc.bil.core.model.Frame;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.core.model.Node;
import de.tomalbrc.bil.core.model.Pose;
import de.tomalbrc.bil.core.model.Variant;
import de.tomalbrc.bil.file.bbmodel.BbAnimation;
import de.tomalbrc.bil.file.bbmodel.BbAnimator;
import de.tomalbrc.bil.file.bbmodel.BbElement;
import de.tomalbrc.bil.file.bbmodel.BbFace;
import de.tomalbrc.bil.file.bbmodel.BbKeyframe;
import de.tomalbrc.bil.file.bbmodel.BbModel;
import de.tomalbrc.bil.file.bbmodel.BbOutliner;
import de.tomalbrc.bil.file.bbmodel.BbTexture;
import de.tomalbrc.bil.file.extra.BbModelUtils;
import de.tomalbrc.bil.file.extra.BbResourcePackGenerator;
import de.tomalbrc.bil.file.extra.ResourcePackModel;
import de.tomalbrc.bil.file.importer.ModelImporter;
import de.tomalbrc.bil.file.importer.Sampler;
import de.tomalbrc.bil.json.CachedUuidDeserializer;
import de.tomalbrc.bil.util.command.CommandParser;
import de.tomalbrc.bil.util.command.ParsedCommand;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import gg.moonflower.molangcompiler.api.exception.MolangRuntimeException;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BbModelImporter
implements ModelImporter<BbModel> {
    protected final BbModel model;

    public BbModelImporter(BbModel model) {
        this.model = model;
        this.postProcess(model);
    }

    protected void rescaleUV(Vector2i globalResolution, List<BbTexture> textures, BbElement element) {
        for (Map.Entry entry : element.faces.entrySet()) {
            BbFace face = (BbFace)entry.getValue();
            for (int i = 0; i < face.uv.size(); ++i) {
                Vector2i textureResolution = null;
                BbTexture texture = textures.get(face.texture);
                if (texture.uvHeight != 0 && texture.uvWidth != 0) {
                    textureResolution = new Vector2i(texture.uvWidth, texture.uvHeight);
                }
                if (textureResolution == null) {
                    textureResolution = globalResolution != null ? globalResolution : new Vector2i(16, 16);
                }
                face.uv.set(i, Float.valueOf(face.uv.get(i).floatValue() * 16.0f / (float)textureResolution.get(i % 2)));
            }
        }
    }

    protected void inflateElement(BbElement element) {
        element.from.sub(element.inflate, element.inflate, element.inflate);
        element.to.add(element.inflate, element.inflate, element.inflate);
    }

    protected void postProcess(BbModel model) {
        for (BbElement element : model.elements) {
            if (element.type != BbElement.ElementType.CUBE_MODEL) continue;
            element.faces.entrySet().removeIf(entry -> ((BbFace)entry.getValue()).texture == null);
            this.rescaleUV(model.resolution, (List<BbTexture>)model.textures, element);
            this.inflateElement(element);
            BbOutliner parent = BbModelUtils.getParent(model, element);
            if (parent == null) continue;
            element.from.sub((Vector3fc)parent.origin);
            element.to.sub((Vector3fc)parent.origin);
        }
        for (BbOutliner parent : BbModelUtils.modelOutliner(model)) {
            BbElement element;
            Vector3f min = new Vector3f();
            Vector3f max = new Vector3f();
            for (BbOutliner.ChildEntry childEntry : parent.children) {
                if (childEntry.isNode() || (element = BbModelUtils.getElement(model, childEntry.uuid)) == null || element.type != BbElement.ElementType.CUBE_MODEL) continue;
                min.min((Vector3fc)element.from);
                max.max((Vector3fc)element.to);
            }
            for (BbOutliner.ChildEntry childEntry : parent.children) {
                if (childEntry.isNode() || (element = BbModelUtils.getElement(model, childEntry.uuid)) == null || element.type != BbElement.ElementType.CUBE_MODEL) continue;
                Vector3f diff = min.sub((Vector3fc)max, new Vector3f()).absolute();
                float m = diff.get(diff.maxComponent());
                float scale = Math.min(1.0f, 24.0f / m);
                parent.scale = 1.0f / scale;
                element.from.mul(scale).add(8.0f, 8.0f, 8.0f);
                element.to.mul(scale).add(8.0f, 8.0f, 8.0f);
                element.origin.sub((Vector3fc)parent.origin).mul(scale).add(8.0f, 8.0f, 8.0f);
            }
        }
    }

    protected Object2ObjectOpenHashMap<UUID, Node> makeNodeMap() {
        Object2ObjectOpenHashMap nodeMap = new Object2ObjectOpenHashMap();
        ObjectArraySet textures = new ObjectArraySet();
        textures.addAll(this.model.textures);
        for (BbOutliner.ChildEntry entry : this.model.outliner) {
            if (!entry.isNode()) continue;
            this.createBones(null, null, (Collection<BbOutliner.ChildEntry>)this.model.outliner, (Object2ObjectOpenHashMap<UUID, Node>)nodeMap);
        }
        BbResourcePackGenerator.makeTextures(this.model, (Collection<BbTexture>)textures);
        return nodeMap;
    }

    protected class_2960 generateModel(BbOutliner outliner) {
        List<BbElement> elements = BbModelUtils.elementsForOutliner(this.model, outliner, BbElement.ElementType.CUBE_MODEL);
        ResourcePackModel.Builder builder = new ResourcePackModel.Builder(this.model.modelIdentifier).withTextures(this.makeDefaultTextureMap()).withElements(elements).addDisplayTransform("head", ResourcePackModel.DEFAULT_TRANSFORM);
        return BbResourcePackGenerator.addItemModel(this.model, outliner.uuid.toString(), builder.build());
    }

    protected void createBones(Node parent, BbOutliner parentOutliner, Collection<BbOutliner.ChildEntry> children, Object2ObjectOpenHashMap<UUID, Node> nodeMap) {
        for (BbOutliner.ChildEntry entry : children) {
            if (!entry.isNode()) continue;
            BbOutliner outliner = entry.outliner;
            class_2960 modelPath = null;
            if (outliner.hasModel() && outliner.export && !outliner.isHitbox()) {
                modelPath = this.generateModel(outliner);
            }
            Vector3f localPos = parentOutliner != null ? outliner.origin.sub((Vector3fc)parentOutliner.origin, new Vector3f()) : new Vector3f((Vector3fc)outliner.origin);
            Quaternionf localRot = this.createQuaternion(outliner.rotation);
            Node.Transform tr = new Node.Transform(localPos.div(16.0f), localRot, outliner.scale);
            if (parentOutliner != null) {
                tr.mul(parent.transform());
            } else {
                tr.mul(new Matrix4f().rotateY((float)Math.PI));
            }
            Node node = new Node(Node.NodeType.BONE, parent, tr, outliner.name, outliner.uuid, modelPath, outliner.name.startsWith("head"), null);
            nodeMap.put((Object)outliner.uuid, (Object)node);
            this.processLocators(nodeMap, outliner, node);
            this.processTextDisplays(nodeMap, outliner, node);
            this.processBlockDisplays(nodeMap, outliner, node);
            this.processItemDisplays(nodeMap, outliner, node);
            this.createBones(node, outliner, outliner.children, nodeMap);
        }
    }

    protected void processLocators(Object2ObjectOpenHashMap<UUID, Node> nodeMap, BbOutliner outliner, Node node) {
        List<BbElement> locatorElements = BbModelUtils.elementsForOutliner(this.model, outliner, BbElement.ElementType.LOCATOR);
        for (BbElement element : locatorElements) {
            Vector3f localPos2 = element.position.sub((Vector3fc)outliner.origin, new Vector3f());
            Node.Transform locatorTransform = new Node.Transform(localPos2.div(16.0f), this.createQuaternion(element.rotation), 1.0f);
            locatorTransform.mul(node.transform());
            Node locatorNode = new Node(Node.NodeType.LOCATOR, node, locatorTransform, element.name, element.uuid, null, false, null);
            nodeMap.put((Object)element.uuid, (Object)locatorNode);
        }
    }

    protected void processTextDisplays(Object2ObjectOpenHashMap<UUID, Node> nodeMap, BbOutliner outliner, Node node) {
        List<BbElement> locatorElements = BbModelUtils.elementsForOutliner(this.model, outliner, BbElement.ElementType.TEXT_DISPLAY);
        for (BbElement element : locatorElements) {
            Vector3f localPos2 = element.position.sub((Vector3fc)outliner.origin, new Vector3f());
            Node.Transform locatorTransform = new Node.Transform(localPos2.div(16.0f), this.createQuaternion(element.rotation), 1.0f);
            locatorTransform.mul(node.transform());
            Node locatorNode = new Node(Node.NodeType.TEXT, node, locatorTransform, element.name, element.uuid, null, false, element);
            nodeMap.put((Object)element.uuid, (Object)locatorNode);
        }
    }

    protected void processBlockDisplays(Object2ObjectOpenHashMap<UUID, Node> nodeMap, BbOutliner outliner, Node node) {
        List<BbElement> locatorElements = BbModelUtils.elementsForOutliner(this.model, outliner, BbElement.ElementType.BLOCK_DISPLAY);
        for (BbElement element : locatorElements) {
            Vector3f localPos2 = element.position.sub((Vector3fc)outliner.origin, new Vector3f());
            Node.Transform locatorTransform = new Node.Transform(localPos2.div(16.0f), this.createQuaternion(element.rotation), 1.0f);
            locatorTransform.mul(node.transform());
            Node locatorNode = new Node(Node.NodeType.BLOCK, node, locatorTransform, element.name, element.uuid, null, false, element);
            nodeMap.put((Object)element.uuid, (Object)locatorNode);
        }
    }

    protected void processItemDisplays(Object2ObjectOpenHashMap<UUID, Node> nodeMap, BbOutliner outliner, Node node) {
        List<BbElement> locatorElements = BbModelUtils.elementsForOutliner(this.model, outliner, BbElement.ElementType.ITEM_DISPLAY);
        for (BbElement element : locatorElements) {
            Vector3f localPos2 = element.position.sub((Vector3fc)outliner.origin, new Vector3f());
            Node.Transform locatorTransform = new Node.Transform(localPos2.div(16.0f), this.createQuaternion(element.rotation), 1.0f);
            locatorTransform.mul(node.transform());
            Node locatorNode = new Node(Node.NodeType.ITEM, node, locatorTransform, element.name, element.uuid, null, false, element);
            nodeMap.put((Object)element.uuid, (Object)locatorNode);
        }
    }

    protected Quaternionf createQuaternion(Vector3f eulerAngles) {
        return new Quaternionf().rotateZ((float)Math.PI / 180 * eulerAngles.z).rotateY((float)Math.PI / 180 * eulerAngles.y).rotateX((float)Math.PI / 180 * eulerAngles.x);
    }

    protected Reference2ObjectOpenHashMap<UUID, Pose> defaultPose(Object2ObjectOpenHashMap<UUID, Node> nodeMap) {
        Reference2ObjectOpenHashMap res = new Reference2ObjectOpenHashMap();
        for (Map.Entry entry : nodeMap.entrySet()) {
            Node bone = (Node)entry.getValue();
            res.put((Object)bone.uuid(), (Object)Pose.of(bone.transform().globalTransform().scale(bone.transform().scale(), new Matrix4f())));
        }
        return res;
    }

    @NotNull
    protected Reference2ObjectOpenHashMap<UUID, Variant> variants() {
        return new Reference2ObjectOpenHashMap();
    }

    protected List<Node> nodePath(Node child) {
        ObjectArrayList nodePath = new ObjectArrayList();
        while (child != null) {
            nodePath.addFirst(child);
            child = child.parent();
        }
        return nodePath;
    }

    @NotNull
    protected Reference2ObjectOpenHashMap<UUID, Pose> poses(BbAnimation animation, Object2ObjectOpenHashMap<UUID, Node> nodeMap, MolangEnvironment environment, float time) throws MolangRuntimeException {
        Reference2ObjectOpenHashMap poses = new Reference2ObjectOpenHashMap();
        for (Map.Entry entry : nodeMap.entrySet()) {
            Matrix4f matrix4f = new Matrix4f().rotateY((float)Math.PI);
            List<Node> nodePath = this.nodePath((Node)entry.getValue());
            for (Node node : nodePath) {
                BbAnimator animator = animation.animators != null ? animation.animators.get(node.uuid()) : null;
                Vector3fc origin = node.transform().origin();
                Triple triple = animator == null ? Triple.of((Object)new Vector3f(), (Object)new Vector3f(), (Object)new Vector3f(1.0f)) : Sampler.sample(animator.keyframes, this.model.animationVariablePlaceholders, environment, time);
                Quaternionf localRot = this.createQuaternion(((Vector3f)triple.getMiddle()).mul(-1.0f, -1.0f, 1.0f)).mul(node.transform().rotation());
                Vector3f localPos = ((Vector3f)triple.getLeft()).mul(-1.0f, 1.0f, 1.0f).div(16.0f).add(origin);
                matrix4f.translate((Vector3fc)localPos);
                matrix4f.rotate((Quaternionfc)localRot);
                matrix4f.scale((Vector3fc)triple.getRight());
            }
            poses.put((Object)((UUID)entry.getKey()), (Object)Pose.of(matrix4f.scale(((Node)entry.getValue()).transform().scale())));
        }
        return poses;
    }

    @Nullable
    protected Frame.Variant frameVariant(BbAnimation anim, float t) {
        return null;
    }

    @Nullable
    protected Frame.Commands frameCommands(BbAnimation anim, float t) {
        UUID effectsUUID = CachedUuidDeserializer.get("effects");
        if (effectsUUID != null && anim.animators != null && anim.animators.containsKey(effectsUUID) && anim.animators.get((Object)effectsUUID).type == BbAnimator.Type.EFFECT) {
            BbAnimator animator = anim.animators.get(effectsUUID);
            for (BbKeyframe kf : animator.keyframes) {
                float difference = (float)class_3532.method_15386((float)(kf.time / 0.05f)) * 0.05f;
                if (difference != t || kf.channel != BbKeyframe.Channel.TIMELINE) continue;
                String key = "script";
                String script = kf.dataPoints.getFirst().get(key).getStringValue();
                if (script.isEmpty()) continue;
                ParsedCommand[] cmds = CommandParser.parse(kf.dataPoints.getFirst().get(key).getStringValue());
                return new Frame.Commands(cmds, null);
            }
        }
        return null;
    }

    @Nullable
    protected Frame.Particle frameParticle(BbAnimation anim, float t) {
        UUID effectsUUID = CachedUuidDeserializer.get("effects");
        if (effectsUUID != null && anim.animators != null && anim.animators.containsKey(effectsUUID) && anim.animators.get((Object)effectsUUID).type == BbAnimator.Type.EFFECT) {
            BbAnimator animator = anim.animators.get(effectsUUID);
            for (BbKeyframe kf : animator.keyframes) {
                float difference = (float)class_3532.method_15386((float)(kf.time / 0.05f)) * 0.05f;
                if (difference != t || kf.channel != BbKeyframe.Channel.TIMELINE) continue;
                String key = "script";
                Map<String, BbKeyframe.DataPointValue> map = kf.dataPoints.getFirst();
                BbKeyframe.DataPointValue val = map.getOrDefault(key, BbKeyframe.DataPointValue.BLANK);
                String script = val.getStringValue();
                if (script.isEmpty()) continue;
                ParsedCommand[] cmds = CommandParser.parse(val.getStringValue());
                return new Frame.Particle(map.getOrDefault("effect", BbKeyframe.DataPointValue.BLANK).getStringValue(), map.getOrDefault("locator", BbKeyframe.DataPointValue.BLANK).getStringValue(), cmds, map.getOrDefault("effect", BbKeyframe.DataPointValue.BLANK).getStringValue());
            }
        }
        return null;
    }

    @Nullable
    protected class_3414 frameSound(BbAnimation anim, float t) {
        UUID effectsUUID = CachedUuidDeserializer.get("effects");
        if (effectsUUID != null && anim.animators != null && anim.animators.containsKey(effectsUUID) && anim.animators.get((Object)effectsUUID).type == BbAnimator.Type.EFFECT) {
            BbAnimator animator = anim.animators.get(effectsUUID);
            for (BbKeyframe kf : animator.keyframes) {
                float difference = (float)class_3532.method_15386((float)(kf.time / 0.05f)) * 0.05f;
                if (difference != t || kf.channel != BbKeyframe.Channel.SOUND) continue;
                return class_3414.method_47908((class_2960)class_2960.method_60654((String)kf.dataPoints.getFirst().get("effect").getStringValue()));
            }
        }
        return null;
    }

    protected Animation.LoopMode convertLoopMode(BbAnimation.LoopMode loopMode) {
        return switch (loopMode) {
            default -> throw new MatchException(null, null);
            case BbAnimation.LoopMode.ONCE -> Animation.LoopMode.ONCE;
            case BbAnimation.LoopMode.HOLD -> Animation.LoopMode.HOLD;
            case BbAnimation.LoopMode.LOOP -> Animation.LoopMode.LOOP;
        };
    }

    @NotNull
    protected Object2ObjectOpenHashMap<String, Animation> animations(Object2ObjectOpenHashMap<UUID, Node> nodeMap) {
        Object2ObjectOpenHashMap res = new Object2ObjectOpenHashMap();
        float step = 0.05f;
        if (this.model.animations != null) {
            this.model.animations.forEach(anim -> {
                try {
                    int frameCount = Math.round(anim.length / step) + 1;
                    Frame[] frames = new Frame[frameCount];
                    for (int i = 0; i < frameCount; ++i) {
                        float time = (float)i * step;
                        Object env = MolangRuntime.runtime().setQuery("life_time", time).setQuery("anim_time", time).create();
                        Reference2ObjectOpenHashMap<UUID, Pose> poses = this.poses((BbAnimation)anim, nodeMap, (MolangEnvironment)env, time);
                        frames[i] = new Frame(time, poses, this.frameVariant((BbAnimation)anim, time), this.frameCommands((BbAnimation)anim, time), this.frameSound((BbAnimation)anim, time), this.frameParticle((BbAnimation)anim, time));
                    }
                    int startDelay = (int)(NumberUtils.isParsable((String)anim.startDelay) ? NumberUtils.createFloat((String)anim.startDelay).floatValue() : 0.0f);
                    int loopDelay = (int)(NumberUtils.isParsable((String)anim.loopDelay) ? NumberUtils.createFloat((String)anim.loopDelay).floatValue() : 0.0f);
                    ReferenceOpenHashSet affectedBones = new ReferenceOpenHashSet();
                    Animation animation = new Animation(frames, startDelay, loopDelay, frameCount, this.convertLoopMode(anim.loop), (ReferenceOpenHashSet<UUID>)affectedBones, false);
                    res.put((Object)anim.name, (Object)animation);
                }
                catch (MolangRuntimeException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return res;
    }

    protected Int2ObjectOpenHashMap<BbTexture> makeDefaultTextureMap() {
        Int2ObjectOpenHashMap textureMap = new Int2ObjectOpenHashMap();
        ObjectArrayList<BbTexture> textures = this.model.textures;
        int texturesSize = textures.size();
        for (int i = 0; i < texturesSize; ++i) {
            BbTexture texture = (BbTexture)textures.get(i);
            textureMap.put(i, (Object)texture);
        }
        return textureMap;
    }

    @NotNull
    public class_241 size() {
        return new class_241(0.5f, 1.0f);
    }

    @Override
    public Model importModel() {
        Object2ObjectOpenHashMap<UUID, Node> nodeMap = this.makeNodeMap();
        Reference2ObjectOpenHashMap<UUID, Pose> defaultPose = this.defaultPose(nodeMap);
        Object2ObjectOpenHashMap<String, Animation> animations = this.animations(nodeMap);
        Reference2ObjectOpenHashMap<UUID, Variant> variants = this.variants();
        return new Model(nodeMap, defaultPose, variants, animations, this.size());
    }
}

