/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.file.loader;

import com.google.gson.JsonParseException;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.file.bbmodel.BbModel;
import de.tomalbrc.bil.file.importer.AjModelImporter;
import de.tomalbrc.bil.file.loader.BbModelLoader;
import de.tomalbrc.bil.file.loader.ModelLoader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.class_2960;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

public class AjModelLoader
extends BbModelLoader {
    public static Model load(class_2960 resourceLocation) {
        return new AjModelLoader().loadResource(resourceLocation);
    }

    public static Model load(String path) {
        Model model;
        FileInputStream input = new FileInputStream(path);
        try {
            model = new AjModelLoader().load(input, FilenameUtils.getBaseName((String)path));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new IllegalArgumentException("Model doesn't exist: " + path);
            }
        }
        ((InputStream)input).close();
        return model;
    }

    @Override
    public Model load(InputStream input, @NotNull String name) throws JsonParseException {
        Model model;
        InputStreamReader reader = new InputStreamReader(input);
        try {
            BbModel model2 = (BbModel)GSON.fromJson((Reader)reader, BbModel.class);
            if (!name.isEmpty()) {
                model2.modelIdentifier = name;
            }
            if (model2.modelIdentifier == null) {
                model2.modelIdentifier = model2.name;
            }
            model2.modelIdentifier = ModelLoader.normalizedModelId(model2.modelIdentifier);
            model = new AjModelImporter(model2).importModel();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                throw new JsonParseException("Failed to parse: " + name, throwable3);
            }
        }
        ((Reader)reader).close();
        return model;
    }

    @Override
    public Model loadResource(class_2960 resourceLocation) throws IllegalArgumentException, JsonParseException {
        String path = String.format("/model/%s/%s.ajmodel", resourceLocation.method_12836(), resourceLocation.method_12832());
        InputStream input = BbModelLoader.class.getResourceAsStream(path);
        if (input == null) {
            throw new IllegalArgumentException("Model doesn't exist: " + path);
        }
        return this.load(input, resourceLocation.method_12832());
    }
}

