/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.molangcompiler.core.ast;

import gg.moonflower.molangcompiler.api.exception.MolangException;
import gg.moonflower.molangcompiler.api.exception.MolangSyntaxException;
import gg.moonflower.molangcompiler.core.ast.BinaryOperation;
import gg.moonflower.molangcompiler.core.ast.Node;
import gg.moonflower.molangcompiler.core.ast.VariableGetNode;
import gg.moonflower.molangcompiler.core.compiler.BytecodeCompiler;
import gg.moonflower.molangcompiler.core.compiler.MolangBytecodeEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.MethodNode;

@ApiStatus.Internal
public record BinaryOperationNode(BinaryOperation operator, Node left, Node right) implements Node
{
    @Override
    public String toString() {
        return "(" + this.left + " " + this.operator + " " + this.right + ")";
    }

    @Override
    public boolean isConstant() {
        return this.left.isConstant() && (this.operator == BinaryOperation.NULL_COALESCING || this.right.isConstant());
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public float evaluate(MolangBytecodeEnvironment environment) throws MolangException {
        float left = this.left.evaluate(environment);
        float right = this.right.evaluate(environment);
        return switch (this.operator) {
            default -> throw new IncompatibleClassChangeError();
            case BinaryOperation.ADD -> left + right;
            case BinaryOperation.SUBTRACT -> left - right;
            case BinaryOperation.MULTIPLY -> left * right;
            case BinaryOperation.DIVIDE -> left / right;
            case BinaryOperation.AND -> {
                if (left != 0.0f && right != 0.0f) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            case BinaryOperation.OR -> {
                if (left != 0.0f || right != 0.0f) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            case BinaryOperation.LESS -> {
                if (left < right) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            case BinaryOperation.LESS_EQUALS -> {
                if (left <= right) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            case BinaryOperation.GREATER -> {
                if (left > right) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            case BinaryOperation.GREATER_EQUALS -> {
                if (left >= right) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            case BinaryOperation.EQUALS -> {
                if (left == right) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            case BinaryOperation.NOT_EQUALS -> {
                if (left != right) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            case BinaryOperation.NULL_COALESCING -> left;
        };
    }

    @Override
    public void writeBytecode(MethodNode method, MolangBytecodeEnvironment environment, @Nullable Label breakLabel, @Nullable Label continueLabel) throws MolangException {
        if (environment.optimize() && this.isConstant()) {
            BytecodeCompiler.writeFloatConst(method, this.evaluate(environment));
            return;
        }
        block0 : switch (this.operator) {
            case AND: {
                Label label_false = new Label();
                Label label_end = new Label();
                BinaryOperationNode.writeNode(this.left, method, environment, breakLabel, continueLabel);
                method.visitInsn(11);
                method.visitInsn(149);
                method.visitJumpInsn(153, label_false);
                BinaryOperationNode.writeNode(this.right, method, environment, breakLabel, continueLabel);
                method.visitInsn(11);
                method.visitInsn(149);
                method.visitJumpInsn(153, label_false);
                method.visitInsn(12);
                method.visitJumpInsn(167, label_end);
                method.visitLabel(label_false);
                method.visitInsn(11);
                method.visitLabel(label_end);
                break;
            }
            case OR: {
                Label label_true = new Label();
                Label label_end = new Label();
                BinaryOperationNode.writeNode(this.left, method, environment, breakLabel, continueLabel);
                method.visitInsn(11);
                method.visitInsn(149);
                method.visitJumpInsn(154, label_true);
                BinaryOperationNode.writeNode(this.right, method, environment, breakLabel, continueLabel);
                method.visitInsn(11);
                method.visitInsn(149);
                method.visitJumpInsn(154, label_true);
                method.visitInsn(11);
                method.visitJumpInsn(167, label_end);
                method.visitLabel(label_true);
                method.visitInsn(12);
                method.visitLabel(label_end);
                break;
            }
            case NULL_COALESCING: {
                Node label_end = this.left;
                if (!(label_end instanceof VariableGetNode)) {
                    throw new MolangSyntaxException("Expected variable lookup, got " + this.left);
                }
                VariableGetNode lookup = (VariableGetNode)label_end;
                environment.loadObjectHas(method, lookup.object(), lookup.name());
                Label label_false = new Label();
                Label label_end2 = new Label();
                method.visitJumpInsn(153, label_false);
                BinaryOperationNode.writeNode(this.left, method, environment, breakLabel, continueLabel);
                method.visitJumpInsn(167, label_end2);
                method.visitLabel(label_false);
                BinaryOperationNode.writeNode(this.right, method, environment, breakLabel, continueLabel);
                method.visitLabel(label_end2);
                break;
            }
            case MULTIPLY: {
                if (environment.optimize() && this.tryWriteNegate(method, environment, breakLabel, continueLabel)) {
                    return;
                }
                BinaryOperationNode.writeNode(this.left, method, environment, breakLabel, continueLabel);
                BinaryOperationNode.writeNode(this.right, method, environment, breakLabel, continueLabel);
                method.visitInsn(106);
                break;
            }
            case DIVIDE: {
                if (environment.optimize() && this.tryWriteNegate(method, environment, breakLabel, continueLabel)) {
                    return;
                }
                BinaryOperationNode.writeNode(this.left, method, environment, breakLabel, continueLabel);
                BinaryOperationNode.writeNode(this.right, method, environment, breakLabel, continueLabel);
                method.visitInsn(110);
                break;
            }
            default: {
                BinaryOperationNode.writeNode(this.left, method, environment, breakLabel, continueLabel);
                BinaryOperationNode.writeNode(this.right, method, environment, breakLabel, continueLabel);
                switch (this.operator) {
                    case ADD: {
                        method.visitInsn(98);
                        break block0;
                    }
                    case SUBTRACT: {
                        method.visitInsn(102);
                        break block0;
                    }
                    case EQUALS: {
                        BinaryOperationNode.writeComparision(method, 154);
                        break block0;
                    }
                    case NOT_EQUALS: {
                        BinaryOperationNode.writeComparision(method, 153);
                        break block0;
                    }
                    case LESS_EQUALS: {
                        BinaryOperationNode.writeComparision(method, 157);
                        break block0;
                    }
                    case LESS: {
                        BinaryOperationNode.writeComparision(method, 156);
                        break block0;
                    }
                    case GREATER_EQUALS: {
                        BinaryOperationNode.writeComparision(method, 155);
                        break block0;
                    }
                    case GREATER: {
                        BinaryOperationNode.writeComparision(method, 158);
                    }
                }
            }
        }
    }

    private boolean tryWriteNegate(MethodNode method, MolangBytecodeEnvironment environment, @Nullable Label breakLabel, @Nullable Label continueLabel) throws MolangException {
        float right;
        if (this.left.isConstant()) {
            float left = this.left.evaluate(environment);
            if (left == -1.0f) {
                this.right.writeBytecode(method, environment, breakLabel, continueLabel);
                method.visitInsn(118);
                return true;
            }
        } else if (this.right.isConstant() && (right = this.right.evaluate(environment)) == -1.0f) {
            this.left.writeBytecode(method, environment, breakLabel, continueLabel);
            method.visitInsn(118);
            return true;
        }
        return false;
    }

    private static void writeNode(Node node, MethodNode method, MolangBytecodeEnvironment environment, @Nullable Label breakLabel, @Nullable Label continueLabel) throws MolangException {
        if (environment.optimize() && node.isConstant()) {
            BytecodeCompiler.writeFloatConst(method, node.evaluate(environment));
        } else {
            node.writeBytecode(method, environment, breakLabel, continueLabel);
        }
    }

    private static void writeComparision(MethodNode method, int success) {
        Label label_false = new Label();
        Label label_end = new Label();
        method.visitInsn(149);
        method.visitJumpInsn(success, label_false);
        method.visitInsn(12);
        method.visitJumpInsn(167, label_end);
        method.visitLabel(label_false);
        method.visitInsn(11);
        method.visitLabel(label_end);
    }
}

