/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.molangcompiler.core.ast;

import gg.moonflower.molangcompiler.api.exception.MolangException;
import gg.moonflower.molangcompiler.core.ast.Node;
import gg.moonflower.molangcompiler.core.compiler.BytecodeCompiler;
import gg.moonflower.molangcompiler.core.compiler.MolangBytecodeEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.MethodNode;

@ApiStatus.Internal
public record LoopNode(Node iterations, Node body) implements Node
{
    @Override
    public String toString() {
        return "loop(" + this.iterations + ", {" + this.body + "})";
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public void writeBytecode(MethodNode method, MolangBytecodeEnvironment environment, @Nullable Label breakLabel, @Nullable Label continueLabel) throws MolangException {
        Label begin = new Label();
        Label next = new Label();
        Label end = new Label();
        this.iterations.writeBytecode(method, environment, breakLabel, continueLabel);
        method.visitInsn(139);
        BytecodeCompiler.writeIntConst(method, 0);
        method.visitLabel(begin);
        this.body.writeBytecode(method, environment, end, next);
        if (this.body.hasValue()) {
            method.visitInsn(87);
        }
        method.visitLabel(next);
        method.visitInsn(4);
        method.visitInsn(96);
        method.visitInsn(92);
        method.visitJumpInsn(163, begin);
        method.visitLabel(end);
    }
}

