/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.molangcompiler.core.ast;

import gg.moonflower.molangcompiler.api.exception.MolangException;
import gg.moonflower.molangcompiler.core.ast.Node;
import gg.moonflower.molangcompiler.core.ast.OptionalValueNode;
import gg.moonflower.molangcompiler.core.compiler.MolangBytecodeEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.MethodNode;

@ApiStatus.Internal
public record VariableSetNode(String object, String name, Node value, boolean returnValue) implements OptionalValueNode
{
    public VariableSetNode(String object, String name, Node value) {
        this(object, name, value, false);
    }

    @Override
    public String toString() {
        return this.object + "." + this.name + " = " + this.value;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return this.returnValue;
    }

    @Override
    public void writeBytecode(MethodNode method, MolangBytecodeEnvironment environment, @Nullable Label breakLabel, @Nullable Label continueLabel) throws MolangException {
        if (!"temp".equals(this.object)) {
            environment.getObjectIndex(method, this.object);
        }
        this.value.writeBytecode(method, environment, breakLabel, continueLabel);
        if (this.returnValue) {
            method.visitInsn(89);
        }
        int index = environment.allocateVariable(this.object + "." + this.name);
        method.visitVarInsn(56, index);
        environment.markDirty(this.object, this.name);
    }

    @Override
    public VariableSetNode withReturnValue() {
        return this.returnValue ? this : new VariableSetNode(this.object, this.name, this.value, true);
    }
}

