/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.core.component;

import de.tomalbrc.bil.api.Animator;
import de.tomalbrc.bil.core.component.ComponentBase;
import de.tomalbrc.bil.core.holder.base.AbstractAnimationHolder;
import de.tomalbrc.bil.core.holder.wrapper.AbstractWrapper;
import de.tomalbrc.bil.core.model.Animation;
import de.tomalbrc.bil.core.model.Frame;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.core.model.Pose;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationComponent
extends ComponentBase
implements Animator {
    private final Object2ObjectOpenHashMap<String, AnimationPlayer> animationMap = new Object2ObjectOpenHashMap();
    private final CopyOnWriteArrayList<AnimationPlayer> animationPlayerList = new CopyOnWriteArrayList();

    public AnimationComponent(Model model, AbstractAnimationHolder holder) {
        super(model, holder);
    }

    @Override
    public void playAnimation(String name, int priority, boolean restartPaused, IntConsumer onFrame, Runnable onFinish) {
        AnimationPlayer animationPlayer = (AnimationPlayer)this.animationMap.get((Object)name);
        if (priority < 0) {
            priority = 0;
        }
        if (animationPlayer == null) {
            Animation animation = (Animation)this.model.animations().get((Object)name);
            if (animation != null) {
                this.addAnimationPlayer(new AnimationPlayer(name, animation, this.holder, priority, onFrame, onFinish));
            }
        } else {
            animationPlayer.onFrameCallback = onFrame;
            animationPlayer.onFinishCallback = onFinish;
            if (animationPlayer.state == AnimationPlayer.State.PAUSED) {
                if (restartPaused) {
                    animationPlayer.resetFrameCounter(false);
                }
                animationPlayer.state = AnimationPlayer.State.PLAYING;
            }
            if (priority != animationPlayer.priority) {
                animationPlayer.priority = priority;
                Collections.sort(this.animationPlayerList);
            }
        }
    }

    @Override
    public void setAnimationFrame(String name, int frame) {
        AnimationPlayer animationPlayer = (AnimationPlayer)this.animationMap.get((Object)name);
        if (animationPlayer != null) {
            animationPlayer.skipToFrame(frame);
        }
    }

    @Override
    public void pauseAnimation(String name) {
        AnimationPlayer animationPlayer = (AnimationPlayer)this.animationMap.get((Object)name);
        if (animationPlayer != null && animationPlayer.state == AnimationPlayer.State.PLAYING) {
            animationPlayer.state = AnimationPlayer.State.PAUSED;
        }
    }

    @Override
    public void stopAnimation(String name) {
        AnimationPlayer animationPlayer = (AnimationPlayer)this.animationMap.remove((Object)name);
        if (animationPlayer != null) {
            this.animationPlayerList.remove(animationPlayer);
        }
    }

    private void addAnimationPlayer(AnimationPlayer animationPlayer) {
        this.animationMap.put((Object)animationPlayer.name, (Object)animationPlayer);
        if (this.animationPlayerList.size() > 0 && animationPlayer.priority > 0) {
            int index = Collections.binarySearch(this.animationPlayerList, animationPlayer);
            this.animationPlayerList.add(index < 0 ? -index - 1 : index, animationPlayer);
        } else {
            this.animationPlayerList.add(animationPlayer);
        }
    }

    public void tickAnimations() {
        for (int index = this.animationPlayerList.size() - 1; index >= 0; --index) {
            AnimationPlayer animationPlayer = this.animationPlayerList.get(index);
            if (animationPlayer.hasFinished()) {
                this.animationMap.remove((Object)animationPlayer.name);
                this.animationPlayerList.remove(index);
                animationPlayer.onFinished();
                continue;
            }
            animationPlayer.tick();
        }
    }

    @Nullable
    public Pose findPose(AbstractWrapper wrapper) {
        UUID uuid = wrapper.node().uuid();
        Pose pose = null;
        for (AnimationPlayer animationPlayer : this.animationPlayerList) {
            if (!this.canAnimationAffect(animationPlayer, uuid)) continue;
            if (animationPlayer.inResetState()) {
                pose = wrapper.getDefaultPose();
                continue;
            }
            pose = this.findAnimationPose(wrapper, animationPlayer, uuid);
            if (pose == null) continue;
            return pose;
        }
        if (pose != null) {
            wrapper.setLastPose(pose, null);
        }
        return pose;
    }

    private boolean canAnimationAffect(AnimationPlayer anim, UUID uuid) {
        boolean canAnimate = anim.inResetState() || anim.shouldAnimate();
        return canAnimate && anim.animation.isAffected(uuid);
    }

    @Nullable
    private Pose findAnimationPose(AbstractWrapper wrapper, AnimationPlayer anim, UUID uuid) {
        int startIndex;
        Animation animation = anim.animation;
        Frame frame = anim.currentFrame;
        if (frame == null) {
            return null;
        }
        Pose pose = (Pose)frame.poses().get((Object)uuid);
        if (pose != null) {
            wrapper.setLastPose(pose, animation);
            return pose;
        }
        if (animation == wrapper.getLastAnimation()) {
            return wrapper.getLastPose();
        }
        Frame[] frames = animation.frames();
        for (int i = startIndex = frames.length - 1 - Math.max(anim.frameCounter - 1, 0); i >= 0; --i) {
            pose = (Pose)frames[i].poses().get((Object)uuid);
            if (pose == null) continue;
            wrapper.setLastPose(pose, animation);
            return pose;
        }
        return null;
    }

    private static class AnimationPlayer
    implements Comparable<AnimationPlayer> {
        @NotNull
        private final Animation animation;
        private final AbstractAnimationHolder holder;
        private final String name;
        private Frame currentFrame;
        private int frameCounter = -1;
        private int priority;
        private boolean looped;
        private State state;
        @Nullable
        private IntConsumer onFrameCallback;
        @Nullable
        private Runnable onFinishCallback;

        private AnimationPlayer(String name, @NotNull Animation animation, AbstractAnimationHolder holder, int priority, @Nullable IntConsumer onFrame, @Nullable Runnable onFinish) {
            this.name = name;
            this.holder = holder;
            this.animation = animation;
            this.state = State.PLAYING;
            this.priority = priority;
            this.onFrameCallback = onFrame;
            this.onFinishCallback = onFinish;
            this.resetFrameCounter(false);
        }

        private void onFinished() {
            if (this.onFinishCallback != null) {
                this.onFinishCallback.run();
            }
        }

        private void tick() {
            if (this.frameCounter < 0) {
                this.onFramesFinished();
                return;
            }
            if (this.shouldAnimate()) {
                this.updateFrame();
                --this.frameCounter;
            }
        }

        private void updateFrame() {
            Frame[] frames = this.animation.frames();
            if (this.frameCounter >= 0 && this.frameCounter < frames.length) {
                int index = frames.length - 1 - this.frameCounter;
                this.currentFrame = frames[index];
                if (this.onFrameCallback != null) {
                    this.onFrameCallback.accept(index);
                }
                if (this.currentFrame.requiresUpdates()) {
                    this.currentFrame.runEffects(this.holder);
                }
            }
        }

        private void skipToFrame(int frame) {
            this.frameCounter = this.animation.duration() - 1 - frame;
        }

        private void resetFrameCounter(boolean isLooping) {
            this.frameCounter = this.animation.duration() - 1 + (isLooping ? this.animation.loopDelay() : this.animation.startDelay());
        }

        private void onFramesFinished() {
            switch (this.animation.loopMode()) {
                case ONCE: {
                    if (this.state == State.FINISHED_RESET_DEFAULT) {
                        this.state = State.FINISHED;
                        break;
                    }
                    this.state = State.FINISHED_RESET_DEFAULT;
                    break;
                }
                case HOLD: {
                    this.state = State.FINISHED;
                    break;
                }
                case LOOP: {
                    this.resetFrameCounter(true);
                    this.looped = true;
                }
            }
        }

        private boolean inLoopDelay() {
            return this.animation.loopDelay() > 0 && this.looped && this.frameCounter >= this.animation.duration() - this.animation.loopDelay();
        }

        private boolean inStartDelay() {
            return this.animation.startDelay() > 0 && this.frameCounter >= this.animation.duration() - (this.looped ? 0 : this.animation.startDelay());
        }

        public boolean inResetState() {
            return this.state == State.FINISHED_RESET_DEFAULT;
        }

        public boolean hasFinished() {
            return this.state == State.FINISHED;
        }

        public boolean shouldAnimate() {
            return this.state != State.PAUSED && this.state != State.FINISHED && !this.inLoopDelay() && !this.inStartDelay();
        }

        @Override
        public int compareTo(@NotNull AnimationPlayer other) {
            return Integer.compare(other.priority, this.priority);
        }

        private static enum State {
            PLAYING,
            PAUSED,
            FINISHED_RESET_DEFAULT,
            FINISHED;

        }
    }
}

