/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.core.holder.base;

import de.tomalbrc.bil.api.AnimatedHolder;
import de.tomalbrc.bil.api.Animator;
import de.tomalbrc.bil.core.component.AnimationComponent;
import de.tomalbrc.bil.core.component.VariantComponent;
import de.tomalbrc.bil.core.holder.base.AbstractElementHolder;
import de.tomalbrc.bil.core.holder.wrapper.AbstractWrapper;
import de.tomalbrc.bil.core.holder.wrapper.Bone;
import de.tomalbrc.bil.core.holder.wrapper.DisplayWrapper;
import de.tomalbrc.bil.core.holder.wrapper.Locator;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.core.model.Node;
import de.tomalbrc.bil.core.model.Pose;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.polymer.virtualentity.api.tracker.DisplayTrackedData;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_3218;
import net.minecraft.class_811;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public abstract class AbstractAnimationHolder
extends AbstractElementHolder
implements AnimatedHolder {
    protected final Model model;
    protected final AnimationComponent animationComponent;
    protected final VariantComponent variantComponent;
    protected final Object2ObjectOpenHashMap<String, Locator> locatorMap;
    protected Bone[] bones;
    protected Locator[] locators;
    protected float scale = 1.0f;
    protected int color = -1;

    protected AbstractAnimationHolder(Model model, class_3218 level) {
        super(level);
        this.model = model;
        this.animationComponent = new AnimationComponent(model, this);
        this.variantComponent = new VariantComponent(model, this);
        this.locatorMap = new Object2ObjectOpenHashMap();
    }

    @Override
    protected final void initializeElements() {
        ObjectArrayList bones = new ObjectArrayList();
        this.setupElements((List<Bone>)bones);
        this.locators = new Locator[this.locatorMap.size()];
        this.bones = new Bone[bones.size()];
        int index = 0;
        for (Locator locator : this.locatorMap.values()) {
            this.locators[index++] = locator;
        }
        for (index = 0; index < bones.size(); ++index) {
            this.bones[index] = (Bone)bones.get(index);
        }
    }

    @Nullable
    protected ItemDisplayElement createBoneDisplay(PolymerModelData modelData) {
        if (modelData == null) {
            return null;
        }
        ItemDisplayElement element = new ItemDisplayElement();
        element.setModelTransformation(class_811.field_4316);
        element.setInvisible(true);
        element.setInterpolationDuration(3);
        element.getDataTracker().set(DisplayTrackedData.TELEPORTATION_DURATION, (Object)3);
        class_1799 itemStack = new class_1799((class_1935)modelData.item());
        itemStack.method_57379(class_9334.field_49637, (Object)modelData.asComponent());
        itemStack.method_57379(class_9334.field_49644, (Object)new class_9282(-1, false));
        element.setItem(itemStack);
        return element;
    }

    protected void setupElements(List<Bone> bones) {
        block4: for (Node node : this.model.nodeMap().values()) {
            Pose defaultPose = (Pose)this.model.defaultPose().get((Object)node.uuid());
            switch (node.type()) {
                case BONE: {
                    ItemDisplayElement bone = this.createBoneDisplay(node.modelData());
                    if (bone == null) continue block4;
                    bones.add(Bone.of(bone, node, defaultPose));
                    this.addElement((VirtualElement)bone);
                    break;
                }
                case LOCATOR: {
                    this.locatorMap.put((Object)node.name(), (Object)Locator.of(node, defaultPose));
                }
            }
        }
    }

    @Override
    protected void onDataLoaded() {
        for (Bone bone : this.bones) {
            this.initializeDisplay(bone);
        }
    }

    @Override
    protected boolean shouldSkipTick() {
        return false;
    }

    protected void onTick() {
        this.animationComponent.tickAnimations();
    }

    @Override
    protected void onAsyncTick() {
        for (Bone bone : this.bones) {
            this.updateElement(bone);
        }
        for (AbstractWrapper abstractWrapper : this.locators) {
            this.updateLocator((Locator)abstractWrapper);
        }
    }

    protected void updateElement(DisplayWrapper<?> display) {
        this.updateElement(display, this.animationComponent.findPose(display));
    }

    public void initializeDisplay(DisplayWrapper<?> display) {
        this.updateElement(display, display.getDefaultPose());
    }

    public void updateElement(DisplayWrapper<?> display, @Nullable Pose pose) {
        if (pose != null) {
            this.applyPose(pose, display);
        }
    }

    protected void updateLocator(Locator locator) {
        Pose pose;
        if (locator.requiresUpdate() && (pose = this.animationComponent.findPose(locator)) != null) {
            locator.updateListeners(this, pose);
        }
    }

    protected void applyPose(Pose pose, DisplayWrapper<?> display) {
        if (this.scale != 1.0f) {
            display.element().setScale((Vector3fc)pose.scale().mul(this.scale));
            display.element().setTranslation((Vector3fc)pose.translation().mul(this.scale));
        } else {
            display.element().setScale(pose.readOnlyScale());
            display.element().setTranslation(pose.readOnlyTranslation());
        }
        display.element().setLeftRotation(pose.readOnlyLeftRotation());
        display.element().setRightRotation(pose.readOnlyRightRotation());
        display.element().startInterpolationIfDirty();
    }

    @Override
    public void setColor(int color) {
        if (color != this.color) {
            this.color = color;
            for (Bone bone : this.bones) {
                bone.updateColor(color);
            }
        }
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public Locator getLocator(String name) {
        return (Locator)this.locatorMap.get((Object)name);
    }

    @Override
    public VariantComponent getVariantController() {
        return this.variantComponent;
    }

    @Override
    public Animator getAnimator() {
        return this.animationComponent;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    public Bone[] getBones() {
        return this.bones;
    }

    public Locator[] getLocators() {
        return this.locators;
    }

    public abstract class_2168 createCommandSourceStack();
}

