/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.core.model;

import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import java.util.UUID;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record Node(NodeType type, Node parent, Transform transform, String name, UUID uuid, PolymerModelData modelData, boolean headTag) {

    public static enum NodeType {
        BONE,
        LOCATOR;

    }

    public static final class Transform {
        private final Vector3f origin;
        private final Quaternionf rotation;
        private final float scale;
        private Matrix4f globalTransform;

        public Transform(Vector3f origin, Quaternionf rotation, float scale) {
            this.origin = origin;
            this.rotation = rotation;
            this.scale = scale;
            this.globalTransform = new Matrix4f().translate((Vector3fc)origin).rotate((Quaternionfc)rotation);
        }

        public Transform mul(Transform other) {
            this.globalTransform = other.globalTransform.mul((Matrix4fc)this.globalTransform, new Matrix4f());
            return this;
        }

        public Transform mul(Matrix4f other) {
            this.globalTransform = other.mul((Matrix4fc)this.globalTransform);
            return this;
        }

        public Vector3fc origin() {
            return this.origin;
        }

        public Quaternionfc rotation() {
            return this.rotation;
        }

        public float scale() {
            return this.scale;
        }

        public Matrix4f globalTransform() {
            return this.globalTransform;
        }
    }
}

