/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.core.model;

import net.minecraft.class_7837;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record Pose(Vector3f translation, Vector3f scale, Quaternionf leftRotation, Quaternionf rightRotation) {
    private final Vector3f translation;
    private final Vector3f scale;
    private final Quaternionf leftRotation;
    private final Quaternionf rightRotation;

    public static Pose of(Matrix4f matrix4f) {
        Matrix3f matrix3f = new Matrix3f((Matrix4fc)matrix4f);
        Vector3f translation = matrix4f.getTranslation(new Vector3f());
        float multiplier = 1.0f / matrix4f.m33();
        if (multiplier != 1.0f) {
            matrix3f.scale(multiplier);
            translation.mul(multiplier);
        }
        Triple triple = class_7837.method_46412((Matrix3f)matrix3f);
        Vector3f scale = (Vector3f)triple.getMiddle();
        Quaternionf leftRotation = (Quaternionf)triple.getLeft();
        Quaternionf rightRotation = (Quaternionf)triple.getRight();
        return new Pose(translation, scale, leftRotation, rightRotation);
    }

    public Vector3fc readOnlyTranslation() {
        return this.translation;
    }

    public Vector3fc readOnlyScale() {
        return this.scale;
    }

    public Quaternionfc readOnlyLeftRotation() {
        return this.leftRotation;
    }

    public Quaternionfc readOnlyRightRotation() {
        return this.rightRotation;
    }

    public Vector3f translation() {
        return new Vector3f((Vector3fc)this.translation);
    }

    public Vector3f scale() {
        return new Vector3f((Vector3fc)this.scale);
    }

    public Quaternionf leftRotation() {
        return new Quaternionf((Quaternionfc)this.leftRotation);
    }

    public Quaternionf rightRotation() {
        return new Quaternionf((Quaternionfc)this.rightRotation);
    }
}

