/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.file.extra;

import de.tomalbrc.bil.file.bbmodel.BbElement;
import de.tomalbrc.bil.file.bbmodel.BbGroup;
import de.tomalbrc.bil.file.bbmodel.BbModel;
import de.tomalbrc.bil.file.bbmodel.BbOutliner;
import de.tomalbrc.bil.file.bbmodel.BbTexture;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;

public class BbModelUtils {
    public static BbElement getElement(BbModel model, UUID uuid) {
        for (BbElement element : model.elements) {
            if (element.uuid != uuid) continue;
            return element;
        }
        return null;
    }

    public static BbTexture getTexture(BbModel model, UUID uuid) {
        for (BbTexture element : model.textures) {
            if (element.uuid != uuid) continue;
            return element;
        }
        return null;
    }

    public static List<BbOutliner> modelOutliner(BbModel model) {
        ObjectArrayList list = new ObjectArrayList();
        ObjectArrayList children = new ObjectArrayList();
        for (BbOutliner.ChildEntry entry : model.outliner) {
            if (entry.isNode()) {
                if (entry.outliner.hasModel() && !entry.outliner.isHitbox()) {
                    list.add(entry.outliner);
                }
                BbModelUtils.findModelOutlinerChildren(model, (List<BbOutliner>)list, entry.outliner);
                continue;
            }
            children.add(entry);
        }
        if (!children.isEmpty()) {
            BbOutliner.ChildEntry entry;
            BbOutliner root = new BbOutliner();
            root.uuid = ((BbOutliner.ChildEntry)children.getFirst()).uuid;
            root.export = true;
            root.children = children;
            list.add(root);
            entry = new BbOutliner.ChildEntry();
            entry.outliner = root;
            model.outliner.add((Object)entry);
        }
        return list;
    }

    public static void findModelOutlinerChildren(BbModel model, List<BbOutliner> list, BbOutliner x) {
        for (BbOutliner.ChildEntry child : x.children) {
            if (!child.isNode()) continue;
            if (child.outliner.hasModel() && !child.outliner.isHitbox()) {
                list.add(child.outliner);
            }
            BbModelUtils.findModelOutlinerChildren(model, list, child.outliner);
        }
    }

    public static BbOutliner getParent(BbModel model, BbElement element) {
        for (BbOutliner.ChildEntry entry : model.outliner) {
            BbOutliner res;
            if (!entry.isNode() || (res = BbModelUtils.findParent(model, entry.outliner, element)) == null) continue;
            return res;
        }
        return null;
    }

    public static BbGroup getGroup(BbModel model, BbOutliner outliner) {
        if (outliner != null) {
            for (BbGroup entry : model.groups) {
                if (!entry.uuid.equals(outliner.uuid)) continue;
                return entry;
            }
        }
        return outliner == null ? null : new BbGroup(outliner.uuid);
    }

    public static BbGroup getGroup(BbModel model, BbOutliner.ChildEntry outliner) {
        if (outliner != null) {
            for (BbGroup entry : model.groups) {
                if (!entry.uuid.equals(outliner.uuid)) continue;
                return entry;
            }
        }
        return outliner == null ? null : new BbGroup(outliner.uuid);
    }

    public static BbOutliner findParent(BbModel model, BbOutliner x, BbElement element) {
        if (x.hasUuidChild(element.uuid)) {
            return x;
        }
        for (BbOutliner.ChildEntry child : x.children) {
            BbOutliner res;
            if (child.isNode() && child.outliner.hasUuidChild(element.uuid)) {
                return child.outliner;
            }
            if (!child.isNode() || (res = BbModelUtils.findParent(model, child.outliner, element)) == null) continue;
            return res;
        }
        return null;
    }

    public static List<BbElement> elementsForOutliner(BbModel model, BbOutliner outliner, BbElement.ElementType elementType) {
        ObjectArrayList elements = new ObjectArrayList();
        for (BbElement element : model.elements) {
            if (!outliner.hasUuidChild(element.uuid) || element.type != elementType) continue;
            elements.add(element);
        }
        return elements;
    }
}

