/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.file.extra;

import de.tomalbrc.bil.file.bbmodel.BbElement;
import de.tomalbrc.bil.file.bbmodel.BbFace;
import de.tomalbrc.bil.file.bbmodel.BbTexture;
import de.tomalbrc.bil.file.extra.BbResourcePackGenerator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2960;
import org.apache.commons.io.FilenameUtils;
import org.joml.Vector3f;

public class ResourcePackItemModel {
    public static DisplayTransform DEFAULT_TRANSFORM = new DisplayTransform(new Vector3f(0.0f, 180.0f, 0.0f), null, null);
    final String parent;
    final Map<String, class_2960> textures;
    final List<BbElement> elements;
    final Map<String, DisplayTransform> display;

    ResourcePackItemModel(String parent, Map<String, class_2960> textures, List<BbElement> elements, Map<String, DisplayTransform> transformMap) {
        this.parent = parent;
        this.textures = textures;
        if (this.textures != null && !this.textures.isEmpty() && !this.textures.containsKey("particle")) {
            this.textures.put("particle", this.textures.values().iterator().next());
        }
        this.elements = elements;
        this.display = Objects.requireNonNullElseGet(transformMap, Object2ObjectArrayMap::new);
    }

    public byte[] getBytes() {
        return BbResourcePackGenerator.gson.toJson((Object)this).getBytes(StandardCharsets.UTF_8);
    }

    public record DisplayTransform(Vector3f rotation, Vector3f translation, Vector3f scale) {
    }

    public static class Builder {
        final String modelId;
        String parent = null;
        Map<String, class_2960> textureMap = null;
        List<BbElement> elements = null;
        Map<String, DisplayTransform> transformMap = new Object2ObjectArrayMap();

        public Builder(String modelId) {
            this.modelId = modelId;
        }

        public Builder withParent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder withTextures(Int2ObjectOpenHashMap<BbTexture> intTextureMap) {
            this.textureMap = new Object2ObjectLinkedOpenHashMap();
            if (intTextureMap != null) {
                for (Int2ObjectMap.Entry entry : intTextureMap.int2ObjectEntrySet()) {
                    String str = FilenameUtils.getBaseName((String)((BbTexture)entry.getValue()).name.toLowerCase());
                    while (str.endsWith(".png")) {
                        str = str.substring(0, str.length() - 4);
                    }
                    this.textureMap.put(String.valueOf(entry.getIntKey()), class_2960.method_60655((String)"bil", (String)("item/" + this.modelId + "/" + str)));
                }
            }
            return this;
        }

        public Builder withElements(List<BbElement> elements) {
            this.elements = elements;
            return this;
        }

        public Builder addDisplayTransform(String transformName, DisplayTransform transform) {
            this.transformMap.put(transformName, transform);
            return this;
        }

        public ResourcePackItemModel build() {
            Object2ObjectLinkedOpenHashMap optimizedTextureMap = new Object2ObjectLinkedOpenHashMap();
            if (this.elements != null) {
                for (BbElement element : this.elements) {
                    for (Map.Entry stringBbFaceEntry : element.faces.entrySet()) {
                        String n = String.valueOf(((BbFace)stringBbFaceEntry.getValue()).texture);
                        optimizedTextureMap.put(n, this.textureMap.get(n));
                    }
                }
            }
            return new ResourcePackItemModel(this.parent, (Map<String, class_2960>)optimizedTextureMap, this.elements, this.transformMap);
        }
    }
}

