/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.file.importer;

import de.tomalbrc.bil.core.model.Frame;
import de.tomalbrc.bil.core.model.Variant;
import de.tomalbrc.bil.file.ajmodel.AjVariant;
import de.tomalbrc.bil.file.bbmodel.BbAnimation;
import de.tomalbrc.bil.file.bbmodel.BbAnimator;
import de.tomalbrc.bil.file.bbmodel.BbElement;
import de.tomalbrc.bil.file.bbmodel.BbKeyframe;
import de.tomalbrc.bil.file.bbmodel.BbModel;
import de.tomalbrc.bil.file.bbmodel.BbOutliner;
import de.tomalbrc.bil.file.bbmodel.BbTexture;
import de.tomalbrc.bil.file.extra.BbModelUtils;
import de.tomalbrc.bil.file.extra.BbResourcePackGenerator;
import de.tomalbrc.bil.file.extra.ResourcePackItemModel;
import de.tomalbrc.bil.file.importer.BbModelImporter;
import de.tomalbrc.bil.file.importer.ModelImporter;
import de.tomalbrc.bil.json.CachedUuidDeserializer;
import de.tomalbrc.bil.util.command.CommandParser;
import de.tomalbrc.bil.util.command.ParsedCommand;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class AjModelImporter
extends BbModelImporter
implements ModelImporter<BbModel> {
    public AjModelImporter(BbModel model) {
        super(model);
    }

    @NotNull
    private ReferenceOpenHashSet<UUID> affectedBones(AjVariant variant) {
        ReferenceOpenHashSet affectedBoneIds = new ReferenceOpenHashSet();
        if (variant.affectedBones() != null && !variant.affectedBones().isEmpty()) {
            for (AjVariant.AffectedBoneEntry entry : variant.affectedBones()) {
                affectedBoneIds.add((Object)entry.value());
            }
        }
        return affectedBoneIds;
    }

    @Override
    @NotNull
    protected Reference2ObjectOpenHashMap<UUID, Variant> variants() {
        if (this.model.ajMeta != null && this.model.ajMeta.variants() != null) {
            Reference2ObjectOpenHashMap res = new Reference2ObjectOpenHashMap();
            for (AjVariant variant : this.model.ajMeta.variants()) {
                if (variant.name().equals("default")) continue;
                ReferenceOpenHashSet<UUID> affectedBones = this.affectedBones(variant);
                Reference2ObjectOpenHashMap models = new Reference2ObjectOpenHashMap();
                for (BbOutliner outliner : BbModelUtils.modelOutliner(this.model)) {
                    boolean affected;
                    boolean bl = affected = affectedBones.contains((Object)outliner.uuid) && variant.affectedBonesIsAWhitelist() || !variant.affectedBonesIsAWhitelist() && !affectedBones.contains((Object)outliner.uuid);
                    if (outliner.isHitbox() || !affected) continue;
                    List<BbElement> elements = BbModelUtils.elementsForOutliner(this.model, outliner, BbElement.ElementType.CUBE);
                    Int2ObjectOpenHashMap<BbTexture> textureMap = new Int2ObjectOpenHashMap<BbTexture>();
                    if (variant.textureMap() == null || variant.textureMap().isEmpty()) {
                        textureMap = this.makeDefaultTextureMap();
                    } else {
                        for (BbTexture e : this.model.textures) {
                            BbTexture newMapped = variant.textureMap().containsKey((Object)e.uuid) ? BbModelUtils.getTexture(this.model, (UUID)variant.textureMap().get((Object)e.uuid)) : e;
                            textureMap.put(e.id, (Object)newMapped);
                        }
                    }
                    ResourcePackItemModel.Builder builder = new ResourcePackItemModel.Builder(this.model.modelIdentifier).withTextures(textureMap).withElements(elements).addDisplayTransform("head", ResourcePackItemModel.DEFAULT_TRANSFORM);
                    class_2960 location = BbResourcePackGenerator.addModelPart(this.model, String.format("%s_%s", outliner.uuid.toString(), variant.name().toLowerCase()), builder.build());
                    PolymerModelData modelData = PolymerResourcePackUtils.requestModel((class_1792)class_1802.field_18138, (class_2960)location);
                    models.put((Object)outliner.uuid, (Object)modelData);
                }
                res.put((Object)variant.uuid(), (Object)new Variant(variant.name(), variant.uuid(), (Reference2ObjectOpenHashMap<UUID, PolymerModelData>)models, affectedBones, variant.affectedBonesIsAWhitelist()));
            }
            return res;
        }
        return new Reference2ObjectOpenHashMap();
    }

    @Override
    protected Frame.Variant frameVariant(BbAnimation anim, float t) {
        UUID effectsUUID = CachedUuidDeserializer.get("effects");
        if (effectsUUID != null && anim.animators != null && anim.animators.containsKey(effectsUUID)) {
            BbAnimator animator = anim.animators.get(effectsUUID);
            if (animator.type == BbAnimator.Type.effect) {
                for (BbKeyframe kf : animator.keyframes) {
                    if (!(Math.abs(kf.time - t) < 0.15f) || kf.channel != BbKeyframe.Channel.variants) continue;
                    UUID key = CachedUuidDeserializer.get(kf.dataPoints.get(0).get("variant").getStringValue());
                    ParsedCommand[] cond = kf.dataPoints.get(0).containsKey("executeCondition") ? CommandParser.parse(kf.dataPoints.get(0).get("executeCondition").getStringValue()) : null;
                    return new Frame.Variant(key, cond);
                }
            }
        }
        return null;
    }

    @Override
    protected Frame.Commands frameCommands(BbAnimation anim, float t) {
        UUID effectsUUID = CachedUuidDeserializer.get("effects");
        if (effectsUUID != null && anim.animators != null && anim.animators.containsKey(effectsUUID) && anim.animators.get((Object)effectsUUID).type == BbAnimator.Type.effect) {
            BbAnimator animator = anim.animators.get(effectsUUID);
            for (BbKeyframe kf : animator.keyframes) {
                String script;
                float difference = (float)class_3532.method_15386((float)(kf.time / 0.05f)) * 0.05f;
                if (difference != t || kf.channel != BbKeyframe.Channel.commands || (script = kf.dataPoints.get(0).get("commands").getStringValue()).isEmpty()) continue;
                ParsedCommand[] cmds = CommandParser.parse(kf.dataPoints.get(0).get("commands").getStringValue());
                ParsedCommand[] cond = kf.dataPoints.get(0).containsKey("executeCondition") ? CommandParser.parse(kf.dataPoints.get(0).get("executeCondition").getStringValue()) : null;
                return new Frame.Commands(cmds, cond);
            }
        }
        return null;
    }

    @Override
    protected class_3414 frameSound(BbAnimation anim, float t) {
        UUID effectsUUID = CachedUuidDeserializer.get("effects");
        if (effectsUUID != null && anim.animators != null && anim.animators.containsKey(effectsUUID) && anim.animators.get((Object)effectsUUID).type == BbAnimator.Type.effect) {
            BbAnimator animator = anim.animators.get(effectsUUID);
            for (BbKeyframe kf : animator.keyframes) {
                float difference = (float)class_3532.method_15386((float)(kf.time / 0.05f)) * 0.05f;
                if (difference == t && kf.channel == BbKeyframe.Channel.sound && kf.dataPoints.get(0).containsKey("sound")) {
                    return (class_3414)class_7923.field_41172.method_10223(class_2960.method_60654((String)kf.dataPoints.get(0).get("sound").getStringValue()));
                }
                super.frameSound(anim, t);
            }
        }
        return null;
    }
}

