/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.tomalbrc.bil.file.bbmodel.BbElement;
import java.lang.reflect.Type;
import java.util.List;
import org.joml.Vector3f;

public class ElementSerializer
implements JsonSerializer<BbElement> {
    String getAxis(Vector3f v) {
        if (v != null) {
            List<String> axis = List.of("x", "y", "z");
            for (int i = 0; i < 3; ++i) {
                if (!(Math.abs(v.get(i)) > 0.0f)) continue;
                return axis.get(i);
            }
        }
        return "y";
    }

    float getAngle(Vector3f v) {
        if (v != null && v.length() > 1.0E-4f) {
            for (int i = 0; i < 3; ++i) {
                if (!(Math.abs(v.get(i)) > 0.0f)) continue;
                return v.get(i);
            }
        }
        return 0.0f;
    }

    public JsonElement serialize(BbElement src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.add("from", context.serialize((Object)src.from));
        obj.add("to", context.serialize((Object)src.to));
        obj.add("faces", context.serialize(src.faces));
        if (src.origin.length() > 0.0f || src.rotation != null && src.rotation.length() > 1.0E-4f) {
            JsonObject rot = new JsonObject();
            rot.addProperty("axis", this.getAxis(src.rotation));
            rot.addProperty("angle", (Number)Float.valueOf(this.getAngle(src.rotation)));
            rot.add("origin", context.serialize((Object)src.origin));
            obj.add("rotation", (JsonElement)rot);
        }
        return obj;
    }
}

