/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.molangcompiler.core.compiler;

import gg.moonflower.molangcompiler.api.exception.MolangSyntaxException;
import gg.moonflower.molangcompiler.core.ast.BinaryConditionalNode;
import gg.moonflower.molangcompiler.core.ast.BinaryOperation;
import gg.moonflower.molangcompiler.core.ast.BinaryOperationNode;
import gg.moonflower.molangcompiler.core.ast.BreakNode;
import gg.moonflower.molangcompiler.core.ast.CompoundNode;
import gg.moonflower.molangcompiler.core.ast.ConstNode;
import gg.moonflower.molangcompiler.core.ast.ContinueNode;
import gg.moonflower.molangcompiler.core.ast.FunctionNode;
import gg.moonflower.molangcompiler.core.ast.LoopNode;
import gg.moonflower.molangcompiler.core.ast.MathNode;
import gg.moonflower.molangcompiler.core.ast.MathOperation;
import gg.moonflower.molangcompiler.core.ast.NegateNode;
import gg.moonflower.molangcompiler.core.ast.Node;
import gg.moonflower.molangcompiler.core.ast.OptionalValueNode;
import gg.moonflower.molangcompiler.core.ast.ReturnNode;
import gg.moonflower.molangcompiler.core.ast.ScopeNode;
import gg.moonflower.molangcompiler.core.ast.TernaryOperationNode;
import gg.moonflower.molangcompiler.core.ast.ThisNode;
import gg.moonflower.molangcompiler.core.ast.VariableGetNode;
import gg.moonflower.molangcompiler.core.ast.VariableSetNode;
import gg.moonflower.molangcompiler.core.compiler.MolangLexer;
import gg.moonflower.molangcompiler.core.compiler.TokenReader;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class MolangParser {
    public static Node parseTokens(MolangLexer.Token[] tokens) throws MolangSyntaxException {
        if (tokens.length == 0) {
            throw new MolangSyntaxException("Expected token");
        }
        return MolangParser.parseTokensUntil(new TokenReader(tokens), true, token -> false);
    }

    private static Node parseTokensUntil(TokenReader reader, boolean insertReturn, Predicate<MolangLexer.Token> filter) throws MolangSyntaxException {
        Node node;
        ArrayList<Node> nodes = new ArrayList<Node>(2);
        while (reader.canRead() && !filter.test(reader.peek())) {
            node = MolangParser.parseExpression(reader);
            nodes.add(node);
            if (!reader.canRead()) continue;
            MolangLexer.Token token = reader.peek();
            if (token.type().isTerminating()) {
                reader.skip();
                continue;
            }
            if (filter.test(token)) break;
            throw MolangParser.error("Trailing statement", reader);
        }
        if (nodes.isEmpty()) {
            throw new MolangSyntaxException("Expected node");
        }
        if (insertReturn && !((node = (Node)nodes.get(nodes.size() - 1)) instanceof ReturnNode)) {
            if (node instanceof OptionalValueNode) {
                OptionalValueNode setNode = (OptionalValueNode)node;
                node = setNode.withReturnValue();
            }
            nodes.set(nodes.size() - 1, new ReturnNode(node));
        }
        if (nodes.size() == 1) {
            return (Node)nodes.get(0);
        }
        return new CompoundNode((Node[])nodes.toArray(Node[]::new));
    }

    private static Node parseNode(TokenReader reader) throws MolangSyntaxException {
        Node node;
        MolangParser.expectLength(reader, 1);
        MolangLexer.Token token = reader.peek();
        block1 : switch (token.type()) {
            case RETURN: {
                boolean scope;
                reader.skip();
                Node value = MolangParser.parseExpression(reader);
                if (reader.canRead() && reader.peek().type().isTerminating()) {
                    reader.skip();
                }
                boolean bl = scope = reader.canRead() && reader.peek().type() == MolangLexer.TokenType.RIGHT_BRACE;
                if (reader.canRead() && !scope) {
                    throw MolangParser.error("Trailing statement", reader);
                }
                if (value instanceof OptionalValueNode) {
                    OptionalValueNode setNode = (OptionalValueNode)value;
                    value = setNode.withReturnValue();
                }
                ReturnNode returnNode = new ReturnNode(value);
                node = returnNode;
                break;
            }
            case LOOP: {
                Node node2;
                reader.skip();
                MolangParser.expect(reader, MolangLexer.TokenType.LEFT_PARENTHESIS);
                reader.skip();
                Node iterations = MolangParser.parseTokensUntil(reader, false, t -> t.type() == MolangLexer.TokenType.COMMA);
                MolangParser.expect(reader, MolangLexer.TokenType.COMMA);
                reader.skip();
                Node body = MolangParser.parseTokensUntil(reader, false, t -> t.type() == MolangLexer.TokenType.RIGHT_PARENTHESIS);
                MolangParser.expect(reader, MolangLexer.TokenType.RIGHT_PARENTHESIS);
                reader.skip();
                if (body instanceof ScopeNode) {
                    ScopeNode scopeNode = (ScopeNode)body;
                    node2 = scopeNode.node();
                } else {
                    node2 = body;
                }
                LoopNode loopNode = new LoopNode(iterations, node2);
                node = loopNode;
                break;
            }
            case CONTINUE: {
                reader.skip();
                ContinueNode continueNode = new ContinueNode();
                node = continueNode;
                break;
            }
            case BREAK: {
                reader.skip();
                BreakNode breakNode = new BreakNode();
                node = breakNode;
                break;
            }
            case IF: {
                reader.skip();
                MolangParser.expect(reader, MolangLexer.TokenType.LEFT_PARENTHESIS);
                reader.skip();
                Node condition = MolangParser.parseExpression(reader);
                MolangParser.expect(reader, MolangLexer.TokenType.RIGHT_PARENTHESIS);
                reader.skip();
                Node branch = MolangParser.parseExpression(reader);
                if (reader.canRead(2) && reader.peek().type().isTerminating() && reader.peekAfter(1).type() == MolangLexer.TokenType.ELSE) {
                    reader.skip(2);
                    TernaryOperationNode ternaryOperationNode = new TernaryOperationNode(condition, branch, MolangParser.parseExpression(reader));
                    node = ternaryOperationNode;
                    break;
                }
                BinaryConditionalNode binaryConditionalNode = new BinaryConditionalNode(condition, branch);
                node = binaryConditionalNode;
                break;
            }
            case THIS: {
                reader.skip();
                ThisNode thisNode = new ThisNode();
                node = thisNode;
                break;
            }
            case TRUE: {
                reader.skip();
                ConstNode constNode = new ConstNode(1.0f);
                node = constNode;
                break;
            }
            case FALSE: {
                reader.skip();
                ConstNode constNode = new ConstNode(0.0f);
                node = constNode;
                break;
            }
            case NUMERAL: {
                try {
                    float value = Integer.parseInt(reader.peek().value());
                    reader.skip();
                    if (reader.canRead() && reader.peek().type() == MolangLexer.TokenType.DOT) {
                        reader.skip();
                        MolangParser.expect(reader, MolangLexer.TokenType.NUMERAL);
                        String decimalString = reader.peek().value();
                        float decimal = Integer.parseInt(decimalString);
                        reader.skip();
                        if (decimal > 0.0f) {
                            value += (float)((double)decimal / Math.pow(10.0, decimalString.length()));
                        }
                    }
                    ConstNode constNode = new ConstNode(value);
                    node = constNode;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw MolangParser.error("Error parsing numeral", reader);
                }
            }
            case ALPHANUMERIC: {
                Node node3;
                node = node3 = MolangParser.parseAlphanumeric(reader);
                break;
            }
            case BINARY_OPERATION: {
                switch (token.value()) {
                    case "-": {
                        if (!reader.canRead(2) || !reader.peekAfter(1).type().canNegate()) {
                            throw MolangParser.error("Cannot negate " + reader.peekAfter(1), reader);
                        }
                        reader.skip();
                        BinaryOperationNode binaryOperationNode = new BinaryOperationNode(BinaryOperation.MULTIPLY, new ConstNode(-1.0f), MolangParser.parseNode(reader));
                        node = binaryOperationNode;
                        break block1;
                    }
                    case "+": {
                        Node node4;
                        if (!reader.canRead(2) || !reader.peekAfter(1).type().canNegate()) {
                            throw MolangParser.error("Cannot assign + to " + reader.peekAfter(1), reader);
                        }
                        reader.skip();
                        node = node4 = MolangParser.parseNode(reader);
                        break block1;
                    }
                }
                throw MolangParser.error("Expected +num or -num", reader);
            }
            case LEFT_PARENTHESIS: {
                Node node5;
                reader.skip();
                Node node6 = MolangParser.parseExpression(reader);
                MolangParser.expect(reader, MolangLexer.TokenType.RIGHT_PARENTHESIS);
                reader.skip();
                node = node5 = node6;
                break;
            }
            case LEFT_BRACE: {
                reader.skip();
                Node node7 = MolangParser.parseTokensUntil(reader, false, t -> t.type() == MolangLexer.TokenType.RIGHT_BRACE);
                MolangParser.expect(reader, MolangLexer.TokenType.RIGHT_BRACE);
                reader.skip();
                ScopeNode scopeNode = new ScopeNode(node7);
                node = scopeNode;
                break;
            }
            default: {
                throw MolangParser.error("Unexpected token", reader);
            }
        }
        return node;
    }

    public static Node parseExpression(TokenReader reader) throws MolangSyntaxException {
        Node result = MolangParser.parseNode(reader);
        while (reader.canRead()) {
            MolangLexer.Token token = reader.peek();
            if (token.type() == MolangLexer.TokenType.SEMICOLON || token.type().isOutOfScope()) {
                return result;
            }
            if (result instanceof OptionalValueNode) {
                OptionalValueNode setNode = (OptionalValueNode)result;
                result = setNode.withReturnValue();
            }
            block0 : switch (token.type()) {
                case NUMERAL: 
                case ALPHANUMERIC: 
                case LEFT_PARENTHESIS: 
                case LEFT_BRACE: {
                    if (result != null) {
                        throw MolangParser.error("Unexpected token", reader);
                    }
                    result = MolangParser.parseNode(reader);
                    break;
                }
                case NULL_COALESCING: {
                    reader.skip();
                    result = new BinaryOperationNode(BinaryOperation.NULL_COALESCING, result, MolangParser.parseNode(reader));
                    break;
                }
                case EQUAL: {
                    reader.skip();
                    MolangParser.expect(reader, MolangLexer.TokenType.EQUAL);
                    reader.skip();
                    result = new BinaryOperationNode(BinaryOperation.EQUALS, result, MolangParser.parseNode(reader));
                    break;
                }
                case SPECIAL: {
                    switch (token.value()) {
                        case "&": {
                            MolangParser.expect(reader, MolangLexer.TokenType.SPECIAL, "&");
                            reader.skip(2);
                            result = new BinaryOperationNode(BinaryOperation.AND, result, MolangParser.parseNode(reader));
                            break block0;
                        }
                        case "|": {
                            MolangParser.expect(reader, MolangLexer.TokenType.SPECIAL, "|");
                            reader.skip(2);
                            result = new BinaryOperationNode(BinaryOperation.OR, result, MolangParser.parseNode(reader));
                            break block0;
                        }
                        case "?": {
                            reader.skip();
                            Node left = MolangParser.parseExpression(reader);
                            if (reader.canRead() && !reader.peek().type().isTerminating()) {
                                MolangParser.expect(reader, MolangLexer.TokenType.SPECIAL, ":");
                                reader.skip();
                                result = new TernaryOperationNode(result, left, MolangParser.parseExpression(reader));
                                break block0;
                            }
                            result = new BinaryConditionalNode(result, left);
                            break block0;
                        }
                        case "!": {
                            reader.skip();
                            if (reader.peek().type() == MolangLexer.TokenType.EQUAL) {
                                reader.skip();
                                result = new BinaryOperationNode(BinaryOperation.NOT_EQUALS, result, MolangParser.parseNode(reader));
                                break block0;
                            }
                            if (result != null) {
                                throw MolangParser.error("Unexpected token", reader);
                            }
                            result = new NegateNode(MolangParser.parseNode(reader));
                            break block0;
                        }
                        case ">": {
                            reader.skip();
                            if (reader.peek().type() == MolangLexer.TokenType.EQUAL) {
                                reader.skip();
                                result = new BinaryOperationNode(BinaryOperation.GREATER_EQUALS, result, MolangParser.parseNode(reader));
                                break block0;
                            }
                            result = new BinaryOperationNode(BinaryOperation.GREATER, result, MolangParser.parseNode(reader));
                            break block0;
                        }
                        case "<": {
                            reader.skip();
                            if (reader.peek().type() == MolangLexer.TokenType.EQUAL) {
                                reader.skip();
                                result = new BinaryOperationNode(BinaryOperation.LESS_EQUALS, result, MolangParser.parseNode(reader));
                                break block0;
                            }
                            result = new BinaryOperationNode(BinaryOperation.LESS, result, MolangParser.parseNode(reader));
                            break block0;
                        }
                    }
                    return result;
                }
                case BINARY_OPERATION: {
                    if (result == null) {
                        throw MolangParser.error("Unexpected token", reader);
                    }
                    result = MolangParser.parseBinaryExpression(result, reader);
                    break;
                }
                default: {
                    throw MolangParser.error("Unexpected token: " + token, reader);
                }
            }
        }
        return result;
    }

    private static Node parseAlphanumeric(TokenReader reader) throws MolangSyntaxException {
        MolangLexer.Token token;
        MolangParser.expectLength(reader, 2);
        String object = reader.peek().lowercaseValue();
        if ("t".equals(object)) {
            object = "temp";
        }
        reader.skip();
        MolangParser.expect(reader, MolangLexer.TokenType.DOT);
        reader.skip();
        MolangParser.expect(reader, MolangLexer.TokenType.ALPHANUMERIC);
        StringBuilder nameBuilder = new StringBuilder(reader.peek().lowercaseValue());
        reader.skip();
        while (reader.canRead() && (token = reader.peek()).type().validVariableName()) {
            nameBuilder.append(token.lowercaseValue());
            reader.skip();
        }
        String name = nameBuilder.toString();
        MathOperation mathOperation = MolangParser.parseMathOperation(object, name, reader);
        if (mathOperation != null && mathOperation.getParameters() == 0) {
            return new MathNode(mathOperation, new Node[0]);
        }
        if (!reader.canRead() || reader.peek().type().isTerminating()) {
            if (mathOperation != null) {
                throw MolangParser.error("Cannot get value of a math function", reader);
            }
            return new VariableGetNode(object, name);
        }
        MolangLexer.Token operand = reader.peek();
        if (operand.type() == MolangLexer.TokenType.EQUAL) {
            if (reader.canRead() && reader.peekAfter(1).type() == MolangLexer.TokenType.EQUAL) {
                return new VariableGetNode(object, name);
            }
            if (mathOperation != null) {
                throw MolangParser.error("Cannot set value of a math function", reader);
            }
            reader.skip();
            return new VariableSetNode(object, name, MolangParser.parseExpression(reader));
        }
        if (operand.type() == MolangLexer.TokenType.INCREMENT) {
            reader.skip();
            return new VariableSetNode(object, name, new BinaryOperationNode(BinaryOperation.ADD, new VariableGetNode(object, name), new ConstNode(1.0f)));
        }
        if (operand.type() == MolangLexer.TokenType.DECREMENT) {
            reader.skip();
            return new VariableSetNode(object, name, new BinaryOperationNode(BinaryOperation.SUBTRACT, new VariableGetNode(object, name), new ConstNode(1.0f)));
        }
        if (reader.canRead(2) && operand.type() == MolangLexer.TokenType.BINARY_OPERATION) {
            if (mathOperation != null) {
                throw MolangParser.error("Cannot set value of a math function", reader);
            }
            VariableGetNode left = new VariableGetNode(object, name);
            MolangLexer.Token secondOperand = reader.peekAfter(1);
            if (secondOperand.type() == MolangLexer.TokenType.EQUAL) {
                reader.skip(2);
                BinaryOperationNode value = switch (operand.value()) {
                    case "-" -> new BinaryOperationNode(BinaryOperation.SUBTRACT, left, MolangParser.parseExpression(reader));
                    case "+" -> new BinaryOperationNode(BinaryOperation.ADD, left, MolangParser.parseExpression(reader));
                    case "*" -> new BinaryOperationNode(BinaryOperation.MULTIPLY, left, MolangParser.parseExpression(reader));
                    case "/" -> new BinaryOperationNode(BinaryOperation.DIVIDE, left, MolangParser.parseExpression(reader));
                    default -> throw MolangParser.error("Unexpected token", reader);
                };
                return new VariableSetNode(object, name, value);
            }
        }
        if (operand.type() == MolangLexer.TokenType.LEFT_PARENTHESIS) {
            reader.skip();
            if (reader.peek().type() == MolangLexer.TokenType.RIGHT_PARENTHESIS) {
                reader.skip();
                return new FunctionNode(object, name, new Node[0]);
            }
            ArrayList<Node> parameters = new ArrayList<Node>();
            while (reader.canRead()) {
                parameters.add(MolangParser.parseExpression(reader));
                if (reader.peek().type() == MolangLexer.TokenType.COMMA) {
                    reader.skip();
                    continue;
                }
                MolangParser.expect(reader, MolangLexer.TokenType.RIGHT_PARENTHESIS);
                reader.skip();
                if (mathOperation != null) {
                    if (mathOperation.getParameters() != parameters.size()) {
                        throw MolangParser.error("Expected " + mathOperation.getParameters() + " parameters, got " + parameters.size(), reader);
                    }
                    return new MathNode(mathOperation, (Node[])parameters.toArray(Node[]::new));
                }
                return new FunctionNode(object, name, (Node[])parameters.toArray(Node[]::new));
            }
            MolangParser.expectLength(reader, 1);
        }
        return new VariableGetNode(object, name);
    }

    private static MathOperation parseMathOperation(String object, String name, TokenReader reader) throws MolangSyntaxException {
        if (!"math".equalsIgnoreCase(object)) {
            return null;
        }
        for (MathOperation operation : MathOperation.values()) {
            if (!operation.getName().equalsIgnoreCase(name)) continue;
            return operation;
        }
        throw MolangParser.error("Unknown math function: " + name, reader);
    }

    private static Node parseBinaryExpression(Node left, TokenReader reader) throws MolangSyntaxException {
        MolangLexer.Token token = reader.peek();
        switch (token.value()) {
            case "+": {
                reader.skip();
                return new BinaryOperationNode(BinaryOperation.ADD, left, MolangParser.parseTerm(reader));
            }
            case "-": {
                reader.skip();
                return new BinaryOperationNode(BinaryOperation.SUBTRACT, left, MolangParser.parseTerm(reader));
            }
            case "*": {
                reader.skip();
                return new BinaryOperationNode(BinaryOperation.MULTIPLY, left, MolangParser.parseNode(reader));
            }
            case "/": {
                reader.skip();
                return new BinaryOperationNode(BinaryOperation.DIVIDE, left, MolangParser.parseNode(reader));
            }
        }
        return left;
    }

    private static Node parseTerm(TokenReader reader) throws MolangSyntaxException {
        Node left = MolangParser.parseNode(reader);
        if (!reader.canRead()) {
            return left;
        }
        MolangLexer.Token token = reader.peek();
        if (token.type() == MolangLexer.TokenType.BINARY_OPERATION) {
            switch (token.value()) {
                case "*": {
                    reader.skip();
                    return new BinaryOperationNode(BinaryOperation.MULTIPLY, left, MolangParser.parseNode(reader));
                }
                case "/": {
                    reader.skip();
                    return new BinaryOperationNode(BinaryOperation.DIVIDE, left, MolangParser.parseNode(reader));
                }
            }
        }
        return left;
    }

    public static void expect(TokenReader reader, MolangLexer.TokenType token) throws MolangSyntaxException {
        if (!reader.canRead() || reader.peek().type() != token) {
            throw MolangParser.error("Expected " + token, reader);
        }
    }

    public static void expect(TokenReader reader, MolangLexer.TokenType token, String value) throws MolangSyntaxException {
        MolangParser.expect(reader, token);
        if (!value.equals(reader.peek().value())) {
            throw MolangParser.error("Expected " + value, reader);
        }
    }

    public static void expectLength(TokenReader reader, int amount) throws MolangSyntaxException {
        if (!reader.canRead(amount)) {
            throw new MolangSyntaxException("Trailing statement", reader.getString(), reader.getString().length());
        }
    }

    public static MolangSyntaxException error(String error, TokenReader reader) {
        return new MolangSyntaxException(error, reader.getString(), reader.getCursorOffset());
    }
}

