/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.core.component;

import de.tomalbrc.bil.api.Animator;
import de.tomalbrc.bil.core.component.ComponentBase;
import de.tomalbrc.bil.core.holder.base.AbstractAnimationHolder;
import de.tomalbrc.bil.core.holder.wrapper.AbstractWrapper;
import de.tomalbrc.bil.core.model.Animation;
import de.tomalbrc.bil.core.model.Frame;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.core.model.Pose;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationComponent
extends ComponentBase
implements Animator {
    private final Map<String, AnimationPlayer> animationMap = new Object2ReferenceOpenHashMap();
    private final Map<class_3222, Map<String, AnimationPlayer>> perPlayerAnimationMap = new Reference2ObjectOpenHashMap();
    private final List<AnimationPlayer> animationPlayerList = new CopyOnWriteArrayList<AnimationPlayer>();

    public AnimationComponent(Model model, AbstractAnimationHolder holder) {
        super(model, holder);
    }

    private Map<String, AnimationPlayer> animationMap(class_3222 serverPlayer) {
        return serverPlayer == null ? this.animationMap : this.perPlayerAnimationMap.computeIfAbsent(serverPlayer, x -> new Object2ObjectOpenHashMap());
    }

    private AnimationPlayer removeFromAnimationMap(class_3222 serverPlayer, String name) {
        if (serverPlayer == null) {
            return this.animationMap.remove(name);
        }
        Map<String, AnimationPlayer> map = this.perPlayerAnimationMap.get(serverPlayer);
        if (map != null) {
            AnimationPlayer val = map.remove(name);
            if (map.isEmpty()) {
                this.perPlayerAnimationMap.remove(serverPlayer);
            }
            return val;
        }
        return null;
    }

    @Override
    public void playAnimation(class_3222 serverPlayer, String name, int priority, boolean restartPaused, IntConsumer onFrame, Consumer<class_3222> onFinish) {
        Map<String, AnimationPlayer> map = this.animationMap(serverPlayer);
        AnimationPlayer animationPlayer = map.get(name);
        if (priority < 0) {
            priority = 0;
        }
        if (animationPlayer == null) {
            Animation animation = (Animation)this.model.animations().get((Object)name);
            if (animation != null) {
                if (serverPlayer != null) {
                    this.holder.addBoneDataTracker(serverPlayer);
                }
                this.addAnimationPlayer(new AnimationPlayer(serverPlayer, name, animation, this.holder, priority, onFrame, serverPlayer1 -> {
                    if (serverPlayer1 != null && !this.hasRunningAnimationsSinglePlayer((class_3222)serverPlayer1)) {
                        this.holder.resetBoneDataTracker((class_3222)serverPlayer1);
                    }
                    if (onFinish != null) {
                        onFinish.accept((class_3222)serverPlayer1);
                    }
                }));
            }
        } else {
            animationPlayer.onFrameCallback = onFrame;
            animationPlayer.onFinishCallback = onFinish;
            if (animationPlayer.state == AnimationPlayer.State.PAUSED) {
                if (restartPaused) {
                    animationPlayer.resetFrameCounter(false);
                }
                animationPlayer.state = AnimationPlayer.State.PLAYING;
            }
            if (priority != animationPlayer.priority) {
                animationPlayer.priority = priority;
                Collections.sort(this.animationPlayerList);
            }
        }
    }

    @Override
    public void setAnimationFrame(class_3222 serverPlayer, String name, int frame) {
        AnimationPlayer animationPlayer = this.animationMap(serverPlayer).get(name);
        if (animationPlayer != null) {
            animationPlayer.skipToFrame(frame);
        }
    }

    @Override
    public void pauseAnimation(class_3222 serverPlayer, String name) {
        AnimationPlayer animationPlayer = this.animationMap(serverPlayer).get(name);
        if (animationPlayer != null && animationPlayer.state == AnimationPlayer.State.PLAYING) {
            animationPlayer.state = AnimationPlayer.State.PAUSED;
        }
    }

    @Override
    public void stopAnimation(class_3222 serverPlayer, String name) {
        AnimationPlayer animationPlayer = this.removeFromAnimationMap(serverPlayer, name);
        if (animationPlayer != null) {
            this.animationPlayerList.remove(animationPlayer);
        }
    }

    private void addAnimationPlayer(AnimationPlayer animationPlayer) {
        this.animationMap(animationPlayer.getOwner()).put(animationPlayer.name, animationPlayer);
        if (this.animationPlayerList.size() > 0 && animationPlayer.priority > 0) {
            int index = Collections.binarySearch(this.animationPlayerList, animationPlayer);
            this.animationPlayerList.add(index < 0 ? -index - 1 : index, animationPlayer);
        } else {
            this.animationPlayerList.add(animationPlayer);
        }
    }

    public void tickAnimations() {
        for (int index = this.animationPlayerList.size() - 1; index >= 0; --index) {
            AnimationPlayer animationPlayer = this.animationPlayerList.get(index);
            if (animationPlayer.hasFinished()) {
                class_3222 serverPlayer = animationPlayer.getOwner();
                this.removeFromAnimationMap(serverPlayer, animationPlayer.name);
                this.animationPlayerList.remove(index);
                animationPlayer.onFinished(serverPlayer);
                continue;
            }
            animationPlayer.tick(animationPlayer.getOwner());
        }
    }

    @Nullable
    public PoseQueryResult findPose(class_3222 serverPlayer, AbstractWrapper wrapper) {
        UUID nodeId = wrapper.node().uuid();
        PoseQueryResult queryResult = null;
        for (int i = 0; i < this.animationPlayerList.size(); ++i) {
            boolean owned;
            AnimationPlayer animationPlayer = this.animationPlayerList.get(i);
            boolean bl = owned = animationPlayer.owner != null;
            if (owned && animationPlayer.owner != serverPlayer || !animationPlayer.affects(nodeId)) continue;
            if (animationPlayer.inResetState()) {
                queryResult = new PoseQueryResult(wrapper.getDefaultPose(), animationPlayer.owner);
                continue;
            }
            Pose animationPose = this.findAnimationPose(wrapper, animationPlayer, nodeId);
            if (animationPose == null) continue;
            queryResult = new PoseQueryResult(animationPose, animationPlayer.owner);
            if (owned) break;
        }
        if (queryResult != null) {
            wrapper.setLastPose(queryResult.owner, queryResult.pose, null);
        }
        return queryResult;
    }

    @Nullable
    private Pose findAnimationPose(AbstractWrapper wrapper, AnimationPlayer anim, UUID uuid) {
        int startIndex;
        Animation animation = anim.animation;
        Frame frame = anim.currentFrame;
        if (frame == null) {
            return null;
        }
        Pose pose = (Pose)frame.poses().get((Object)uuid);
        if (pose != null) {
            wrapper.setLastPose(anim.getOwner(), pose, animation);
            return pose;
        }
        if (animation == wrapper.getLastAnimation(anim.getOwner())) {
            return wrapper.getLastPose(anim.getOwner());
        }
        Frame[] frames = animation.frames();
        for (int i = startIndex = frames.length - 1 - Math.max(anim.frameCounter - 1, 0); i >= 0; --i) {
            pose = (Pose)frames[i].poses().get((Object)uuid);
            if (pose == null) continue;
            wrapper.setLastPose(anim.getOwner(), pose, animation);
            return pose;
        }
        return null;
    }

    @Override
    public boolean isPlaying(class_3222 serverPlayer, String name) {
        return this.animationMap(serverPlayer).containsKey(name);
    }

    @Override
    public boolean hasRunningAnimations(class_3222 serverPlayer) {
        return this.animationMap(serverPlayer) != null && !this.animationMap(serverPlayer).isEmpty();
    }

    public boolean hasRunningAnimationsSinglePlayer(class_3222 serverPlayer) {
        Map<String, AnimationPlayer> map = this.perPlayerAnimationMap.get(serverPlayer);
        return map != null && !map.isEmpty();
    }

    static class AnimationPlayer
    implements Comparable<AnimationPlayer> {
        @NotNull
        private final Animation animation;
        private final AbstractAnimationHolder holder;
        private final String name;
        private Frame currentFrame;
        private int frameCounter = -1;
        private int priority;
        private boolean looped;
        private State state;
        @Nullable
        private IntConsumer onFrameCallback;
        @Nullable
        private Consumer<class_3222> onFinishCallback;
        @Nullable
        private final class_3222 owner;

        private AnimationPlayer(@Nullable class_3222 owner, String name, @NotNull Animation animation, AbstractAnimationHolder holder, int priority, @Nullable IntConsumer onFrame, @Nullable Consumer<class_3222> onFinish) {
            this.name = name;
            this.holder = holder;
            this.animation = animation;
            this.state = State.PLAYING;
            this.priority = priority;
            this.onFrameCallback = onFrame;
            this.onFinishCallback = onFinish;
            this.resetFrameCounter(false);
            this.owner = owner;
        }

        @Nullable
        public class_3222 getOwner() {
            return this.owner;
        }

        private void onFinished(class_3222 serverPlayer) {
            if (this.onFinishCallback != null) {
                this.onFinishCallback.accept(serverPlayer);
            }
        }

        private void tick(class_3222 serverPlayer) {
            if (this.frameCounter < 0) {
                this.onFramesFinished();
                return;
            }
            if (this.shouldAnimate()) {
                this.updateFrame(serverPlayer);
                --this.frameCounter;
            }
        }

        private void updateFrame(class_3222 serverPlayer) {
            Frame[] frames = this.animation.frames();
            if (this.frameCounter >= 0 && this.frameCounter < frames.length) {
                int index = frames.length - 1 - this.frameCounter;
                this.currentFrame = frames[index];
                if (this.onFrameCallback != null) {
                    this.onFrameCallback.accept(index);
                }
                if (this.currentFrame.requiresUpdates() && this.holder.canRunEffects(serverPlayer, this.currentFrame)) {
                    this.currentFrame.runEffects(serverPlayer, this.holder);
                }
            }
        }

        private void skipToFrame(int frame) {
            this.frameCounter = this.animation.duration() - 1 - frame;
        }

        private void resetFrameCounter(boolean isLooping) {
            this.frameCounter = this.animation.duration() - 1 + (isLooping ? this.animation.loopDelay() : this.animation.startDelay());
        }

        private void onFramesFinished() {
            switch (this.animation.loopMode()) {
                case ONCE: {
                    if (this.state == State.FINISHED_RESET_DEFAULT) {
                        this.state = State.FINISHED;
                        break;
                    }
                    this.state = State.FINISHED_RESET_DEFAULT;
                    break;
                }
                case HOLD: {
                    this.state = State.FINISHED;
                    break;
                }
                case LOOP: {
                    this.resetFrameCounter(true);
                    this.looped = true;
                }
            }
        }

        private boolean inLoopDelay() {
            return this.animation.loopDelay() > 0 && this.looped && this.frameCounter >= this.animation.duration() - this.animation.loopDelay();
        }

        private boolean inStartDelay() {
            return this.animation.startDelay() > 0 && this.frameCounter >= this.animation.duration() - (this.looped ? 0 : this.animation.startDelay());
        }

        public boolean inResetState() {
            return this.state == State.FINISHED_RESET_DEFAULT;
        }

        public boolean hasFinished() {
            return this.state == State.FINISHED;
        }

        public boolean shouldAnimate() {
            return this.state != State.PAUSED && this.state != State.FINISHED && !this.inLoopDelay() && !this.inStartDelay();
        }

        @Override
        public int compareTo(@NotNull AnimationPlayer other) {
            return Integer.compare(other.priority, this.priority);
        }

        public boolean affects(UUID nodeId) {
            boolean canAnimate = this.inResetState() || this.shouldAnimate();
            return canAnimate && this.animation.isAffected(nodeId);
        }

        private static enum State {
            PLAYING,
            PAUSED,
            FINISHED_RESET_DEFAULT,
            FINISHED;

        }
    }

    public record PoseQueryResult(@Nullable Pose pose, @Nullable class_3222 owner) {
    }
}

