/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.core.holder.entity.simple;

import de.tomalbrc.bil.core.holder.entity.EntityHolder;
import de.tomalbrc.bil.core.holder.wrapper.Bone;
import de.tomalbrc.bil.core.holder.wrapper.DisplayWrapper;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.core.model.Pose;
import de.tomalbrc.bil.util.Utils;
import eu.pb4.polymer.virtualentity.api.elements.InteractionElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2752;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_4048;
import net.minecraft.class_8042;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class InteractableEntityHolder<T extends class_1297>
extends EntityHolder<T> {
    protected final InteractionElement hitboxInteraction;

    public InteractableEntityHolder(T parent, Model model) {
        super(parent, model);
        this.hitboxInteraction = InteractionElement.redirect(parent);
        this.addElement((VirtualElement)this.hitboxInteraction);
    }

    @Override
    protected void startWatchingExtraPackets(class_3244 player, Consumer<class_2596<class_2602>> consumer) {
        super.startWatchingExtraPackets(player, consumer);
        for (class_2596<? super class_2602> packet : Utils.updateClientInteraction(this.hitboxInteraction, this.dimensions)) {
            consumer.accept(packet);
        }
        consumer.accept((class_2596<class_2602>)new class_2752(this.parent));
    }

    @Override
    public void updateElement(class_3222 serverPlayer, DisplayWrapper<?> display, @Nullable Pose pose) {
        display.element().setYaw(this.parent.method_36454());
        display.element().setPitch(this.parent.method_36455());
        super.updateElement(serverPlayer, display, pose);
    }

    @Override
    protected void applyPose(class_3222 serverPlayer, Pose pose, DisplayWrapper<?> display) {
        Object element = display.element();
        Vector3f translation = pose.translation();
        if (this.scale != 1.0f) {
            translation.mul(this.scale);
            element.setScale(serverPlayer, (Vector3fc)pose.scale().mul(this.scale));
        } else {
            element.setScale(serverPlayer, pose.readOnlyScale());
        }
        element.setTranslation(serverPlayer, (Vector3fc)translation.sub(0.0f, this.dimensions.comp_2186() - 0.01f, 0.0f));
        element.setLeftRotation(serverPlayer, (Quaternionfc)pose.leftRotation());
        element.setRightRotation(serverPlayer, (Quaternionfc)pose.rightRotation());
        element.startInterpolationIfDirty(serverPlayer);
    }

    @Override
    protected void addDirectPassengers(IntList passengers) {
        super.addDirectPassengers(passengers);
        passengers.add(this.hitboxInteraction.getEntityId());
    }

    @Override
    protected void updateCullingBox() {
        float scale = this.getScale();
        float width = scale * (this.dimensions.comp_2185() * 2.0f);
        float height = -this.dimensions.comp_2186() - 1.0f;
        for (Bone bone : this.bones) {
            bone.element().setDisplaySize(width, height);
        }
    }

    @Override
    public void onDimensionsUpdated(class_4048 dimensions) {
        super.onDimensionsUpdated(dimensions);
        this.sendPacket((class_2596<? extends class_2602>)new class_8042(Utils.updateClientInteraction(this.hitboxInteraction, dimensions)));
    }

    @Override
    public int getDisplayVehicleId() {
        return this.hitboxInteraction.getEntityId();
    }

    @Override
    public int getVehicleId() {
        return this.hitboxInteraction.getEntityId();
    }

    @Override
    public int getCritParticleId() {
        return this.hitboxInteraction.getEntityId();
    }
}

