/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.file.extra.easing;

import de.tomalbrc.bil.file.extra.easing.EasingFunction;

public enum EasingType {
    LINEAR((t, args) -> t),
    QUAD((t, args) -> t * t),
    CUBIC((t, args) -> t * t * t),
    POLY((t, args) -> {
        double n = args.length > 0 ? args[0] : 2.0;
        return Math.pow(t, n);
    }),
    SIN((t, args) -> 1.0 - Math.cos(t * Math.PI / 2.0)),
    CIRCLE((t, args) -> 1.0 - Math.sqrt(1.0 - t * t)),
    EXP((t, args) -> Math.pow(2.0, 10.0 * (t - 1.0))),
    ELASTIC((t, args) -> {
        double b = args.length > 0 ? args[0] : 1.0;
        double p = b * Math.PI;
        return 1.0 - Math.pow(Math.cos(t * Math.PI / 2.0), 3.0) * Math.cos(t * p);
    }),
    BACK((t, args) -> {
        double s = args.length > 0 ? args[0] : 1.70158;
        return t * t * ((s + 1.0) * t - s);
    }),
    BOUNCE((t, args) -> {
        double k = args.length > 0 ? args[0] : 0.5;
        double q = 7.5625 * t * t;
        double w = 30.25 * k * Math.pow(t - 0.5454545454545454, 2.0) + 1.0 - k;
        double r = 121.0 * k * k * Math.pow(t - 0.8181818181818182, 2.0) + 1.0 - k * k;
        double u = 484.0 * k * k * k * Math.pow(t - 0.9545454545454546, 2.0) + 1.0 - k * k * k;
        return Math.min(Math.min(q, w), Math.min(r, u));
    }),
    EASE_IN_QUAD(EasingType.in_(EasingType.QUAD.function)),
    EASE_OUT_QUAD(EasingType.out(EasingType.QUAD.function)),
    EASE_IN_OUT_QUAD(EasingType.inOut(EasingType.QUAD.function)),
    EASE_IN_CUBIC(EasingType.in_(EasingType.CUBIC.function)),
    EASE_OUT_CUBIC(EasingType.out(EasingType.CUBIC.function)),
    EASE_IN_OUT_CUBIC(EasingType.inOut(EasingType.CUBIC.function)),
    EASE_IN_QUART(EasingType.in_((t, a) -> Math.pow(t, 4.0))),
    EASE_OUT_QUART(EasingType.out((t, a) -> Math.pow(t, 4.0))),
    EASE_IN_OUT_QUART(EasingType.inOut((t, a) -> Math.pow(t, 4.0))),
    EASE_IN_QUINT(EasingType.in_((t, a) -> Math.pow(t, 5.0))),
    EASE_OUT_QUINT(EasingType.out((t, a) -> Math.pow(t, 5.0))),
    EASE_IN_OUT_QUINT(EasingType.inOut((t, a) -> Math.pow(t, 5.0))),
    EASE_IN_SINE(EasingType.in_(EasingType.SIN.function)),
    EASE_OUT_SINE(EasingType.out(EasingType.SIN.function)),
    EASE_IN_OUT_SINE(EasingType.inOut(EasingType.SIN.function)),
    EASE_IN_CIRC(EasingType.in_(EasingType.CIRCLE.function)),
    EASE_OUT_CIRC(EasingType.out(EasingType.CIRCLE.function)),
    EASE_IN_OUT_CIRC(EasingType.inOut(EasingType.CIRCLE.function)),
    EASE_IN_EXPO(EasingType.in_(EasingType.EXP.function)),
    EASE_OUT_EXPO(EasingType.out(EasingType.EXP.function)),
    EASE_IN_OUT_EXPO(EasingType.inOut(EasingType.EXP.function)),
    EASE_IN_BACK(EasingType.in_(EasingType.BACK.function)),
    EASE_OUT_BACK(EasingType.out(EasingType.BACK.function)),
    EASE_IN_OUT_BACK(EasingType.inOut(EasingType.BACK.function)),
    EASE_IN_ELASTIC(EasingType.in_(EasingType.ELASTIC.function)),
    EASE_OUT_ELASTIC(EasingType.out(EasingType.ELASTIC.function)),
    EASE_IN_OUT_ELASTIC(EasingType.inOut(EasingType.ELASTIC.function)),
    EASE_IN_BOUNCE(EasingType.in_(EasingType.BOUNCE.function)),
    EASE_OUT_BOUNCE(EasingType.out(EasingType.BOUNCE.function)),
    EASE_IN_OUT_BOUNCE(EasingType.inOut(EasingType.BOUNCE.function));

    public final EasingFunction function;

    private EasingType(EasingFunction function) {
        this.function = function;
    }

    public double apply(double t, double ... args) {
        return this.function.apply(t, args);
    }

    private static EasingFunction in_(EasingFunction e) {
        return e;
    }

    private static EasingFunction out(EasingFunction e) {
        return (t, args) -> 1.0 - e.apply(1.0 - t, args);
    }

    private static EasingFunction inOut(EasingFunction e) {
        return (t, args) -> {
            if (t < 0.5) {
                return e.apply(t * 2.0, args) / 2.0;
            }
            return 1.0 - e.apply((1.0 - t) * 2.0, args) / 2.0;
        };
    }
}

