/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.core.component;

import de.tomalbrc.bil.api.VariantController;
import de.tomalbrc.bil.core.component.ComponentBase;
import de.tomalbrc.bil.core.holder.base.AbstractAnimationHolder;
import de.tomalbrc.bil.core.holder.wrapper.Bone;
import de.tomalbrc.bil.core.holder.wrapper.ItemBone;
import de.tomalbrc.bil.core.holder.wrapper.ModelBone;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.core.model.Variant;
import java.util.UUID;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class VariantComponent
extends ComponentBase
implements VariantController {
    @Nullable
    private Variant currentVariant;

    public VariantComponent(Model model, AbstractAnimationHolder holder) {
        super(model, holder);
    }

    @Override
    @Nullable
    public Variant getCurrentVariant() {
        return this.currentVariant;
    }

    @Override
    public void setDefaultVariant() {
        if (this.currentVariant != null) {
            this.currentVariant = null;
            for (int i = 0; i < this.holder.getBones().length; ++i) {
                Bone<?> bone = this.holder.getBones()[i];
                if (!(bone instanceof ItemBone)) continue;
                ItemBone itemBone = (ItemBone)bone;
                itemBone.updateModel(itemBone.node().modelData());
            }
        }
    }

    @Override
    public boolean isDefaultVariant() {
        return this.currentVariant == null;
    }

    @Override
    public boolean isCurrent(String variantName) {
        return this.currentVariant != null && this.currentVariant.name().equals(variantName);
    }

    @Override
    public void setVariant(String variantName) {
        if (this.getCurrentVariant() != null && this.getCurrentVariant().name().equals(variantName)) {
            return;
        }
        Variant variant = this.findByName(variantName);
        if (variant != null) {
            this.currentVariant = variant;
            this.applyVariantToBones(variant);
        }
    }

    @Override
    public void setVariant(UUID variantUuid) {
        Variant variant = (Variant)this.model.variants().get((Object)variantUuid);
        if (variant == null || variant == this.currentVariant) {
            return;
        }
        this.currentVariant = variant;
        this.applyVariantToBones(variant);
    }

    @Nullable
    private Variant findByName(String variantName) {
        for (Variant variant : this.model.variants().values()) {
            if (!variant.name().equals(variantName)) continue;
            return variant;
        }
        return null;
    }

    private void applyVariantToBones(Variant variant) {
        for (int i = 0; i < this.holder.getBones().length; ++i) {
            Bone<?> bone = this.holder.getBones()[i];
            if (!(bone instanceof ModelBone)) continue;
            ModelBone bone2 = (ModelBone)bone;
            UUID uuid = bone2.node().uuid();
            class_2960 modelData = (class_2960)variant.models().get((Object)uuid);
            if (modelData == null || !variant.isAffected(uuid)) continue;
            bone2.updateModel(modelData);
        }
    }
}

