/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.core.holder.entity;

import de.tomalbrc.bil.api.AnimatedEntityHolder;
import de.tomalbrc.bil.core.holder.base.AbstractAnimationHolder;
import de.tomalbrc.bil.core.holder.wrapper.Bone;
import de.tomalbrc.bil.core.holder.wrapper.ItemBone;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.util.Utils;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.elements.DisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.polymer.virtualentity.api.tracker.EntityTrackedData;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2752;
import net.minecraft.class_2940;
import net.minecraft.class_3244;
import net.minecraft.class_4048;

public abstract class EntityHolder<T extends class_1297>
extends AbstractAnimationHolder
implements AnimatedEntityHolder {
    protected final ObjectOpenHashSet<DisplayElement> additionalDisplays = new ObjectOpenHashSet();
    protected final T parent;
    protected class_4048 dimensions;
    protected int tickCount;

    protected EntityHolder(T parent, Model model) {
        super(model);
        this.parent = parent;
        this.dimensions = parent.method_5864().method_18386();
        this.tickCount = ((class_1297)parent).field_6012 - 1;
    }

    @Override
    public boolean addAdditionalDisplay(DisplayElement element) {
        if (this.additionalDisplays.add((Object)element)) {
            this.addElement((VirtualElement)element);
            this.sendPacket((class_2596<? extends class_2602>)new class_2752(this.parent));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAdditionalDisplay(DisplayElement element) {
        if (this.additionalDisplays.remove((Object)element)) {
            this.removeElement((VirtualElement)element);
            return true;
        }
        return false;
    }

    protected void startWatchingExtraPackets(class_3244 player, Consumer<class_2596<class_2602>> consumer) {
        super.startWatchingExtraPackets(player, consumer);
        this.sendDirectPassengers(consumer);
    }

    public void sendDirectPassengers(Consumer<class_2596<class_2602>> consumer) {
        IntArrayList passengers = new IntArrayList();
        this.addDirectPassengers((IntList)passengers);
        if (!passengers.isEmpty()) {
            consumer.accept((class_2596<class_2602>)VirtualEntityUtils.createRidePacket((int)this.parent.method_5628(), (IntList)passengers));
        }
    }

    protected void addDirectPassengers(IntList passengers) {
    }

    protected void notifyElementsOfPositionUpdate(class_243 newPos, class_243 delta) {
    }

    @Override
    protected void onDataLoaded() {
        this.onDimensionsUpdated(this.parent.method_18377(this.parent.method_18376()));
        super.onDataLoaded();
    }

    @Override
    protected boolean shouldSkipTick() {
        int parentTickCount = ((class_1297)this.parent).field_6012;
        if (parentTickCount < ++this.tickCount) {
            this.tickCount = parentTickCount;
            return true;
        }
        return super.shouldSkipTick();
    }

    @Override
    public class_2168 createCommandSourceStack() {
        return this.parent.method_5671(this.getLevel());
    }

    @Override
    public void onDimensionsUpdated(class_4048 dimensions) {
        this.dimensions = dimensions;
        this.updateCullingBox();
    }

    @Override
    public void setScale(float scale) {
        super.setScale(scale);
        this.updateCullingBox();
    }

    protected void updateCullingBox() {
        float scale = this.getScale();
        float width = scale * (this.dimensions.comp_2185() * 2.0f);
        float height = scale * (this.dimensions.comp_2186() + 1.0f);
        for (int i = 0; i < this.bones.length; ++i) {
            this.bones[i].element().setDisplaySize(width, height);
        }
    }

    @Override
    public void onSyncedDataUpdated(class_2940<?> key, Object object) {
        if (key.equals((Object)EntityTrackedData.FLAGS)) {
            byte value = (Byte)object;
            this.updateOnFire(Utils.getSharedFlag(value, EntityTrackedData.ON_FIRE_FLAG_INDEX));
            this.updateGlowing(Utils.getSharedFlag(value, EntityTrackedData.GLOWING_FLAG_INDEX));
            this.updateInvisibility(Utils.getSharedFlag(value, EntityTrackedData.INVISIBLE_FLAG_INDEX));
        }
    }

    protected void updateOnFire(boolean displayFire) {
    }

    protected void updateInvisibility(boolean isInvisible) {
        for (int i = 0; i < this.bones.length; ++i) {
            Bone bone = this.bones[i];
            if (!(bone instanceof ItemBone)) continue;
            ItemBone itemBone = (ItemBone)bone;
            itemBone.setInvisible(isInvisible);
        }
    }

    protected void updateGlowing(boolean isGlowing) {
        for (int i = 0; i < this.bones.length; ++i) {
            this.bones[i].element().setGlowing(isGlowing);
        }
    }

    @Override
    public int[] getDisplayIds() {
        int[] displays = new int[this.bones.length + this.additionalDisplays.size()];
        int index = 0;
        for (Bone bone : this.bones) {
            displays[index++] = bone.element().getEntityId();
        }
        for (DisplayElement element : this.additionalDisplays) {
            displays[index++] = element.getEntityId();
        }
        return displays;
    }

    @Override
    public int getDisplayVehicleId() {
        return this.parent.method_5628();
    }

    @Override
    public int getVehicleId() {
        return this.parent.method_5628();
    }

    @Override
    public int getLeashedId() {
        return this.parent.method_5628();
    }

    @Override
    public int getEntityEventId() {
        return this.parent.method_5628();
    }

    @Override
    public int getCritParticleId() {
        return this.parent.method_5628();
    }

    public T getParent() {
        return this.parent;
    }
}

