/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.core.holder.wrapper;

import de.tomalbrc.bil.core.model.Animation;
import de.tomalbrc.bil.core.model.Node;
import de.tomalbrc.bil.core.model.Pose;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import net.minecraft.class_3222;

public abstract class AbstractWrapper {
    private final Node node;
    private final Pose defaultPose;
    protected Animation lastAnimation;
    protected Pose lastPose;
    protected Map<class_3222, Animation> lastAnimationPerPlayer = new Reference2ReferenceOpenHashMap();
    protected Map<class_3222, Pose> lastPosePerPlayer = new Reference2ReferenceOpenHashMap();

    public AbstractWrapper(Node node, Pose defaultPose) {
        this.node = node;
        this.defaultPose = defaultPose;
        this.lastPose = defaultPose;
    }

    public Node node() {
        return this.node;
    }

    public String name() {
        return this.node.name();
    }

    public Pose getDefaultPose() {
        return this.defaultPose;
    }

    public Animation getLastAnimation(class_3222 serverPlayer) {
        return this.lastAnimationPerPlayer.getOrDefault(serverPlayer, this.lastAnimation);
    }

    public Pose getLastPose(class_3222 serverPlayer) {
        return this.lastPosePerPlayer.getOrDefault(serverPlayer, this.lastPose);
    }

    public void setLastPose(class_3222 serverPlayer, Pose pose, Animation animation) {
        if (serverPlayer != null) {
            this.lastAnimationPerPlayer.put(serverPlayer, animation);
            this.lastPosePerPlayer.put(serverPlayer, pose);
        } else {
            this.lastAnimation = animation;
            this.lastPose = pose;
        }
    }

    public void resetLastPose(class_3222 serverPlayer) {
        this.lastAnimationPerPlayer.remove(serverPlayer);
        this.lastPosePerPlayer.remove(serverPlayer);
    }
}

