/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.file.bbmodel;

import com.google.gson.annotations.SerializedName;
import de.tomalbrc.bil.BIL;
import de.tomalbrc.bil.file.extra.BbVariablePlaceholders;
import de.tomalbrc.bil.file.extra.easing.EasingType;
import de.tomalbrc.bil.file.extra.interpolation.Interpolation;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.exception.MolangRuntimeException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.math.NumberUtils;
import org.joml.Vector3f;

public class BbKeyframe
implements Comparable<BbKeyframe> {
    public Channel channel;
    @SerializedName(value="data_points")
    public List<Map<String, DataPointValue>> dataPoints;
    public UUID uuid;
    public float time;
    public int color;
    public Interpolation interpolation;
    @SerializedName(value="bezier_linked")
    public boolean bezierLinked;
    @SerializedName(value="bezier_left_time")
    public Vector3f bezierLeftTime;
    @SerializedName(value="bezier_left_value")
    public Vector3f bezierLeftValue;
    @SerializedName(value="bezier_right_time")
    public Vector3f bezierRightTime;
    @SerializedName(value="bezier_right_value")
    public Vector3f bezierRightValue;
    public EasingType easing = EasingType.LINEAR;
    public double[] easingArgs = new double[0];

    @Override
    public int compareTo(BbKeyframe other) {
        return Float.compare(this.time, other.time);
    }

    public Vector3f getVector3f(int index, BbVariablePlaceholders placeholders, MolangEnvironment environment) throws MolangRuntimeException {
        return new Vector3f(this.dataPoints.get(index).get("x").getValue(placeholders, environment), this.dataPoints.get(index).get("y").getValue(placeholders, environment), this.dataPoints.get(index).get("z").getValue(placeholders, environment));
    }

    public static class DataPointValue {
        public static DataPointValue BLANK = new DataPointValue("");
        private float value;
        private String stringValue;
        private MolangExpression molangExpression;

        public DataPointValue() {
        }

        public DataPointValue(MolangExpression expression) {
            this.molangExpression = expression;
        }

        public DataPointValue(float val) {
            this.value = val;
        }

        public DataPointValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public void setValue(float value) {
            this.value = value;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public float getValue(BbVariablePlaceholders placeholders, MolangEnvironment environment) throws MolangRuntimeException {
            if (this.stringValue == null) {
                return this.value;
            }
            int length = this.stringValue.trim().length();
            if (length <= 2 || NumberUtils.isParsable((String)this.stringValue)) {
                if (length == 0 || this.stringValue.equals("-") || this.stringValue.equals("+") || this.stringValue.equals(".") || this.stringValue.equals(",")) {
                    return 0.0f;
                }
                this.value = Float.parseFloat(this.stringValue.trim());
                this.stringValue = null;
                return this.value;
            }
            if (this.molangExpression == null) {
                String modifiedExpression = this.stringValue;
                if (placeholders != null) {
                    modifiedExpression = placeholders.substituteVariables(this.stringValue);
                }
                try {
                    this.molangExpression = BIL.COMPILER.compile(modifiedExpression);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return environment.resolve(this.molangExpression);
        }
    }

    public static enum Channel {
        POSITION,
        ROTATION,
        SCALE,
        TIMELINE,
        SOUND,
        VARIANTS,
        COMMANDS;

    }
}

