/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.file.extra;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.tomalbrc.bil.file.bbmodel.BbElement;
import de.tomalbrc.bil.file.bbmodel.BbFace;
import de.tomalbrc.bil.file.bbmodel.BbModel;
import de.tomalbrc.bil.file.bbmodel.BbTexture;
import de.tomalbrc.bil.file.extra.ResourcePackModel;
import de.tomalbrc.bil.json.ElementSerializer;
import de.tomalbrc.bil.json.FaceSerializer;
import de.tomalbrc.bil.json.JSON;
import de.tomalbrc.bil.util.ResourcePackUtil;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.extras.api.format.item.ItemAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.BasicItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.ItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.tint.DyeTintSource;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2960;
import org.apache.commons.io.FilenameUtils;

public class BbResourcePackGenerator {
    static Gson gson = JSON.GENERIC_BUILDER.registerTypeAdapter(BbFace.class, (Object)new FaceSerializer()).registerTypeAdapter(BbElement.class, (Object)new ElementSerializer()).create();
    public static String BASE64_PNG_PREFIX = "data:image/png;base64,";
    static String MODEL_DIR = ":assets/bil/models/item/";
    static String TEXTURE_DIR = ":assets/bil/textures/item/";

    public static class_2960 addModelPart(BbModel model, String partName, ResourcePackModel resourcePackModel) {
        class_2960 modelResourceLocation = class_2960.method_60654((String)(MODEL_DIR + model.modelIdentifier + "/" + partName.toLowerCase() + ".json"));
        ResourcePackUtil.add(modelResourceLocation, resourcePackModel.getBytes());
        return class_2960.method_60655((String)"bil", (String)("item/" + model.modelIdentifier + "/" + partName.toLowerCase()));
    }

    public static class_2960 addItemModel(BbModel model, String partName, ResourcePackModel resourcePackModel) {
        partName = model.modelIdentifier + "_" + (String)partName;
        class_2960 modelPath = BbResourcePackGenerator.addModelPart(model, (String)partName, resourcePackModel);
        BasicItemModel defaultModel = new BasicItemModel(modelPath, List.of(new DyeTintSource(0xFFFFFF)));
        byte[] bytes = new ItemAsset((ItemModel)defaultModel, ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8);
        class_2960 id = class_2960.method_60655((String)"bil", (String)(model.modelIdentifier + "_" + (String)partName));
        ResourcePackUtil.add(class_2960.method_60654((String)(":" + AssetPaths.itemAsset((class_2960)id))), bytes);
        return id;
    }

    public static void makeTextures(BbModel model, Collection<BbTexture> textures) {
        for (BbTexture texture : textures) {
            byte[] texData = Base64.getDecoder().decode(texture.source.replace(BASE64_PNG_PREFIX, ""));
            String str = FilenameUtils.getBaseName((String)texture.name.toLowerCase());
            while (str.endsWith(".png")) {
                str = str.substring(0, str.length() - 4);
            }
            if (BbResourcePackGenerator.isMultipleOf(texture.width, texture.height)) {
                JsonObject root = new JsonObject();
                JsonObject animation = new JsonObject();
                animation.addProperty("frametime", (Number)texture.frameTime);
                root.add("animation", (JsonElement)animation);
                String json = new Gson().toJson((JsonElement)root);
                byte[] mcmeta = json.getBytes(StandardCharsets.UTF_8);
                ResourcePackUtil.add(class_2960.method_60654((String)(TEXTURE_DIR + model.modelIdentifier + "/" + str + ".png.mcmeta")), mcmeta);
            }
            ResourcePackUtil.add(class_2960.method_60654((String)(TEXTURE_DIR + model.modelIdentifier + "/" + str + ".png")), texData);
        }
    }

    public static boolean isMultipleOf(int width, int height) {
        return width > 0 && height % width == 0;
    }
}

