/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.file.loader;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.Strictness;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.file.bbmodel.BbKeyframe;
import de.tomalbrc.bil.file.bbmodel.BbModel;
import de.tomalbrc.bil.file.bbmodel.BbOutliner;
import de.tomalbrc.bil.file.extra.BbVariablePlaceholders;
import de.tomalbrc.bil.file.importer.BbModel5Importer;
import de.tomalbrc.bil.file.importer.BbModelImporter;
import de.tomalbrc.bil.file.loader.ModelLoader;
import de.tomalbrc.bil.json.BbVariablePlaceholdersDeserializer;
import de.tomalbrc.bil.json.ChildEntryDeserializer;
import de.tomalbrc.bil.json.DataPointValueDeserializer;
import de.tomalbrc.bil.json.JSON;
import de.tomalbrc.bil.util.VersionCheck;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.class_2960;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

public class BbModelLoader
implements ModelLoader {
    protected static Gson GSON = JSON.GENERIC_BUILDER.registerTypeAdapter(BbOutliner.ChildEntry.class, (Object)new ChildEntryDeserializer()).registerTypeAdapter(BbKeyframe.DataPointValue.class, (Object)new DataPointValueDeserializer()).registerTypeAdapter(BbVariablePlaceholders.class, (Object)new BbVariablePlaceholdersDeserializer()).setStrictness(Strictness.LENIENT).create();

    public static Model load(class_2960 resourceLocation) {
        return new BbModelLoader().loadResource(resourceLocation);
    }

    public static Model load(String path) {
        Model model;
        FileInputStream input = new FileInputStream(path);
        try {
            model = new BbModelLoader().load(input, FilenameUtils.getBaseName((String)path));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new IllegalArgumentException("Model doesn't exist: " + path);
            }
        }
        ((InputStream)input).close();
        return model;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Model load(InputStream input, @NotNull String name) throws JsonParseException {
        try (InputStreamReader reader = new InputStreamReader(input);){
            BbModel model = (BbModel)GSON.fromJson((Reader)reader, BbModel.class);
            if (!name.isEmpty()) {
                model.modelIdentifier = name;
            }
            if (model.modelIdentifier == null) {
                model.modelIdentifier = model.name;
            }
            model.modelIdentifier = ModelLoader.normalizedModelId(model.modelIdentifier);
            if (VersionCheck.isAtLeastVersion(model.meta.formatVersion, "5.0.0")) {
                Model model2 = new BbModel5Importer(model).importModel();
                return model2;
            }
            Model model3 = new BbModelImporter(model).importModel();
            return model3;
        }
        catch (Throwable throwable3) {
            throw new JsonParseException("Failed to parse: " + name, throwable3);
        }
    }

    @Override
    public Model loadResource(class_2960 resourceLocation) throws IllegalArgumentException, JsonParseException {
        String path = String.format("/model/%s/%s.bbmodel", resourceLocation.method_12836(), resourceLocation.method_12832());
        InputStream input = BbModelLoader.class.getResourceAsStream(path);
        if (input == null) {
            throw new IllegalArgumentException("Model doesn't exist: " + path);
        }
        return this.load(input, resourceLocation.method_12832());
    }
}

