/*
 * Decompiled with CFR 0.152.
 */
package com.quizy.manualtotem.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.quizy.manualtotem.Manualtotem;
import com.quizy.manualtotem.client.ManualtotemKeybinds;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_465;
import net.minecraft.class_490;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class ManualtotemClient
implements ClientModInitializer {
    private static boolean enabled = true;
    private static final class_310 client = class_310.method_1551();
    private static boolean hasMovedCursor = false;
    private static long lastCursorMoveTime = 0L;
    private static final long CURSOR_MOVE_COOLDOWN = 1000L;
    private static boolean wasKeyPressed = false;

    public void onInitializeClient() {
        ManualtotemKeybinds.register();
        this.registerCommands();
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            hasMovedCursor = false;
        });
        Manualtotem.LOGGER.info("ManualTotem client initialized");
    }

    private void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> this.registerManualTotemCommand((CommandDispatcher<FabricClientCommandSource>)dispatcher));
    }

    private void registerManualTotemCommand(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"manualtotem").then(ClientCommandManager.literal((String)"enable").executes(this::enableMod))).then(ClientCommandManager.literal((String)"disable").executes(this::disableMod))).then(ClientCommandManager.literal((String)"toggle").executes(this::toggleMod))).then(ClientCommandManager.literal((String)"status").executes(this::showStatus)));
    }

    private int enableMod(CommandContext<FabricClientCommandSource> context) {
        enabled = true;
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"ManualTotem enabled").method_27692(class_124.field_1060));
        return 1;
    }

    private int disableMod(CommandContext<FabricClientCommandSource> context) {
        enabled = false;
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"ManualTotem disabled").method_27692(class_124.field_1061));
        return 1;
    }

    private int toggleMod(CommandContext<FabricClientCommandSource> context) {
        enabled = !enabled;
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("ManualTotem " + (enabled ? "enabled" : "disabled"))).method_27692(enabled ? class_124.field_1060 : class_124.field_1061));
        return 1;
    }

    private int showStatus(CommandContext<FabricClientCommandSource> context) {
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("ManualTotem is currently " + (enabled ? "enabled" : "disabled"))).method_27692(enabled ? class_124.field_1060 : class_124.field_1061));
        return 1;
    }

    private void onClientTick(class_310 client) {
        if (client == null || client.field_1724 == null) {
            return;
        }
        boolean isKeyDown = ManualtotemKeybinds.TOGGLE_MOD.method_1434();
        if (isKeyDown && !wasKeyPressed) {
            enabled = !enabled;
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("ManualTotem " + (enabled ? "enabled" : "disabled"))).method_27692(enabled ? class_124.field_1060 : class_124.field_1061), true);
        }
        wasKeyPressed = isKeyDown;
        if (!enabled) {
            return;
        }
        if (client.field_1755 instanceof class_490) {
            class_490 screen;
            class_1735 totemSlot;
            long currentTime = System.currentTimeMillis();
            if (!hasMovedCursor && currentTime - lastCursorMoveTime > 1000L && (totemSlot = this.findTotemSlot((class_465<?>)(screen = (class_490)client.field_1755))) != null) {
                int slotX = totemSlot.field_7873;
                int slotY = totemSlot.field_7872;
                int guiLeft = (screen.field_22789 - 176) / 2;
                int guiTop = (screen.field_22790 - 166) / 2;
                int mouseX = guiLeft + slotX + 8;
                int mouseY = guiTop + slotY + 8;
                GLFW.glfwSetCursorPos((long)client.method_22683().method_4490(), (double)mouseX, (double)mouseY);
                hasMovedCursor = true;
                lastCursorMoveTime = currentTime;
            }
        } else {
            hasMovedCursor = false;
        }
    }

    private class_1735 findTotemSlot(class_465<?> screen) {
        for (int row = 1; row <= 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int index = col + row * 9;
                class_1735 slot = screen.method_17577().method_7611(index);
                if (!slot.method_7681() || slot.method_7677().method_7909() != class_1802.field_8288) continue;
                return slot;
            }
        }
        for (int i = 0; i < 9; ++i) {
            class_1735 slot = screen.method_17577().method_7611(i);
            if (!slot.method_7681() || slot.method_7677().method_7909() != class_1802.field_8288) continue;
            return slot;
        }
        return null;
    }
}

