/*
 * Decompiled with CFR 0.152.
 */
package net.natxo.quickhomes;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;
import net.natxo.quickhomes.command.HomeCommands;
import net.natxo.quickhomes.config.QuickHomesConfig;
import net.natxo.quickhomes.storage.HomeStorage;
import net.natxo.quickhomes.util.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickHomes
implements ModInitializer {
    public static final String MOD_ID = "quickhomes";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"quickhomes");
    private static HomeStorage homeStorage;
    private static QuickHomesConfig config;
    private static MinecraftServer server;

    public void onInitialize() {
        LOGGER.info("Initializing Quick Homes mod");
        config = QuickHomesConfig.loadConfig();
        boolean useServerText = config.isServerOnlyMode();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            if (useServerText) {
                MessageUtils.loadServerTranslations(config.getServerLanguage());
                LOGGER.info("Running on dedicated server - using server-side text in language: " + config.getServerLanguage());
            } else {
                LOGGER.info("Running on dedicated server - using client translations");
            }
        } else {
            useServerText = false;
            LOGGER.info("Running on integrated server - using client translations");
        }
        MessageUtils.setForceServerSideText(useServerText);
        CommandRegistrationCallback.EVENT.register(HomeCommands::register);
        ServerLifecycleEvents.SERVER_STARTED.register(srv -> {
            server = srv;
            homeStorage = new HomeStorage(srv);
            homeStorage.load();
            LOGGER.info("Quick Homes mod loaded successfully");
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(srv -> {
            if (homeStorage != null) {
                LOGGER.info("Saving homes data before server stops...");
                homeStorage.save();
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(srv -> {
            if (srv.method_3780() % 6000 == 0 && homeStorage != null) {
                homeStorage.save();
                LOGGER.debug("Auto-saving homes data");
            }
        });
    }

    public static HomeStorage getHomeStorage() {
        return homeStorage;
    }

    public static QuickHomesConfig getConfig() {
        return config;
    }

    public static MinecraftServer getServer() {
        return server;
    }
}

