/*
 * Decompiled with CFR 0.152.
 */
package net.natxo.quickhomes.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.natxo.quickhomes.QuickHomes;
import net.natxo.quickhomes.data.Home;
import net.natxo.quickhomes.util.MessageUtils;
import net.natxo.quickhomes.util.TeleportManager;

public class HomeCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sethome").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> HomeCommands.setHome((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"name"))))).executes(context -> HomeCommands.setHome((CommandContext<class_2168>)context, "home")));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"home").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(HomeCommands::suggestHomes).executes(context -> HomeCommands.goHome((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"name"))))).executes(context -> HomeCommands.goHome((CommandContext<class_2168>)context, "home")));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delhome").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(HomeCommands::suggestHomes).executes(context -> HomeCommands.deleteHome((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"name"))))).executes(context -> HomeCommands.deleteHome((CommandContext<class_2168>)context, "home")));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"homes").executes(HomeCommands::listHomes));
    }

    private static int setHome(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Home existingHome = QuickHomes.getHomeStorage().getHome(player.method_5667(), name);
        int homeCount = QuickHomes.getHomeStorage().getHomeCount(player.method_5667());
        int maxHomes = QuickHomes.getConfig().getMaxHomes();
        if (existingHome != null) {
            source.method_45068(MessageUtils.createErrorMessage(player, "quickhomes.error.home.exists", name));
            return 0;
        }
        if (homeCount >= maxHomes) {
            source.method_45068(MessageUtils.createErrorMessage(player, "quickhomes.error.max.homes", maxHomes));
            return 0;
        }
        Home home = new Home(name, player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455(), (class_5321<class_1937>)player.method_51469().method_27983());
        QuickHomes.getHomeStorage().setHome(player.method_5667(), name, home);
        source.method_9226(() -> MessageUtils.createHomeSetMessage(player, name, player.method_51469().method_27983().method_29177().toString(), player.method_23317(), player.method_23318(), player.method_23321()), false);
        return 1;
    }

    private static int goHome(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Home home = QuickHomes.getHomeStorage().getHome(player.method_5667(), name);
        if (home == null) {
            source.method_45068(MessageUtils.createErrorMessage(player, "quickhomes.error.home.notfound", name));
            return 0;
        }
        if (!QuickHomes.getConfig().isAllowCrossDimension() && !player.method_51469().method_27983().equals(home.getDimension())) {
            source.method_45068(MessageUtils.createErrorMessage(player, "quickhomes.error.crossdim.disabled", new Object[0]));
            return 0;
        }
        TeleportManager.teleportToHome(player, home);
        return 1;
    }

    private static int deleteHome(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        if (QuickHomes.getHomeStorage().deleteHome(player.method_5667(), name)) {
            source.method_9226(() -> MessageUtils.createHomeDeleteMessage(player, name), false);
            return 1;
        }
        source.method_45068(MessageUtils.createErrorMessage(player, "quickhomes.error.home.notfound", name));
        return 0;
    }

    private static int listHomes(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Map<String, Home> homes = QuickHomes.getHomeStorage().getPlayerHomes(player.method_5667());
        if (homes.isEmpty()) {
            source.method_45068(MessageUtils.createErrorMessage(player, "quickhomes.error.no.homes", new Object[0]));
            return 0;
        }
        int maxHomes = QuickHomes.getConfig().getMaxHomes();
        source.method_9226(() -> MessageUtils.createListHeader(player, homes.size(), maxHomes), false);
        for (Map.Entry<String, Home> entry : homes.entrySet()) {
            Home home = entry.getValue();
            String dimension = home.getDimension().method_29177().toString();
            source.method_9226(() -> MessageUtils.createHomeListEntry(player, (String)entry.getKey(), dimension, home.getX(), home.getY(), home.getZ()), false);
        }
        source.method_9226(() -> MessageUtils.createListFooter(), false);
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestHomes(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Map<String, Home> homes = QuickHomes.getHomeStorage().getPlayerHomes(player.method_5667());
        for (String homeName : homes.keySet()) {
            builder.suggest(homeName);
        }
        return builder.buildFuture();
    }
}

