/*
 * Decompiled with CFR 0.152.
 */
package net.natxo.quickhomes.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class QuickHomesConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "quickhomes.json");
    private int maxHomes = 5;
    private int teleportDelay = 3;
    private boolean allowCrossDimension = true;
    private boolean showTeleportAnimation = true;
    private boolean serverOnlyMode = true;
    private String serverLanguage = "en_us";
    private String teleportMessage = "\u00a7eTeleporting to home \u00a76%s\u00a7e...";
    private String teleportCompleteMessage = "\u00a7aWelcome to \u00a76%s\u00a7a!";
    private String teleportCancelledMessage = "\u00a7cTeleport cancelled!";

    public static QuickHomesConfig loadConfig() {
        if (CONFIG_FILE.exists()) {
            QuickHomesConfig quickHomesConfig;
            FileReader reader = new FileReader(CONFIG_FILE);
            try {
                quickHomesConfig = (QuickHomesConfig)GSON.fromJson((Reader)reader, QuickHomesConfig.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return quickHomesConfig;
        }
        QuickHomesConfig config = new QuickHomesConfig();
        config.saveConfig();
        return config;
    }

    public void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            writer.write("{\n");
            writer.write("  \"_comment1\": \"Quick Homes Configuration\",\n");
            writer.write("  \"_comment2\": \"==============================================\",\n");
            writer.write("  \n");
            writer.write("  \"maxHomes\": " + this.maxHomes + ",\n");
            writer.write("  \"teleportDelay\": " + this.teleportDelay + ",\n");
            writer.write("  \"allowCrossDimension\": " + this.allowCrossDimension + ",\n");
            writer.write("  \"showTeleportAnimation\": " + this.showTeleportAnimation + ",\n");
            writer.write("  \n");
            writer.write("  \"_comment3\": \"Server-Only Mode Settings\",\n");
            writer.write("  \"_comment4\": \"When serverOnlyMode is true, the server will send messages in the configured language\",\n");
            writer.write("  \"_comment5\": \"instead of translation keys. This is useful when clients don't have the mod installed.\",\n");
            writer.write("  \"serverOnlyMode\": " + this.serverOnlyMode + ",\n");
            writer.write("  \n");
            writer.write("  \"_comment6\": \"Server Language (used when serverOnlyMode is true)\",\n");
            writer.write("  \"_comment7\": \"Available languages: en_us (English), es_es (Spanish), fr_fr (French),\",\n");
            writer.write("  \"_comment8\": \"de_de (German), it_it (Italian), pt_br (Portuguese Brazil)\",\n");
            writer.write("  \"serverLanguage\": \"" + this.serverLanguage + "\",\n");
            writer.write("  \n");
            writer.write("  \"_comment9\": \"Legacy message settings (deprecated, will be removed in future versions)\",\n");
            writer.write("  \"teleportMessage\": \"" + this.teleportMessage + "\",\n");
            writer.write("  \"teleportCompleteMessage\": \"" + this.teleportCompleteMessage + "\",\n");
            writer.write("  \"teleportCancelledMessage\": \"" + this.teleportCancelledMessage + "\"\n");
            writer.write("}\n");
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getMaxHomes() {
        return this.maxHomes;
    }

    public int getTeleportDelay() {
        return this.teleportDelay;
    }

    public boolean isAllowCrossDimension() {
        return this.allowCrossDimension;
    }

    public boolean isShowTeleportAnimation() {
        return this.showTeleportAnimation;
    }

    public String getTeleportMessage() {
        return this.teleportMessage;
    }

    public String getTeleportCompleteMessage() {
        return this.teleportCompleteMessage;
    }

    public String getTeleportCancelledMessage() {
        return this.teleportCancelledMessage;
    }

    public boolean isServerOnlyMode() {
        return this.serverOnlyMode;
    }

    public String getServerLanguage() {
        return this.serverLanguage;
    }
}

