/*
 * Decompiled with CFR 0.152.
 */
package net.natxo.quickhomes.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.natxo.quickhomes.QuickHomes;
import net.natxo.quickhomes.data.Home;

public class HomeStorage {
    private final Map<UUID, Map<String, Home>> playerHomes = new HashMap<UUID, Map<String, Home>>();
    private final File saveFile;

    public HomeStorage(MinecraftServer server) {
        File worldDir = server.method_27050(class_5218.field_24188).toFile();
        File dataDir = new File(worldDir, "quick-homes");
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        this.saveFile = new File(dataDir, "homes.dat");
    }

    public void load() {
        if (!this.saveFile.exists()) {
            QuickHomes.LOGGER.info("No homes data file found, starting fresh");
            return;
        }
        try (FileInputStream fis = new FileInputStream(this.saveFile);){
            class_2487 nbt = class_2507.method_10629((InputStream)fis, (class_2505)class_2505.method_53898());
            this.playerHomes.clear();
            for (String uuidString : nbt.method_10541()) {
                try {
                    UUID playerUuid = UUID.fromString(uuidString);
                    class_2487 playerNbt = nbt.method_10545(uuidString) ? nbt.method_10562(uuidString).orElse(new class_2487()) : new class_2487();
                    HashMap<String, Home> homes = new HashMap<String, Home>();
                    for (String homeName : playerNbt.method_10541()) {
                        class_2487 homeNbt = playerNbt.method_10545(homeName) ? playerNbt.method_10562(homeName).orElse(new class_2487()) : new class_2487();
                        Home home = Home.fromNbt(homeNbt);
                        homes.put(homeName, home);
                    }
                    this.playerHomes.put(playerUuid, homes);
                    QuickHomes.LOGGER.info("Loaded {} homes for player {}", (Object)homes.size(), (Object)uuidString);
                }
                catch (Exception e) {
                    QuickHomes.LOGGER.error("Failed to load homes for player {}", (Object)uuidString, (Object)e);
                }
            }
            QuickHomes.LOGGER.info("Successfully loaded homes for {} players", (Object)this.playerHomes.size());
        }
        catch (IOException e) {
            QuickHomes.LOGGER.error("Failed to load homes data from {}", (Object)this.saveFile.getAbsolutePath(), (Object)e);
        }
    }

    public void save() {
        try {
            if (!this.saveFile.getParentFile().exists()) {
                this.saveFile.getParentFile().mkdirs();
            }
            class_2487 nbt = new class_2487();
            int totalHomes = 0;
            for (Map.Entry<UUID, Map<String, Home>> entry : this.playerHomes.entrySet()) {
                class_2487 playerNbt = new class_2487();
                for (Map.Entry<String, Home> homeEntry : entry.getValue().entrySet()) {
                    playerNbt.method_10566(homeEntry.getKey(), (class_2520)homeEntry.getValue().toNbt());
                    ++totalHomes;
                }
                nbt.method_10566(entry.getKey().toString(), (class_2520)playerNbt);
            }
            try (FileOutputStream fos = new FileOutputStream(this.saveFile);){
                class_2507.method_10634((class_2487)nbt, (OutputStream)fos);
            }
            QuickHomes.LOGGER.info("Saved {} homes for {} players to {}", new Object[]{totalHomes, this.playerHomes.size(), this.saveFile.getAbsolutePath()});
        }
        catch (IOException e) {
            QuickHomes.LOGGER.error("Failed to save homes data to {}", (Object)this.saveFile.getAbsolutePath(), (Object)e);
        }
    }

    public void setHome(UUID playerUuid, String name, Home home) {
        this.playerHomes.computeIfAbsent(playerUuid, k -> new HashMap()).put(name, home);
        QuickHomes.LOGGER.info("Set home '{}' for player {}", (Object)name, (Object)playerUuid);
        this.save();
    }

    public Home getHome(UUID playerUuid, String name) {
        Map<String, Home> homes = this.playerHomes.get(playerUuid);
        return homes != null ? homes.get(name) : null;
    }

    public boolean deleteHome(UUID playerUuid, String name) {
        Map<String, Home> homes = this.playerHomes.get(playerUuid);
        if (homes != null) {
            boolean removed;
            boolean bl = removed = homes.remove(name) != null;
            if (removed) {
                QuickHomes.LOGGER.info("Deleted home '{}' for player {}", (Object)name, (Object)playerUuid);
                this.save();
            }
            return removed;
        }
        return false;
    }

    public Map<String, Home> getPlayerHomes(UUID playerUuid) {
        return this.playerHomes.getOrDefault(playerUuid, new HashMap());
    }

    public int getHomeCount(UUID playerUuid) {
        Map<String, Home> homes = this.playerHomes.get(playerUuid);
        return homes != null ? homes.size() : 0;
    }
}

