/*
 * Decompiled with CFR 0.152.
 */
package net.natxo.quickhomes.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.natxo.quickhomes.QuickHomes;

public class MessageUtils {
    private static boolean forceServerSideText = false;
    private static String serverLanguage = "en_us";
    private static final Map<String, String> serverTranslations = new HashMap<String, String>();
    private static final String PROGRESS_BAR_FILLED = "\u2588";
    private static final String PROGRESS_BAR_EMPTY = "\u2591";
    private static final int PROGRESS_BAR_LENGTH = 20;

    public static void setForceServerSideText(boolean force) {
        forceServerSideText = force;
    }

    public static void loadServerTranslations(String language) {
        serverLanguage = language;
        serverTranslations.clear();
        String resourcePath = "/assets/quickhomes/lang/" + language + ".json";
        try (InputStream stream = MessageUtils.class.getResourceAsStream(resourcePath);){
            if (stream != null) {
                Gson gson = new Gson();
                JsonObject json = (JsonObject)gson.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class);
                json.entrySet().forEach(entry -> serverTranslations.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
                QuickHomes.LOGGER.info("Loaded " + serverTranslations.size() + " translations for language: " + language);
            } else {
                QuickHomes.LOGGER.warn("Translation file not found: " + resourcePath + ", using fallback English");
            }
        }
        catch (Exception e) {
            QuickHomes.LOGGER.error("Failed to load translations for " + language, (Throwable)e);
        }
    }

    public static class_5250 getLocalizedText(class_3222 player, String key, Object ... args) {
        if (forceServerSideText) {
            return class_2561.method_43470((String)MessageUtils.getServerTranslation(key, args));
        }
        return class_2561.method_43469((String)key, (Object[])args);
    }

    private static String getServerTranslation(String key, Object ... args) {
        String translation = serverTranslations.get(key);
        if (translation != null) {
            if (args.length > 0) {
                try {
                    return String.format(translation, args);
                }
                catch (Exception e) {
                    QuickHomes.LOGGER.warn("Failed to format translation for key: " + key);
                    return translation;
                }
            }
            return translation;
        }
        return MessageUtils.getFallbackText(key, args);
    }

    private static String getFallbackText(String key, Object ... args) {
        switch (key) {
            case "quickhomes.teleport.start.delayed": {
                return String.format("Teleporting to %s in %d seconds...", args[0], args[1]);
            }
            case "quickhomes.teleport.start.instant": {
                return String.format("Teleporting to %s...", args[0]);
            }
            case "quickhomes.home.set": {
                return String.format("Home '%s' has been set", args[0]);
            }
            case "quickhomes.home.location": {
                return String.format("%s in %s", args[0], args[1]);
            }
            case "quickhomes.home.deleted": {
                return String.format("Home '%s' has been deleted", args[0]);
            }
            case "quickhomes.teleport.complete": {
                return String.format("Welcome to %s!", args[0]);
            }
            case "quickhomes.teleport.cancelled": {
                return "Teleport cancelled";
            }
            case "quickhomes.teleport.cancelled.reason": {
                return String.format("Teleport cancelled: %s", args[0]);
            }
            case "quickhomes.list.title": {
                return "Your Homes";
            }
            case "quickhomes.dimension.overworld": {
                return "Overworld";
            }
            case "quickhomes.dimension.nether": {
                return "Nether";
            }
            case "quickhomes.dimension.end": {
                return "The End";
            }
            case "quickhomes.dimension.custom": {
                return "Custom Dimension";
            }
            case "quickhomes.error.home.notfound": {
                return args.length > 0 ? String.format("Home '%s' not found", args[0]) : "Home not found";
            }
            case "quickhomes.error.no.homes": {
                return "You don't have any homes set";
            }
            case "quickhomes.error.max.homes": {
                return args.length > 0 ? String.format("Maximum homes reached (%s)", args[0]) : "Maximum homes reached";
            }
            case "quickhomes.error.home.exists": {
                return args.length > 0 ? String.format("Home '%s' already exists", args[0]) : "Home already exists";
            }
            case "quickhomes.error.invalid.name": {
                return "Invalid home name";
            }
            case "quickhomes.error.teleport.pending": {
                return "You already have a teleport in progress";
            }
            case "quickhomes.teleport.moved": {
                return "Teleport cancelled - you moved!";
            }
            case "quickhomes.teleport.damaged": {
                return "Teleport cancelled - you took damage!";
            }
            case "quickhomes.error.world.not.loaded": {
                return "Target world is not loaded";
            }
            case "quickhomes.error.crossdim.disabled": {
                return "Cross-dimensional teleportation is disabled";
            }
            case "quickhomes.teleport.cancelled.movement": {
                return "Teleport cancelled - too much movement detected";
            }
            case "quickhomes.teleport.cancelled.attempts": {
                return args.length > 0 ? String.format("Teleport cancelled after %s attempts", args[0]) : "Teleport cancelled - too many attempts";
            }
            case "quickhomes.teleport.retry": {
                return args.length >= 2 ? String.format("Retrying teleport (Attempt %s/%s)", args[0], args[1]) : "Retrying teleport";
            }
        }
        return key;
    }

    public static class_2561 createProgressBar(int current, int total) {
        int filled = (int)((double)current / (double)total * 20.0);
        int empty = 20 - filled;
        class_5250 progressBar = class_2561.method_43470((String)"");
        progressBar.method_10852((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1080));
        if (filled > 0) {
            progressBar.method_10852((class_2561)class_2561.method_43470((String)PROGRESS_BAR_FILLED.repeat(filled)).method_10862(class_2583.field_24360.method_36139(MessageUtils.interpolateColor(current, total))));
        }
        if (empty > 0) {
            progressBar.method_10852((class_2561)class_2561.method_43470((String)PROGRESS_BAR_EMPTY.repeat(empty)).method_27692(class_124.field_1063));
        }
        progressBar.method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1080));
        progressBar.method_10852((class_2561)class_2561.method_43470((String)(" " + (total - current) + "s")).method_27692(class_124.field_1075));
        return progressBar;
    }

    private static int interpolateColor(int current, int total) {
        float progress = (float)current / (float)total;
        if (progress < 0.33f) {
            return 0xFF0000;
        }
        if (progress < 0.66f) {
            return 0xFFAA00;
        }
        return 0x55FF55;
    }

    public static class_2561 createTeleportStartMessage(class_3222 player, String homeName, int delay) {
        class_5250 message = class_2561.method_43470((String)"");
        message.method_10852((class_2561)class_2561.method_43470((String)"\u26a1 ").method_27692(class_124.field_1054));
        if (delay > 0) {
            message.method_10852((class_2561)MessageUtils.getLocalizedText(player, "quickhomes.teleport.start.delayed", homeName, delay).method_27692(class_124.field_1080));
        } else {
            message.method_10852((class_2561)MessageUtils.getLocalizedText(player, "quickhomes.teleport.start.instant", homeName).method_27692(class_124.field_1080));
        }
        return message;
    }

    public static class_2561 createHomeSetMessage(class_3222 player, String homeName, String dimension, double x, double y, double z) {
        class_5250 message = class_2561.method_43470((String)"");
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2713 ").method_27692(class_124.field_1060));
        message.method_10852((class_2561)MessageUtils.getLocalizedText(player, "quickhomes.home.set", homeName).method_27692(class_124.field_1080));
        message.method_10852((class_2561)class_2561.method_43470((String)"\n  ").method_27692(class_124.field_1080));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u27a4 ").method_27692(class_124.field_1063));
        message.method_10852((class_2561)MessageUtils.getLocalizedText(player, "quickhomes.home.location", String.format("%.0f, %.0f, %.0f", x, y, z), MessageUtils.formatDimension(player, dimension)).method_27692(class_124.field_1080));
        return message;
    }

    public static class_2561 createHomeDeleteMessage(class_3222 player, String homeName) {
        class_5250 message = class_2561.method_43470((String)"");
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2717 ").method_27692(class_124.field_1061));
        message.method_10852((class_2561)MessageUtils.getLocalizedText(player, "quickhomes.home.deleted", homeName).method_27692(class_124.field_1080));
        return message;
    }

    public static class_2561 createTeleportCompleteMessage(class_3222 player, String homeName) {
        class_5250 message = class_2561.method_43470((String)"");
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2728 ").method_27692(class_124.field_1076));
        message.method_10852((class_2561)MessageUtils.getLocalizedText(player, "quickhomes.teleport.complete", homeName).method_27692(class_124.field_1060));
        return message;
    }

    public static class_2561 createTeleportCancelledMessage(class_3222 player, String reason) {
        class_5250 message = class_2561.method_43470((String)"");
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2717 ").method_27692(class_124.field_1061));
        if (reason != null && !reason.isEmpty()) {
            message.method_10852((class_2561)MessageUtils.getLocalizedText(player, "quickhomes.teleport.cancelled.reason", reason).method_27692(class_124.field_1061));
        } else {
            message.method_10852((class_2561)MessageUtils.getLocalizedText(player, "quickhomes.teleport.cancelled", new Object[0]).method_27692(class_124.field_1061));
        }
        return message;
    }

    public static class_2561 createErrorMessage(class_3222 player, String key, Object ... args) {
        class_5250 message = class_2561.method_43470((String)"");
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2717 ").method_27692(class_124.field_1061));
        if (key.startsWith("quickhomes.")) {
            message.method_10852((class_2561)MessageUtils.getLocalizedText(player, key, args).method_27692(class_124.field_1061));
        } else {
            message.method_10852((class_2561)class_2561.method_43470((String)key).method_27692(class_124.field_1061));
        }
        return message;
    }

    public static class_2561 createListHeader(class_3222 player, int count, int max) {
        class_5250 message = class_2561.method_43470((String)"");
        message.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").method_27692(class_124.field_1062));
        message.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        message.method_10852((class_2561)class_2561.method_43470((String)"     ").method_27692(class_124.field_1080));
        message.method_10852((class_2561)MessageUtils.getLocalizedText(player, "quickhomes.list.title", new Object[0]).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
        message.method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080));
        message.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(count)).method_27692(class_124.field_1054));
        message.method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1080));
        message.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(max)).method_27692(class_124.field_1060));
        message.method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080));
        message.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").method_27692(class_124.field_1062));
        return message;
    }

    public static class_2561 createHomeListEntry(class_3222 player, String name, String dimension, double x, double y, double z) {
        class_5250 message = class_2561.method_43470((String)"");
        message.method_10852((class_2561)class_2561.method_43470((String)"\n "));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u25b8 ").method_27692(class_124.field_1063));
        message.method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1065));
        message.method_10852((class_2561)class_2561.method_43470((String)" \u27a4 ").method_27692(class_124.field_1063));
        message.method_10852((class_2561)MessageUtils.getLocalizedText(player, MessageUtils.getDimensionTranslationKey(dimension), new Object[0]).method_27692(class_124.field_1075));
        message.method_10852((class_2561)class_2561.method_43470((String)"\n   ").method_27692(class_124.field_1080));
        message.method_10852((class_2561)class_2561.method_43470((String)String.format("%.0f, %.0f, %.0f", x, y, z)).method_27692(class_124.field_1080));
        return message;
    }

    public static class_2561 createListFooter() {
        return class_2561.method_43470((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").method_27692(class_124.field_1062);
    }

    private static String formatDimension(class_3222 player, String dimension) {
        if (forceServerSideText) {
            return MessageUtils.getServerTranslation(MessageUtils.getDimensionTranslationKey(dimension), new Object[0]);
        }
        return class_2561.method_43471((String)MessageUtils.getDimensionTranslationKey(dimension)).getString();
    }

    private static String getDimensionTranslationKey(String dimension) {
        if (dimension.contains("overworld")) {
            return "quickhomes.dimension.overworld";
        }
        if (dimension.contains("nether")) {
            return "quickhomes.dimension.nether";
        }
        if (dimension.contains("end")) {
            return "quickhomes.dimension.end";
        }
        return "quickhomes.dimension.custom";
    }
}

