/*
 * Decompiled with CFR 0.152.
 */
package net.natxo.quickhomes.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.natxo.quickhomes.QuickHomes;
import net.natxo.quickhomes.data.Home;
import net.natxo.quickhomes.util.MessageUtils;

public class TeleportManager {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final Map<UUID, TeleportTask> pendingTeleports = new HashMap<UUID, TeleportTask>();

    public static void teleportToHome(class_3222 player, Home home) {
        UUID playerUuid = player.method_5667();
        if (pendingTeleports.containsKey(playerUuid)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You already have a pending teleport!").method_27692(class_124.field_1061), true);
            return;
        }
        int delay = QuickHomes.getConfig().getTeleportDelay();
        player.method_7353(MessageUtils.createTeleportStartMessage(player, home.getName(), delay), false);
        TeleportTask task = new TeleportTask(player, home);
        pendingTeleports.put(playerUuid, task);
        if (delay > 0) {
            task.start(delay);
        } else {
            TeleportManager.executeTeleport(player, home);
            pendingTeleports.remove(playerUuid);
        }
    }

    private static void executeTeleport(class_3222 player, Home home) {
        class_3218 targetWorld = QuickHomes.getServer().method_3847(home.getDimension());
        if (targetWorld == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Target dimension not found!").method_27692(class_124.field_1061), true);
            return;
        }
        if (QuickHomes.getConfig().isShowTeleportAnimation()) {
            TeleportManager.spawnTeleportParticles(player.method_51469(), new class_243(player.method_23317(), player.method_23318(), player.method_23321()));
            player.method_51469().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
        }
        player.method_48105(targetWorld, home.getX(), home.getY(), home.getZ(), Set.of(), home.getYaw(), home.getPitch(), false);
        if (QuickHomes.getConfig().isShowTeleportAnimation()) {
            TeleportManager.spawnTeleportParticles(targetWorld, new class_243(home.getX(), home.getY(), home.getZ()));
            targetWorld.method_43128(null, home.getX(), home.getY(), home.getZ(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
            player.method_6092(new class_1293(class_1294.field_5919, 20, 0, false, false));
        }
        player.method_7353(MessageUtils.createTeleportCompleteMessage(player, home.getName()), true);
    }

    private static void spawnTeleportParticles(class_3218 world, class_243 pos) {
        double offsetZ;
        double offsetY;
        double offsetX;
        int i;
        for (i = 0; i < 32; ++i) {
            offsetX = (world.field_9229.method_43058() - 0.5) * 2.0;
            offsetY = world.field_9229.method_43058() * 2.0;
            offsetZ = (world.field_9229.method_43058() - 0.5) * 2.0;
            world.method_65096((class_2394)class_2398.field_11214, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 16; ++i) {
            offsetX = world.field_9229.method_43058() - 0.5;
            offsetY = world.field_9229.method_43058();
            offsetZ = world.field_9229.method_43058() - 0.5;
            world.method_65096((class_2394)class_2398.field_11249, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void cancelTeleport(UUID playerUuid, boolean sendMessage) {
        TeleportTask task = pendingTeleports.remove(playerUuid);
        if (task != null) {
            task.cancel();
            if (sendMessage && task.player != null && task.player.method_5805()) {
                task.player.method_7353(MessageUtils.createTeleportCancelledMessage(task.player, "Movement detected"), true);
            }
        }
    }

    private static class TeleportTask {
        private final class_3222 player;
        private final Home home;
        private class_243 startPos;
        private ScheduledFuture<?> future;
        private int remainingSeconds;
        private int attemptCount = 0;
        private long firstMovementTime = 0L;
        private static final int MAX_ATTEMPTS = 3;
        private static final long MAX_MOVEMENT_TIME = 5000L;

        public TeleportTask(class_3222 player, Home home) {
            this.player = player;
            this.home = home;
            this.startPos = new class_243(player.method_23317(), player.method_23318(), player.method_23321());
        }

        public void start(int delaySeconds) {
            this.remainingSeconds = delaySeconds;
            if (this.future != null && !this.future.isCancelled()) {
                this.future.cancel(true);
            }
            this.future = scheduler.scheduleAtFixedRate(() -> {
                if (!this.player.method_5805() || this.player.method_31481()) {
                    TeleportManager.cancelTeleport(this.player.method_5667(), false);
                    return;
                }
                class_243 currentPos = new class_243(this.player.method_23317(), this.player.method_23318(), this.player.method_23321());
                if (currentPos.method_1022(this.startPos) > 0.5) {
                    this.handleMovement();
                    return;
                }
                if (this.remainingSeconds > 0) {
                    int totalSeconds = QuickHomes.getConfig().getTeleportDelay();
                    class_2561 progressBar = MessageUtils.createProgressBar(totalSeconds - this.remainingSeconds, totalSeconds);
                    this.player.method_7353(progressBar, true);
                    if (QuickHomes.getConfig().isShowTeleportAnimation()) {
                        double angle;
                        int i;
                        class_3218 world = this.player.method_51469();
                        double time = (double)System.currentTimeMillis() / 1000.0;
                        int particleCount = 8;
                        for (i = 0; i < particleCount; ++i) {
                            angle = Math.PI * 2 / (double)particleCount * (double)i + time * 2.0;
                            double radius = 1.2;
                            double x = this.player.method_23317() + Math.cos(angle) * radius;
                            double z = this.player.method_23321() + Math.sin(angle) * radius;
                            double y = this.player.method_23318() + 0.1 + Math.sin(time * 3.0) * 0.3;
                            world.method_65096((class_2394)class_2398.field_11208, x, y, z, 1, 0.0, 0.1, 0.0, 0.0);
                        }
                        for (i = 0; i < 3; ++i) {
                            double offsetX = (world.field_9229.method_43058() - 0.5) * 0.5;
                            double offsetZ = (world.field_9229.method_43058() - 0.5) * 0.5;
                            double offsetY = world.field_9229.method_43058() * 2.0;
                            world.method_65096((class_2394)class_2398.field_11207, this.player.method_23317() + offsetX, this.player.method_23318() + offsetY, this.player.method_23321() + offsetZ, 1, 0.0, 0.05, 0.0, 0.01);
                        }
                        if (this.remainingSeconds == 1) {
                            for (i = 0; i < 20; ++i) {
                                angle = 0.3141592653589793 * (double)i;
                                double x = this.player.method_23317() + Math.cos(angle) * 0.5;
                                double z = this.player.method_23321() + Math.sin(angle) * 0.5;
                                world.method_65096((class_2394)class_2398.field_22246, x, this.player.method_23318() + 1.0, z, 1, 0.0, 0.0, 0.0, 0.02);
                            }
                        }
                    }
                    --this.remainingSeconds;
                } else {
                    this.cancel();
                    pendingTeleports.remove(this.player.method_5667());
                    TeleportManager.executeTeleport(this.player, this.home);
                }
            }, 0L, 1L, TimeUnit.SECONDS);
        }

        public void cancel() {
            if (this.future != null && !this.future.isCancelled()) {
                this.future.cancel(true);
            }
        }

        private void handleMovement() {
            long currentTime = System.currentTimeMillis();
            if (this.firstMovementTime == 0L) {
                this.firstMovementTime = currentTime;
            }
            if (currentTime - this.firstMovementTime > 5000L) {
                this.player.method_7353(MessageUtils.createErrorMessage(this.player, "quickhomes.teleport.cancelled.movement", new Object[0]), true);
                TeleportManager.cancelTeleport(this.player.method_5667(), false);
                return;
            }
            ++this.attemptCount;
            if (this.attemptCount >= 3) {
                this.player.method_7353(MessageUtils.createErrorMessage(this.player, "quickhomes.teleport.cancelled.attempts", 3), true);
                TeleportManager.cancelTeleport(this.player.method_5667(), false);
            } else {
                this.player.method_7353((class_2561)MessageUtils.getLocalizedText(this.player, "quickhomes.teleport.retry", this.attemptCount + 1, 3).method_27692(class_124.field_1054), true);
                this.startPos = new class_243(this.player.method_23317(), this.player.method_23318(), this.player.method_23321());
                this.remainingSeconds = QuickHomes.getConfig().getTeleportDelay();
            }
        }
    }
}

