/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.components;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Observable;
import java.util.concurrent.atomic.AtomicInteger;
import melonslise.locks.Locks;
import melonslise.locks.common.components.interfaces.ILockableHandler;
import melonslise.locks.common.components.interfaces.ILockableStorage;
import melonslise.locks.common.config.LocksServerConfig;
import melonslise.locks.common.init.LocksComponents;
import melonslise.locks.common.network.toclient.AddLockablePacket;
import melonslise.locks.common.network.toclient.RemoveLockablePacket;
import melonslise.locks.common.network.toclient.UpdateLockablePacket;
import melonslise.locks.common.util.Lockable;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class LockableHandler
implements ILockableHandler {
    public static final class_2960 ID = new class_2960("locks", "lockable_handler");
    public final class_1937 world;
    public AtomicInteger lastId = new AtomicInteger();
    public Int2ObjectMap<Lockable> lockables = new Int2ObjectLinkedOpenHashMap();

    public LockableHandler(class_1937 world) {
        this.world = world;
    }

    @Override
    public int nextId() {
        return this.lastId.incrementAndGet();
    }

    @Override
    public Int2ObjectMap<Lockable> getLoaded() {
        return this.lockables;
    }

    @Override
    public Int2ObjectMap<Lockable> getInChunk(class_2338 pos) {
        return this.world.method_22340(pos) ? ((ILockableStorage)LocksComponents.LOCKABLE_STORAGE.get((Object)this.world.method_8500(pos))).get() : new Int2ObjectMap<Lockable>();
    }

    @Override
    public boolean add(Lockable lkb, class_1937 level) {
        if (lkb.bb.volume() > (Integer)LocksServerConfig.MAX_LOCKABLE_VOLUME.get()) {
            return false;
        }
        List<ILockableStorage> sts = lkb.bb.containedChunksTo((x, z) -> {
            try {
                class_2818 levelChunk = level.method_8497(x, z);
                ILockableStorage st = (ILockableStorage)LocksComponents.LOCKABLE_STORAGE.get((Object)levelChunk);
                return st.get().values().stream().anyMatch(lkb1 -> lkb1.bb.intersects(lkb.bb)) ? null : st;
            }
            catch (Exception e) {
                Locks.LOGGER.warn("Chunk not gen");
                return null;
            }
        }, true);
        if (sts == null) {
            return false;
        }
        for (int a = 0; a < sts.size(); ++a) {
            sts.get(a).add(lkb);
        }
        this.lockables.put(lkb.id, (Object)lkb);
        lkb.addObserver(this);
        if (level.field_9236) {
            lkb.swing(10);
        } else {
            level.method_8503().method_3760().field_14351.forEach(player -> ServerPlayNetworking.send((class_3222)player, (FabricPacket)new AddLockablePacket(lkb)));
        }
        return true;
    }

    @Override
    public boolean remove(int id) {
        Lockable lkb = (Lockable)this.lockables.get(id);
        if (lkb == this.lockables.defaultReturnValue()) {
            return false;
        }
        List<class_2818> chs = lkb.bb.containedChunksTo((x, z) -> this.world.method_8393(x, z) ? this.world.method_8497(x, z) : null, true);
        for (int a = 0; a < chs.size(); ++a) {
            ((ILockableStorage)LocksComponents.LOCKABLE_STORAGE.get((Object)chs.get(a))).remove(id);
        }
        this.lockables.remove(id);
        lkb.deleteObserver(this);
        if (this.world.field_9236) {
            return true;
        }
        this.world.method_8503().method_3760().field_14351.forEach(player -> ServerPlayNetworking.send((class_3222)player, (FabricPacket)new RemoveLockablePacket(lkb.id)));
        return true;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.world.field_9236 || !(o instanceof Lockable)) {
            return;
        }
        Lockable lockable = (Lockable)o;
        this.world.method_8503().method_3760().field_14351.forEach(player -> ServerPlayNetworking.send((class_3222)player, (FabricPacket)new UpdateLockablePacket(lockable)));
    }

    public void readFromNbt(class_2487 compoundTag) {
        this.lastId.set(compoundTag.method_10550("last_id"));
        int size = compoundTag.method_10550("LockablesSize");
        class_2499 lockables = compoundTag.method_10554("Lockables", 10);
        for (int a = 0; a < lockables.size(); ++a) {
            class_2487 nbt1 = lockables.method_10602(a);
            Lockable lkb = Lockable.fromNbt(nbt1);
            this.lockables.put(lkb.id, (Object)lkb);
            lkb.addObserver(this);
        }
    }

    public void writeToNbt(class_2487 compoundTag) {
        compoundTag.method_10569("last_id", this.lastId.get());
        class_2499 list = new class_2499();
        for (Lockable lkb : this.lockables.values()) {
            list.add((Object)Lockable.toNbt(lkb));
        }
        compoundTag.method_10566("Lockables", (class_2520)list);
        compoundTag.method_10569("LockablesSize", this.lockables.size());
    }

    public void sync() {
    }
}

