/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.config;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import melonslise.locks.common.util.LocksUtil;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraftforge.common.ForgeConfigSpec;

public final class LocksConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.DoubleValue GENERATION_CHANCE;
    public static final ForgeConfigSpec.DoubleValue GENERATION_ENCHANT_CHANCE;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> GENERATED_LOCKS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> GENERATED_LOCK_WEIGHTS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> GEN_LOCKABLE_BLOCKS;
    public static final ForgeConfigSpec.BooleanValue RANDOMIZE_LOADED_LOCKS;
    public static NavigableMap<Integer, class_1792> weightedGeneratedLocks;
    public static int weightTotal;
    public static Pattern[] lockableGenBlocks;

    private LocksConfig() {
    }

    public static void init() {
        weightedGeneratedLocks = new TreeMap<Integer, class_1792>();
        weightTotal = 0;
        lockableGenBlocks = (Pattern[])((List)GEN_LOCKABLE_BLOCKS.get()).stream().map(Pattern::compile).toArray(Pattern[]::new);
        List locks = (List)GENERATED_LOCKS.get();
        List weights = (List)GENERATED_LOCK_WEIGHTS.get();
        for (int a = 0; a < locks.size(); ++a) {
            weightedGeneratedLocks.put(weightTotal += ((Integer)weights.get(a)).intValue(), (class_1792)class_7923.field_41178.method_10223(new class_2960((String)locks.get(a))));
        }
    }

    public static boolean canGen(class_5819 rng, class_2248 block) {
        boolean random = LocksUtil.chance(rng, (Double)GENERATION_CHANCE.get());
        return random && LocksConfig.matchString(block);
    }

    public static boolean matchString(class_2248 block) {
        String name = class_7923.field_41175.method_10221((Object)block).toString();
        if (lockableGenBlocks == null) {
            LocksConfig.init();
        }
        for (Pattern p : lockableGenBlocks) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean canEnchant(class_5819 rng) {
        return LocksUtil.chance(rng, (Double)GENERATION_ENCHANT_CHANCE.get());
    }

    public static class_1799 getRandomLock(class_5819 rng) {
        class_1799 stack = new class_1799((class_1935)weightedGeneratedLocks.ceilingEntry(rng.method_43048(weightTotal) + 1).getValue());
        return LocksConfig.canEnchant(rng) ? class_1890.method_8233((class_5819)rng, (class_1799)stack, (int)(5 + rng.method_43048(30)), (boolean)false) : stack;
    }

    static {
        ForgeConfigSpec.Builder cfg = new ForgeConfigSpec.Builder();
        GENERATION_CHANCE = cfg.comment("Chance to generate a random lock on every new chest during world generation. Set to 0 to disable").comment("\u5728\u4e16\u754c\u751f\u6210\u8fc7\u7a0b\u4e2d\uff0c\u6bcf\u4e2a\u65b0\u7bb1\u5b50\u751f\u6210\u4e00\u4e2a\u968f\u673a\u9501\u7684\u6982\u7387\u3002\u8bbe\u7f6e\u4e3a0\u4ee5\u7981\u7528\u6b64\u529f\u80fd\u3002").defineInRange("Generation Chance", 0.85, 0.0, 1.0);
        GENERATION_ENCHANT_CHANCE = cfg.comment("Chance to randomly enchant a generated lock during world generation. Set to 0 to disable").comment("\u5728\u4e16\u754c\u751f\u6210\u8fc7\u7a0b\u4e2d\uff0c\u968f\u673a\u9644\u9b54\u751f\u6210\u7684\u9501\u7684\u6982\u7387\u3002\u8bbe\u7f6e\u4e3a0\u4ee5\u7981\u7528\u6b64\u529f\u80fd\u3002").defineInRange("Generation Enchant Chance", 0.4, 0.0, 1.0);
        GEN_LOCKABLE_BLOCKS = cfg.comment("Blocks that can be locked during the world generation").comment("\u5f53\u4e16\u754c\u751f\u6210\u65f6\u9501\u5b9a\u7684\u65b9\u5757").defineList("Lockable Generated Blocks", (List)Lists.newArrayList((Object[])new String[]{"minecraft:chest", "minecraft:barrel", "lootr:.*", "quark:.*_chest"}), e -> e instanceof String);
        GENERATED_LOCKS = cfg.comment("Items that can be generated as locks (must be instance of LockItem in code!)").comment("\u53ef\u4ee5\u4f5c\u4e3a\u9501\u751f\u6210\u7684\u7269\u54c1\uff08\u5728\u4ee3\u7801\u4e2d\u5fc5\u987b\u662f LockItem \u7684\u5b9e\u4f8b\uff01\uff09").defineList("Generated Locks", (List)Lists.newArrayList((Object[])new String[]{"locks:wood_lock", "locks:iron_lock", "locks:steel_lock", "locks:gold_lock", "locks:diamond_lock"}), e -> e instanceof String);
        GENERATED_LOCK_WEIGHTS = cfg.comment(new String[]{"WARNING: THE AMOUNT OF NUMBERS SHOULD BE EQUAL TO THE AMOUNT OF GENERATED LOCK ITEMS!!!", "The relative probability that the corresponding lock item will be generated on a chest. Higher number = higher chance to generate"}).comment(new String[]{"\u8b66\u544a\uff1a\u6570\u5b57\u7684\u6570\u91cf\u5e94\u4e0e\u751f\u6210\u7684\u9501\u6570\u91cf\u76f8\u7b49\uff01\uff01\uff01", "\u5bf9\u5e94\u9501\u7269\u54c1\u751f\u6210\u5728\u7bb1\u5b50\u4e0a\u7684\u76f8\u5bf9\u6982\u7387\u3002\u6570\u5b57\u8d8a\u5927\uff0c\u751f\u6210\u7684\u673a\u4f1a\u8d8a\u9ad8\u3002"}).defineList("Generated Lock Chances", (List)Lists.newArrayList((Object[])new Integer[]{5, 4, 2, 3, 1}), e -> e instanceof Integer);
        RANDOMIZE_LOADED_LOCKS = cfg.comment("Randomize lock IDs and combinations when loading them from a structure file. Randomization works just like during world generation").comment("\u4ece\u7ed3\u6784\u6587\u4ef6\u52a0\u8f7d\u9501ID\u548c\u7ec4\u5408\u65f6\u8fdb\u884c\u968f\u673a\u5316\u3002\u968f\u673a\u5316\u7684\u65b9\u5f0f\u4e0e\u4e16\u754c\u751f\u6210\u65f6\u76f8\u540c\u3002").define("Randomize Loaded Locks", true);
        SPEC = cfg.build();
    }
}

