/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.config;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_7923;
import net.minecraftforge.common.ForgeConfigSpec;

public class LocksServerConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.IntValue MAX_LOCKABLE_VOLUME;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> LOCKABLE_BLOCKS;
    public static final ForgeConfigSpec.BooleanValue ALLOW_REMOVING_LOCKS;
    public static final ForgeConfigSpec.BooleanValue PROTECT_LOCKABLES;
    public static final ForgeConfigSpec.BooleanValue EASY_LOCK;
    public static final ForgeConfigSpec.BooleanValue STRONG_PREVENTION;
    public static Pattern[] lockableBlocks;

    private LocksServerConfig() {
    }

    public static void init() {
        lockableBlocks = (Pattern[])((List)LOCKABLE_BLOCKS.get()).stream().map(Pattern::compile).toArray(Pattern[]::new);
    }

    public static boolean canLock(class_1937 world, class_2338 pos) {
        if (lockableBlocks == null) {
            LocksServerConfig.init();
        }
        class_2248 block = world.method_8320(pos).method_26204();
        String name = class_7923.field_41175.method_10221((Object)block).toString();
        for (Pattern p : lockableBlocks) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    static {
        ForgeConfigSpec.Builder cfg = new ForgeConfigSpec.Builder();
        MAX_LOCKABLE_VOLUME = cfg.comment("Maximum amount of blocks that can be locked at once").comment("\u4e00\u6b21\u6700\u591a\u53ef\u4ee5\u9501\u5b9a\u7684\u65b9\u5757\u6570\u91cf").defineInRange("Max Lockable Volume", 6, 1, Integer.MAX_VALUE);
        LOCKABLE_BLOCKS = cfg.comment("Blocks that can be locked. Each entry is the mod domain followed by the block's registry name. Can include regular expressions").comment("\u53ef\u4ee5\u9501\u5b9a\u7684\u65b9\u5757\u3002\u6bcf\u4e2a\u503c\u7531\u6a21\u7ec4\u57df\u540d\u548c\u5757\u7684\u6ce8\u518c\u540d\u79f0\u7ec4\u6210\uff0c\u53ef\u4ee5\u5305\u542b\u6b63\u5219\u8868\u8fbe\u5f0f\u3002").defineList("Lockable Blocks", (List)Lists.newArrayList((Object[])new String[]{".*chest", ".*barrel", ".*hopper", ".*door", ".*trapdoor", ".*fence_gate", ".*shulker_box"}), e -> e instanceof String);
        ALLOW_REMOVING_LOCKS = cfg.comment("Open locks can be removed with an empty hand while sneaking").comment("\u5728\u6f5c\u884c\u72b6\u6001\u4e0b\uff0c\u53ef\u4ee5\u7528\u7a7a\u624b\u79fb\u9664\u6253\u5f00\u7684\u9501\u3002").define("Allow Removing Locks", true);
        PROTECT_LOCKABLES = cfg.comment("Locked blocks cannot be destroyed in survival mode").comment("\u5728\u751f\u5b58\u6a21\u5f0f\u4e2d\uff0c\u9501\u5b9a\u7684\u5757\u65e0\u6cd5\u88ab\u7834\u574f\u3002").define("Protect Lockables", true);
        EASY_LOCK = cfg.comment("Lock blocks with just one click! It's magic! (Cancel will probably fail spectacularly with custom doors, custom double chests, etc)").comment("\u53ea\u9700\u70b9\u51fb\u4e00\u4e0b\u5373\u53ef\u9501\u5b9a\u5757\uff01\u8fd9\u592a\u795e\u5947\u4e86\uff01 \uff08\u53d6\u6d88\u53ef\u80fd\u4f1a\u4f7f\u81ea\u5b9a\u4e49\u95e8\u3001\u81ea\u5b9a\u4e49\u53cc\u7bb1\u7b49\u51fa\u73b0\u4e25\u91cd\u9519\u8bef\uff09").define("Easy Lock", true);
        STRONG_PREVENTION = cfg.comment("Use stronger checks to prevent blocks on locks from being broken, but its compatibility is unknown").comment("\u4f7f\u7528\u66f4\u5f3a\u7684\u68c0\u67e5\u6765\u9632\u6b62\u4e0a\u9501\u65b9\u5757\u88ab\u7834\u574f\uff0c\u517c\u5bb9\u6027\u672a\u77e5").define("Stronger Prevention", false);
        SPEC = cfg.build();
    }
}

