/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.container;

import java.util.function.Consumer;
import melonslise.locks.client.gui.LockPickingScreen;
import melonslise.locks.common.components.interfaces.ILockableHandler;
import melonslise.locks.common.init.LocksComponents;
import melonslise.locks.common.init.LocksContainerTypes;
import melonslise.locks.common.init.LocksDamageSources;
import melonslise.locks.common.init.LocksEnchantments;
import melonslise.locks.common.init.LocksItemTags;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockPickItem;
import melonslise.locks.common.network.toclient.TryPinResultPacket;
import melonslise.locks.common.util.Lockable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_437;

public class LockPickingContainer
extends class_1703 {
    public static final class_2561 TITLE = class_2561.method_43471((String)"locks.gui.lockpicking.title");
    public final class_1657 player;
    public final class_1268 hand;
    public final Lockable lockable;
    public final class_243 pos;
    public final int shocking;
    public final int sturdy;
    public final int complexity;
    protected int currIndex = 0;
    public static final ExtendedScreenHandlerType.ExtendedFactory<LockPickingContainer> FACTORY = (id, inv, buf) -> new LockPickingContainer(id, inv.field_7546, (class_1268)buf.method_10818(class_1268.class), (Lockable)((ILockableHandler)LocksComponents.LOCKABLE_HANDLER.get((Object)inv.field_7546.method_37908())).getLoaded().get(buf.readInt()));

    public LockPickingContainer(int id, class_1657 player, class_1268 hand, Lockable lkb) {
        super(LocksContainerTypes.LOCK_PICKING, id);
        this.player = player;
        this.hand = hand;
        this.lockable = lkb;
        Lockable.State state = lkb.getLockState(player.method_37908());
        this.pos = state == null ? lkb.bb.center() : state.pos;
        this.shocking = class_1890.method_8225((class_1887)LocksEnchantments.SHOCKING, (class_1799)this.lockable.stack);
        this.sturdy = class_1890.method_8225((class_1887)LocksEnchantments.STURDY, (class_1799)this.lockable.stack);
        this.complexity = class_1890.method_8225((class_1887)LocksEnchantments.COMPLEXITY, (class_1799)this.lockable.stack);
        for (int rows = 0; rows < 3; ++rows) {
            for (int cols = 0; cols < 9; ++cols) {
                this.method_7621(new HiddenSlot(player.method_31548(), cols + rows * 9 + 9, 0, 0));
            }
        }
        for (int slots = 0; slots < 9; ++slots) {
            this.method_7621(new HiddenSlot(player.method_31548(), slots, 0, 0));
        }
    }

    public boolean isValidPick(class_1799 stack) {
        return stack.method_31573(LocksItemTags.LOCK_PICKS) && LockPickItem.canPick(stack, this.complexity) && !this.lockable.isSmart();
    }

    public boolean method_7597(class_1657 player) {
        return this.lockable.lock.isLocked() && this.isValidPick(player.method_5998(this.hand));
    }

    public boolean isOpen() {
        return this.currIndex == this.lockable.lock.getLength();
    }

    protected void reset() {
        this.currIndex = 0;
    }

    public void tryPin(int currPin) {
        if (this.isOpen()) {
            return;
        }
        boolean correct = false;
        boolean reset = false;
        if (this.lockable.lock.checkPin(this.currIndex, currPin)) {
            ++this.currIndex;
            correct = true;
            this.player.method_37908().method_43128(null, this.pos.field_1352, this.pos.field_1351, this.pos.field_1350, LocksSoundEvents.PIN_MATCH, class_3419.field_15245, 1.0f, 1.0f);
        } else if (this.tryBreakPick(this.player, currPin)) {
            reset = true;
            this.reset();
            if (this.shocking > 0) {
                this.player.method_5643(LocksDamageSources.getDamageSource(this.player.method_37908(), LocksDamageSources.SHOCK), (float)this.shocking * 1.5f);
                this.player.method_37908().method_43128(null, this.player.method_19538().field_1352, this.player.method_19538().field_1351, this.player.method_19538().field_1350, LocksSoundEvents.SHOCK, class_3419.field_15245, 1.0f, 1.0f);
            }
        } else {
            this.player.method_37908().method_43128(null, this.pos.field_1352, this.pos.field_1351, this.pos.field_1350, LocksSoundEvents.PIN_FAIL, class_3419.field_15245, 1.0f, 1.0f);
        }
        ServerPlayNetworking.send((class_3222)((class_3222)this.player), (FabricPacket)new TryPinResultPacket(correct, reset));
    }

    @Environment(value=EnvType.CLIENT)
    public void handlePin(boolean correct, boolean reset) {
        class_437 screen = class_310.method_1551().field_1755;
        if (screen instanceof LockPickingScreen) {
            LockPickingScreen lockPickingScreen = (LockPickingScreen)screen;
            lockPickingScreen.handlePin(correct, reset);
            if (correct) {
                ++this.currIndex;
            }
            if (reset) {
                this.reset();
            }
        }
    }

    protected boolean tryBreakPick(class_1657 player, int pin) {
        class_1799 pickStack = player.method_5998(this.hand);
        float sturdyModifier = this.sturdy == 0 ? 1.0f : 0.75f + (float)this.sturdy * 0.5f;
        float ch = LockPickItem.getOrSetStrength(pickStack) / sturdyModifier;
        float ex = (1.0f - ch) * (1.0f - this.getBreakChanceMultiplier(pin));
        if (!pickStack.method_31573(LocksItemTags.LOCK_PICKS) || player.method_37908().field_9229.method_43057() < ex + ch) {
            return false;
        }
        this.player.method_20236(this.hand);
        pickStack.method_7934(1);
        if (pickStack.method_7960()) {
            for (int a = 0; a < player.method_31548().method_5439(); ++a) {
                class_1799 stack = player.method_31548().method_5438(a);
                if (!this.isValidPick(stack)) continue;
                player.method_6122(this.hand, stack);
                player.method_31548().method_5441(a);
                break;
            }
        }
        return true;
    }

    protected float getBreakChanceMultiplier(int pin) {
        return Math.abs(this.lockable.lock.getPin(this.currIndex) - pin) == 1 ? 0.33f : 1.0f;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (!this.isOpen() || !this.lockable.lock.isLocked()) {
            return;
        }
        this.lockable.lock.setLocked(!this.lockable.lock.isLocked());
        this.player.method_37908().method_43128(player, this.pos.field_1352, this.pos.field_1351, this.pos.field_1350, LocksSoundEvents.LOCK_OPEN, class_3419.field_15245, 1.0f, 1.0f);
    }

    public static class HiddenSlot
    extends class_1735 {
        public HiddenSlot(class_1661 inventoryIn, int index, int xPosition, int yPosition) {
            super((class_1263)inventoryIn, index, xPosition, yPosition);
        }

        @Environment(value=EnvType.CLIENT)
        public boolean method_7682() {
            return false;
        }
    }

    public static class Provider
    implements ExtendedScreenHandlerFactory {
        public final class_1268 hand;
        public final Lockable lockable;

        public Provider(class_1268 hand, Lockable lkb) {
            this.hand = hand;
            this.lockable = lkb;
        }

        public class_1703 createMenu(int id, class_1661 inv, class_1657 player) {
            return new LockPickingContainer(id, player, this.hand, this.lockable);
        }

        public class_2561 method_5476() {
            return TITLE;
        }

        public void writeScreenOpeningData(class_3222 serverPlayer, class_2540 friendlyByteBuf) {
            new Writer(this.hand, this.lockable).accept(friendlyByteBuf);
        }
    }

    public static class Writer
    implements Consumer<class_2540> {
        public final class_1268 hand;
        public final Lockable lockable;

        public Writer(class_1268 hand, Lockable lkb) {
            this.hand = hand;
            this.lockable = lkb;
        }

        @Override
        public void accept(class_2540 buf) {
            buf.method_10817((Enum)this.hand);
            buf.writeInt(this.lockable.id);
        }
    }
}

