/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.event;

import java.util.Arrays;
import java.util.Optional;
import melonslise.locks.Locks;
import melonslise.locks.common.components.interfaces.ILockableHandler;
import melonslise.locks.common.config.LocksClientConfig;
import melonslise.locks.common.config.LocksServerConfig;
import melonslise.locks.common.container.LockPickingContainer;
import melonslise.locks.common.init.LocksComponents;
import melonslise.locks.common.init.LocksItemTags;
import melonslise.locks.common.init.LocksItems;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.KeyRingItem;
import melonslise.locks.common.item.LockingItem;
import melonslise.locks.common.item.SmartLockItem;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksPredicates;
import melonslise.locks.common.util.LocksUtil;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableSource;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_52;
import net.minecraft.class_60;
import org.jetbrains.annotations.Nullable;

public final class LocksEvents {
    public static final class_2561 LOCKED_MESSAGE = class_2561.method_43471((String)"locks.status.locked");

    private LocksEvents() {
    }

    public static void onLootTableLoad(class_3300 resourceManager, class_60 lootManager, class_2960 id, class_52.class_53 tableBuilder, LootTableSource source) {
        if (!id.method_12836().equals("minecraft") || !id.method_12832().startsWith("chests")) {
            return;
        }
        class_2960 injectLoc = new class_2960("locks", "loot_tables/inject/" + id.method_12832() + ".json");
        if (LocksUtil.resourceManager.method_14486(injectLoc).isEmpty()) {
            return;
        }
    }

    public static class_1269 onRightClick(class_1657 player, class_1937 world, class_1268 hand, class_3965 result) {
        class_2338 pos = result.method_17777();
        ILockableHandler handler = (ILockableHandler)LocksComponents.LOCKABLE_HANDLER.get((Object)world);
        Lockable[] intersect = (Lockable[])handler.getInChunk(pos).values().stream().filter(lkb -> lkb.bb.intersects(pos)).toArray(Lockable[]::new);
        if (intersect.length == 0) {
            return class_1269.field_5811;
        }
        if (hand != class_1268.field_5808) {
            return class_1269.field_5814;
        }
        class_1799 stack = player.method_5998(hand);
        Optional<Lockable> locked = Arrays.stream(intersect).filter(LocksPredicates.LOCKED).findFirst();
        if (locked.isPresent()) {
            Lockable lkb2 = locked.get();
            class_1792 item = stack.method_7909();
            if (lkb2.isSmart()) {
                SmartLockItem.getOrSetOwner(stack, player).equals(player.method_5667());
            }
            if (!LocksEvents.canUnlock(lkb2, stack, player)) {
                lkb2.swing(20);
                world.method_8396(player, pos, LocksSoundEvents.LOCK_RATTLE, class_3419.field_15245, 1.0f, 1.0f);
            }
            player.method_6104(class_1268.field_5808);
            if (!player.method_5715() && LocksEvents.hasMatchingKey(lkb2, stack, player)) {
                lkb2.lock.setLocked(!lkb2.lock.isLocked());
                world.method_8396(player, pos, LocksSoundEvents.LOCK_OPEN, class_3419.field_15245, 1.0f, 1.0f);
                if (!world.field_9236) {
                    ((class_3218)world).method_8503().execute(() -> {
                        LocksComponents.LOCKABLE_HANDLER.sync((Object)world);
                        world.method_22350(pos).method_12008(true);
                    });
                }
            }
            if (!(player instanceof class_3222)) {
                return class_1269.field_5811;
            }
            if (world.field_9236 && ((Boolean)LocksClientConfig.DEAF_MODE.get()).booleanValue()) {
                player.method_7353(LOCKED_MESSAGE, true);
            }
            if (!lkb2.isSmart() && player.method_5715() && LocksEvents.hasMatchingKey(lkb2, stack, player)) {
                return class_1269.field_5811;
            }
            if (LocksEvents.canUnlock(lkb2, stack, player) && !LocksEvents.hasMatchingKey(lkb2, stack, player)) {
                player.method_17355((class_3908)new LockPickingContainer.Provider(hand, lkb2));
                return class_1269.field_21466;
            }
            return class_1269.field_5814;
        }
        if (((Boolean)LocksServerConfig.ALLOW_REMOVING_LOCKS.get()).booleanValue() && player.method_5715() && stack.method_7960()) {
            Lockable[] match = (Lockable[])Arrays.stream(intersect).filter(LocksPredicates.NOT_LOCKED).toArray(Lockable[]::new);
            if (match.length == 0) {
                return class_1269.field_5811;
            }
            world.method_8396(player, pos, class_3417.field_14567, class_3419.field_15245, 0.8f, 0.8f + world.field_9229.method_43057() * 0.4f);
            player.method_6104(class_1268.field_5808);
            if (player instanceof class_3222) {
                Locks.LOGGER.info("Removing lockable");
                for (Lockable lkb3 : match) {
                    world.method_8649((class_1297)new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, lkb3.stack));
                    handler.remove(lkb3.id);
                }
                return class_1269.field_21466;
            }
            return class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    public static boolean canUnlock(Lockable lkb, class_1799 stack, class_1657 player) {
        if (LocksEvents.hasMatchingKey(lkb, stack, player)) {
            return true;
        }
        return stack.method_31573(LocksItemTags.LOCK_PICKS) && !lkb.isSmart();
    }

    public static boolean hasMatchingKey(Lockable lkb, class_1799 stack, class_1657 player) {
        int lockId = lkb.lock.id;
        class_1792 item = stack.method_7909();
        if (stack.method_31573(LocksItemTags.KEYS) && LockingItem.getOrSetId(stack) == lockId) {
            return true;
        }
        if (item == LocksItems.MASTER_KEY) {
            return true;
        }
        if (item == LocksItems.KEY_RING && KeyRingItem.containsId(stack, lockId)) {
            return true;
        }
        return !stack.method_31573(LocksItemTags.LOCK_PICKS) && lkb.isSmart() && SmartLockItem.getOrSetOwner(lkb.stack, player).equals(player.method_5667());
    }

    public static boolean canBreakLockable(class_1937 world, class_1657 player, class_2338 pos) {
        return (Boolean)LocksServerConfig.PROTECT_LOCKABLES.get() != false && !player.method_7337() && LocksUtil.lockedAndRelated(world, pos);
    }

    public static boolean onBlockBreaking(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 entity) {
        return !LocksEvents.canBreakLockable(world, player, pos);
    }

    public static void onBlockBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 entity) {
    }

    public static void register() {
        LootTableEvents.MODIFY.register(LocksEvents::onLootTableLoad);
        PlayerBlockBreakEvents.BEFORE.register(LocksEvents::onBlockBreaking);
        PlayerBlockBreakEvents.AFTER.register(LocksEvents::onBlockBreak);
        UseBlockCallback.EVENT.register(LocksEvents::onRightClick);
    }
}

