/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item;

import java.util.List;
import java.util.UUID;
import melonslise.locks.Locks;
import melonslise.locks.common.components.interfaces.ILockableHandler;
import melonslise.locks.common.components.interfaces.ISelection;
import melonslise.locks.common.config.LocksServerConfig;
import melonslise.locks.common.init.LocksComponents;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockingItem;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3419;

public class SmartLockItem
extends LockingItem {
    public final int enchantmentValue;
    public static final String KEY_OPEN = "Open";
    public static final String OWNER = "OwnerUUID";
    public static final String OWNER_NAME = "OwnerName";
    private static boolean prevState = false;

    public SmartLockItem(int enchVal, class_1792.class_1793 props) {
        super(props);
        this.enchantmentValue = enchVal;
    }

    public static boolean isOpen(class_1799 stack) {
        return stack.method_7948().method_10577(KEY_OPEN);
    }

    public static void setOpen(class_1799 stack, boolean open) {
        stack.method_7948().method_10556(KEY_OPEN, open);
    }

    public class_1269 method_7884(class_1838 ctx) {
        class_2338 pos;
        class_1937 world = ctx.method_8045();
        if (!LocksServerConfig.canLock(world, pos = ctx.method_8037()) || ((ILockableHandler)LocksComponents.LOCKABLE_HANDLER.get((Object)ctx.method_8045())).getInChunk(pos).values().stream().anyMatch(lkb -> lkb.bb.intersects(pos))) {
            return class_1269.field_5811;
        }
        return (Boolean)LocksServerConfig.EASY_LOCK.get() != false ? this.easyLock(ctx) : this.freeLock(ctx);
    }

    public static UUID getOrSetOwner(class_1799 stack, class_1657 player) {
        class_2487 tag = stack.method_7948();
        if (!tag.method_10573(OWNER, 11) || !tag.method_10573(OWNER_NAME, 8)) {
            SmartLockItem.setOwner(stack, player);
        }
        return tag.method_25926(OWNER);
    }

    public static void setOwner(class_1799 stack, class_1657 player) {
        class_2487 tag = stack.method_7948();
        Locks.LOGGER.warn((Object)tag.method_25928(OWNER));
        if (!tag.method_25928(OWNER)) {
            tag.method_25927(OWNER, player.method_5667());
        }
        if (!tag.method_10573(OWNER_NAME, 8)) {
            tag.method_10582(OWNER_NAME, player.method_5477().getString());
        }
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (!world.field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            SmartLockItem.getOrSetOwner(stack, player);
        }
    }

    public class_1269 freeLock(class_1838 ctx) {
        class_1657 player = ctx.method_8036();
        class_2338 pos = ctx.method_8037();
        if (player == null) {
            return class_1269.field_5811;
        }
        ISelection select = (ISelection)LocksComponents.SELECTION.get((Object)player);
        class_2338 pos1 = select.get();
        if (pos1 == null) {
            select.set(pos);
        } else {
            class_1937 world = ctx.method_8045();
            select.set(null);
            world.method_8396(player, pos, LocksSoundEvents.LOCK_CLOSE, class_3419.field_15245, 1.0f, 1.0f);
            if (world.field_9236) {
                return class_1269.field_5812;
            }
            class_1799 stack = ctx.method_8041();
            class_1799 lockStack = stack.method_7972();
            lockStack.method_7939(1);
            ILockableHandler handler = (ILockableHandler)LocksComponents.LOCKABLE_HANDLER.get((Object)world);
            if (!handler.add(new Lockable(new Cuboid6i(pos1, pos), Lock.from(stack), Transform.fromDirection(ctx.method_8038(), player.method_5735().method_10153()), lockStack, world), world)) {
                return class_1269.field_5811;
            }
            if (!player.method_7337()) {
                stack.method_7934(1);
            }
        }
        return class_1269.field_5812;
    }

    public class_1269 easyLock(class_1838 ctx) {
        class_1657 player = ctx.method_8036();
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        world.method_8396(player, pos, LocksSoundEvents.LOCK_CLOSE, class_3419.field_15245, 1.0f, 1.0f);
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2680 state = world.method_8320(pos);
        class_2338 pos1 = pos;
        if (state.method_28498((class_2769)class_2741.field_12506) && state.method_11654((class_2769)class_2741.field_12506) != class_2745.field_12569) {
            pos1 = pos.method_10093(class_2281.method_9758((class_2680)state));
        } else if (state.method_28498((class_2769)class_2741.field_12533)) {
            class_2338 class_23382 = pos1 = state.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12607 ? pos.method_10084() : pos.method_10074();
            if (state.method_28498((class_2769)class_2741.field_12520) && state.method_28498((class_2769)class_2741.field_12481)) {
                class_2350 dir = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
                class_2338 pos2 = pos1.method_10093(state.method_11654((class_2769)class_2741.field_12520) == class_2750.field_12588 ? dir.method_10170() : dir.method_10160());
                if (world.method_8320(pos2).method_27852(state.method_26204())) {
                    pos1 = pos2;
                }
            }
        }
        class_1799 stack = ctx.method_8041();
        class_1799 lockStack = stack.method_7972();
        lockStack.method_7939(1);
        ILockableHandler handler = (ILockableHandler)LocksComponents.LOCKABLE_HANDLER.get((Object)world);
        Lockable lockable = new Lockable(new Cuboid6i(pos, pos1), Lock.from(stack), Transform.fromDirection(ctx.method_8038(), player.method_5735().method_10153()), lockStack, world);
        if (!handler.add(lockable, world)) {
            return class_1269.field_5811;
        }
        if (!player.method_7337()) {
            stack.method_7934(1);
        }
        return class_1269.field_5812;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!SmartLockItem.isOpen(stack)) {
            return super.method_7836(world, player, hand);
        }
        SmartLockItem.setOpen(stack, false);
        world.method_43128(player, player.method_23317(), player.method_23318(), player.method_23321(), LocksSoundEvents.PIN_MATCH, class_3419.field_15248, 1.0f, 1.0f);
        return super.method_7836(world, player, hand);
    }

    public boolean method_7870(class_1799 p_77616_1_) {
        return true;
    }

    public int method_7837() {
        return this.enchantmentValue;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> lines, class_1836 flag) {
        super.method_7851(stack, world, lines, flag);
        String ownerName = "Unknown";
        if (stack.method_7985() && stack.method_7969().method_10573(OWNER_NAME, 8)) {
            ownerName = stack.method_7969().method_10558(OWNER_NAME);
            lines.add((class_2561)class_2561.method_43469((String)"locks.tooltip.owner", (Object[])new Object[]{ownerName}).method_27692(class_124.field_1077));
        }
    }
}

