/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import melonslise.locks.common.util.BiIntFunction;
import melonslise.locks.common.util.BiIntPredicate;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public class Cuboid6i {
    public final int x1;
    public final int y1;
    public final int z1;
    public final int x2;
    public final int y2;
    public final int z2;
    public static final String KEY_X1 = "X1";
    public static final String KEY_Y1 = "Y1";
    public static final String KEY_Z1 = "Z1";
    public static final String KEY_X2 = "X2";
    public static final String KEY_Y2 = "Y2";
    public static final String KEY_Z2 = "Z2";

    public Cuboid6i(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.x1 = Math.min(x1, x2);
        this.y1 = Math.min(y1, y2);
        this.z1 = Math.min(z1, z2);
        this.x2 = Math.max(x1, x2);
        this.y2 = Math.max(y1, y2);
        this.z2 = Math.max(z1, z2);
    }

    public Cuboid6i(class_2338 pos1, class_2338 pos2) {
        this.x1 = Math.min(pos1.method_10263(), pos2.method_10263());
        this.y1 = Math.min(pos1.method_10264(), pos2.method_10264());
        this.z1 = Math.min(pos1.method_10260(), pos2.method_10260());
        this.x2 = Math.max(pos1.method_10263(), pos2.method_10263()) + 1;
        this.y2 = Math.max(pos1.method_10264(), pos2.method_10264()) + 1;
        this.z2 = Math.max(pos1.method_10260(), pos2.method_10260()) + 1;
    }

    public static Cuboid6i fromNbt(class_2487 nbt) {
        return new Cuboid6i(nbt.method_10550(KEY_X1), nbt.method_10550(KEY_Y1), nbt.method_10550(KEY_Z1), nbt.method_10550(KEY_X2), nbt.method_10550(KEY_Y2), nbt.method_10550(KEY_Z2));
    }

    public static class_2487 toNbt(Cuboid6i bb) {
        class_2487 nbt = new class_2487();
        nbt.method_10569(KEY_X1, bb.x1);
        nbt.method_10569(KEY_Y1, bb.y1);
        nbt.method_10569(KEY_Z1, bb.z1);
        nbt.method_10569(KEY_X2, bb.x2);
        nbt.method_10569(KEY_Y2, bb.y2);
        nbt.method_10569(KEY_Z2, bb.z2);
        return nbt;
    }

    public static Cuboid6i fromBuf(class_2540 buf) {
        return new Cuboid6i(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void toBuf(class_2540 buf, Cuboid6i bb) {
        buf.writeInt(bb.x1);
        buf.writeInt(bb.y1);
        buf.writeInt(bb.z1);
        buf.writeInt(bb.x2);
        buf.writeInt(bb.y2);
        buf.writeInt(bb.z2);
    }

    public Cuboid6i offset(int x, int y, int z) {
        return new Cuboid6i(this.x1 + x, this.y1 + y, this.z1 + z, this.x2 + x, this.y2 + y, this.z2 + z);
    }

    public Cuboid6i intersection(Cuboid6i other) {
        return new Cuboid6i(Math.max(this.x1, other.x1), Math.max(this.y1, other.y1), Math.max(this.z1, other.z1), Math.min(this.x2, other.x2), Math.min(this.y2, other.y2), Math.min(this.z2, other.z2));
    }

    public int length() {
        return this.x2 - this.x1;
    }

    public int height() {
        return this.y2 - this.y1;
    }

    public int width() {
        return this.z2 - this.z1;
    }

    public int volume() {
        return this.length() * this.height() * this.width();
    }

    public class_243 center() {
        return new class_243((double)(this.x1 + this.x2) * 0.5, (double)(this.y1 + this.y2) * 0.5, (double)(this.z1 + this.z2) * 0.5);
    }

    public boolean intersects(int x1, int y1, int z1, int x2, int y2, int z2) {
        return this.x1 < x2 && this.x2 > x1 && this.y1 < y2 && this.y2 > y1 && this.z1 < z2 && this.z2 > z1;
    }

    public boolean intersects(Cuboid6i other) {
        return this.intersects(other.x1, other.y1, other.z1, other.x2, other.y2, other.z2);
    }

    public boolean intersects(class_2338 pos) {
        return this.intersects(pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1);
    }

    public Iterable<class_2338> getContainedPos() {
        return class_2338.method_10094((int)this.x1, (int)this.y1, (int)this.z1, (int)(this.x2 - 1), (int)(this.y2 - 1), (int)(this.z2 - 1));
    }

    public boolean getContainedChunks(BiIntPredicate p) {
        int x1 = this.x1 >> 4;
        int x2 = this.x2 >> 4;
        int z1 = this.z1 >> 4;
        int z2 = this.z2 >> 4;
        if (this.x2 % 16 == 0) {
            --x2;
        }
        if (this.z2 % 16 == 0) {
            --z2;
        }
        int sizeX = x2 - x1 + 1;
        int length = sizeX * (z2 - z1 + 1);
        for (int a = 0; a < length; ++a) {
            if (!p.test(x1 + a / sizeX, z1 + a % sizeX)) continue;
            return false;
        }
        return true;
    }

    public <T> List<T> containedChunksTo(BiIntFunction<T> f, boolean endEarly) {
        int x1 = this.x1 >> 4;
        int x2 = this.x2 >> 4;
        int z1 = this.z1 >> 4;
        int z2 = this.z2 >> 4;
        if (this.x2 % 16 == 0) {
            --x2;
        }
        if (this.z2 % 16 == 0) {
            --z2;
        }
        int sizeX = x2 - x1 + 1;
        int length = sizeX * (z2 - z1 + 1);
        ArrayList<T> list = new ArrayList<T>(length);
        for (int a = 0; a < length; ++a) {
            T t = f.apply(x1 + a % sizeX, z1 + a / sizeX);
            if (endEarly && t == null) {
                return null;
            }
            list.add(a, t);
        }
        return list;
    }

    public class_243 sideCenter(class_2350 side) {
        class_2382 dir = side.method_10163();
        return new class_243((double)(this.x1 + this.x2 + this.length() * dir.method_10263()) * 0.5, (double)(this.y1 + this.y2 + this.height() * dir.method_10264()) * 0.5, (double)(this.z1 + this.z2 + this.width() * dir.method_10260()) * 0.5);
    }

    public boolean isLoaded(class_1937 world) {
        return world.method_22341(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Cuboid6i)) {
            return false;
        }
        Cuboid6i box = (Cuboid6i)object;
        return this.x1 == box.x1 && this.x2 == box.x2 && this.y1 == box.y1 && this.y2 == box.y2 && this.z1 == box.z1 && this.z2 == box.z2;
    }

    public int hashCode() {
        return Objects.hash(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    public String toString() {
        return "Box{" + this.x1 + ", " + this.y1 + ", " + this.z1 + ", " + this.x2 + ", " + this.y2 + ", " + this.z2 + "}";
    }
}

