/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.util;

import java.util.Observable;
import java.util.Random;
import melonslise.locks.common.item.LockItem;
import melonslise.locks.common.item.LockingItem;
import melonslise.locks.common.item.SmartLockItem;
import melonslise.locks.common.util.LocksUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public class Lock
extends Observable {
    public final int id;
    protected final byte[] combo;
    protected boolean locked;
    public final Random rng;
    public static final String KEY_ID = "Id";
    public static final String KEY_LENGTH = "Length";
    public static final String KEY_LOCKED = "Locked";

    public Lock(int id, int length, boolean locked) {
        this.id = id;
        this.rng = new Random(id);
        this.combo = this.shuffle(length);
        this.locked = locked;
    }

    public static Lock from(class_1799 stack) {
        if (LockingItem.isSmart(stack)) {
            return new Lock(LockingItem.getOrSetId(stack), 64, !SmartLockItem.isOpen(stack));
        }
        return new Lock(LockingItem.getOrSetId(stack), LockItem.getOrSetLength(stack), !LockItem.isOpen(stack));
    }

    public static Lock fromNbt(class_2487 nbt) {
        return new Lock(nbt.method_10550(KEY_ID), nbt.method_10571(KEY_LENGTH), nbt.method_10577(KEY_LOCKED));
    }

    public static class_2487 toNbt(Lock lock) {
        class_2487 nbt = new class_2487();
        nbt.method_10569(KEY_ID, lock.id);
        nbt.method_10567(KEY_LENGTH, (byte)lock.combo.length);
        nbt.method_10556(KEY_LOCKED, lock.locked);
        return nbt;
    }

    public static Lock fromBuf(class_2540 buf) {
        return new Lock(buf.readInt(), buf.readByte(), buf.readBoolean());
    }

    public static void toBuf(class_2540 buf, Lock lock) {
        buf.writeInt(lock.id);
        buf.writeByte(lock.getLength());
        buf.writeBoolean(lock.isLocked());
    }

    public byte[] shuffle(int length) {
        byte[] combo = new byte[length];
        for (int a = 0; a < length; a = (int)((byte)(a + 1))) {
            combo[a] = a;
        }
        LocksUtil.shuffle(combo, this.rng);
        return combo;
    }

    public int getLength() {
        return this.combo.length;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        if (this.locked == locked) {
            return;
        }
        this.locked = locked;
        this.setChanged();
        this.notifyObservers();
    }

    public int getPin(int index) {
        return this.combo[index];
    }

    public boolean checkPin(int index, int pin) {
        return this.getPin(index) == pin;
    }
}

