/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import melonslise.locks.Locks;
import melonslise.locks.common.components.interfaces.ILockableHandler;
import melonslise.locks.common.init.LocksComponents;
import melonslise.locks.common.item.LockItem;
import melonslise.locks.common.item.SmartLockItem;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.LocksUtil;
import melonslise.locks.common.util.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_310;
import net.minecraft.class_4604;

public class Lockable
extends Observable
implements Observer {
    public final Cuboid6i bb;
    public final Lock lock;
    public Transform tr = Transform.NORTH_UP;
    public final class_1799 stack;
    public final int id;
    public int oldSwingTicks;
    public int swingTicks;
    public int maxSwingTicks;
    public Map<List<class_2680>, State> cache = new HashMap<List<class_2680>, State>(6);
    public static final String KEY_BB = "Bb";
    public static final String KEY_LOCK = "Lock";
    public static final String KEY_TRANSFORM = "Transform";
    public static final String KEY_STACK = "Stack";
    public static final String KEY_ID = "Id";

    public Lockable(Cuboid6i bb, Lock lock, Transform tr, class_1799 stack, class_1937 world) {
        this(bb, lock, tr, stack, ((ILockableHandler)LocksComponents.LOCKABLE_HANDLER.get((Object)world)).nextId());
    }

    public Lockable(Cuboid6i bb, Lock lock, Transform tr, class_1799 stack, int id) {
        this.bb = bb;
        this.lock = lock;
        this.tr = tr;
        this.stack = stack;
        this.id = id;
        Lockable.checkIntegrity(this);
        lock.addObserver(this);
    }

    public static Lockable fromNbt(class_2487 nbt) {
        return new Lockable(Cuboid6i.fromNbt(nbt.method_10562(KEY_BB)), Lock.fromNbt(nbt.method_10562(KEY_LOCK)), Transform.values()[nbt.method_10571(KEY_TRANSFORM)], class_1799.method_7915((class_2487)nbt.method_10562(KEY_STACK)), nbt.method_10550(KEY_ID));
    }

    public static class_2487 toNbt(Lockable lkb) {
        class_2487 nbt = new class_2487();
        nbt.method_10566(KEY_BB, (class_2520)Cuboid6i.toNbt(lkb.bb));
        nbt.method_10566(KEY_LOCK, (class_2520)Lock.toNbt(lkb.lock));
        if (lkb.tr == null) {
            Locks.LOGGER.warn("Transform is null for Lockable?");
            lkb.tr = Transform.NORTH_UP;
        }
        nbt.method_10567(KEY_TRANSFORM, (byte)(lkb.tr != null ? lkb.tr.ordinal() : Transform.NORTH_MID.ordinal()));
        nbt.method_10566(KEY_STACK, (class_2520)lkb.stack.method_7953(new class_2487()));
        nbt.method_10569(KEY_ID, lkb.id);
        return nbt;
    }

    public boolean isSmart() {
        return this.stack.method_7909() instanceof SmartLockItem;
    }

    public static void nullTransfer(Lockable lkb) {
    }

    public static int idFromNbt(class_2487 nbt) {
        return nbt.method_10550(KEY_ID);
    }

    public static Lockable fromBuf(class_2540 buf) {
        return new Lockable(Cuboid6i.fromBuf(buf), Lock.fromBuf(buf), (Transform)buf.method_10818(Transform.class), buf.method_10819(), buf.readInt());
    }

    public static void toBuf(class_2540 buf, Lockable lkb) {
        lkb = Lockable.checkIntegrity(lkb);
        Cuboid6i.toBuf(buf, lkb.bb);
        Lock.toBuf(buf, lkb.lock);
        buf.method_10817((Enum)(lkb.tr != null ? lkb.tr : Transform.NORTH_MID));
        buf.method_10793(lkb.stack);
        buf.writeInt(lkb.id);
    }

    private static Lockable checkIntegrity(Lockable lkb) {
        if (lkb.tr == null) {
            Locks.LOGGER.warn("Transform was null for Lockable");
            lkb.tr = Transform.NORTH_UP;
        }
        return lkb;
    }

    @Override
    public void update(Observable lock, Object data) {
        this.setChanged();
        this.notifyObservers();
        LockItem.setOpen(this.stack, !this.lock.locked);
    }

    public void tick() {
        this.oldSwingTicks = this.swingTicks;
        if (this.swingTicks > 0) {
            --this.swingTicks;
        }
    }

    public void swing(int ticks) {
        this.oldSwingTicks = this.maxSwingTicks = ticks;
        this.swingTicks = this.maxSwingTicks;
    }

    public State getLockState(class_1937 world) {
        class_243 center;
        ArrayList<class_2680> states = new ArrayList<class_2680>(this.bb.volume());
        for (class_2338 pos : this.bb.getContainedPos()) {
            if (!world.method_22340(pos)) {
                return null;
            }
            states.add(world.method_8320(pos));
        }
        State state = this.cache.get(states);
        if (state != null) {
            return state;
        }
        ArrayList<class_238> boxes = new ArrayList<class_238>(4);
        for (class_2338 pos : this.bb.getContainedPos()) {
            class_265 shape = world.method_8320(pos).method_26218((class_1922)world, pos);
            if (shape.method_1110()) continue;
            class_238 bb = shape.method_1107();
            class_238 union = bb = bb.method_996(pos);
            Iterator it = boxes.iterator();
            while (it.hasNext()) {
                class_238 bb1 = (class_238)it.next();
                if (!LocksUtil.intersectsInclusive(union, bb1)) continue;
                union = union.method_991(bb1);
                it.remove();
            }
            boxes.add(union);
        }
        if (boxes.isEmpty()) {
            return null;
        }
        class_2350 side = this.tr.getCuboidFace();
        class_243 point = center = this.bb.sideCenter(side);
        double min = -1.0;
        for (class_238 box : boxes) {
            for (class_2350 side1 : class_2350.values()) {
                class_243 point1 = LocksUtil.sideCenter(box, side1).method_1019(class_243.method_24954((class_2382)side1.method_10163()).method_1021(0.05));
                double dist = center.method_1025(point1);
                if (min != -1.0 && dist >= min) continue;
                point = point1;
                min = dist;
                side = side1;
            }
        }
        state = new State(point, Transform.fromDirection(side, this.tr.dir));
        this.cache.put(states, state);
        return state;
    }

    public static class State {
        public static final class_238 VERT_Z_BB = new class_238(-0.125, -0.1875, 0.125, 0.125, 0.1875, 0.125);
        public static final class_238 VERT_X_BB = LocksUtil.rotateY(VERT_Z_BB);
        public static final class_238 HOR_Z_BB = LocksUtil.rotateX(VERT_Z_BB);
        public static final class_238 HOR_X_BB = LocksUtil.rotateY(HOR_Z_BB);
        public final class_243 pos;
        public final Transform tr;
        public final class_238 bb;

        public static class_238 getBounds(Transform tr) {
            return tr.face == class_2738.field_12471 ? (tr.dir.method_10166() == class_2350.class_2351.field_11051 ? VERT_Z_BB : VERT_X_BB) : (tr.dir.method_10166() == class_2350.class_2351.field_11051 ? HOR_Z_BB : HOR_X_BB);
        }

        public State(class_243 pos, Transform tr) {
            this(pos, tr, State.getBounds(tr).method_997(pos));
        }

        public State(class_243 pos, Transform tr, class_238 bb) {
            this.pos = pos;
            this.tr = tr;
            this.bb = bb;
        }

        @Environment(value=EnvType.CLIENT)
        public boolean inView(class_4604 ch) {
            class_238 aabb = new class_238(this.bb.field_1323, this.bb.field_1322, this.bb.field_1321, this.bb.field_1320, this.bb.field_1325, this.bb.field_1324);
            return ch.method_23093(aabb);
        }

        @Environment(value=EnvType.CLIENT)
        public boolean inRange(class_243 pos) {
            double max;
            class_310 mc = class_310.method_1551();
            double dist = this.pos.method_1025(pos);
            return dist < (max = (double)((Integer)mc.field_1690.method_42503().method_41753() * 8)) * max;
        }
    }
}

