/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.util;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import melonslise.locks.common.components.interfaces.ILockableHandler;
import melonslise.locks.common.config.LocksConfig;
import melonslise.locks.common.init.LocksComponents;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.ILockableProvider;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksPredicates;
import melonslise.locks.common.util.Transform;
import melonslise.locks.mixin.accessor.LootPoolAccessor;
import melonslise.locks.mixin.accessor.LootTableAccessor;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3492;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_5819;

public final class LocksUtil {
    public static class_3300 resourceManager;

    private LocksUtil() {
    }

    public static void shuffle(byte[] array, Random rng) {
        for (int a = array.length - 1; a > 0; --a) {
            int index = rng.nextInt(a + 1);
            byte temp = array[index];
            array[index] = array[a];
            array[a] = temp;
        }
    }

    public static boolean chance(class_5819 rng, double ch) {
        return ch == 1.0 || ch != 0.0 && rng.method_43058() <= ch;
    }

    public static class_2338 transform(int x, int y, int z, class_3492 settings) {
        switch (settings.method_15114()) {
            case field_11300: {
                z = -z + 1;
                break;
            }
            case field_11301: {
                x = -x + 1;
                break;
            }
        }
        int x1 = settings.method_15134().method_10263();
        int z1 = settings.method_15134().method_10260();
        switch (settings.method_15113()) {
            case field_11465: {
                return new class_2338(x1 - z1 + z, y, x1 + z1 - x + 1);
            }
            case field_11463: {
                return new class_2338(x1 + z1 - z + 1, y, z1 - x1 + x);
            }
            case field_11464: {
                return new class_2338(x1 + x1 - x + 1, y, z1 + z1 - z + 1);
            }
        }
        return new class_2338(x, y, z);
    }

    public static class_2738 faceFromDir(class_2350 dir) {
        return dir == class_2350.field_11036 ? class_2738.field_12473 : (dir == class_2350.field_11033 ? class_2738.field_12475 : class_2738.field_12471);
    }

    public static class_238 rotateY(class_238 bb) {
        return new class_238(bb.field_1321, bb.field_1322, bb.field_1323, bb.field_1324, bb.field_1325, bb.field_1320);
    }

    public static class_238 rotateX(class_238 bb) {
        return new class_238(bb.field_1323, bb.field_1321, bb.field_1322, bb.field_1320, bb.field_1324, bb.field_1325);
    }

    public static boolean intersectsInclusive(class_238 bb1, class_238 bb2) {
        return bb1.field_1323 <= bb2.field_1320 && bb1.field_1320 >= bb2.field_1323 && bb1.field_1322 <= bb2.field_1325 && bb1.field_1325 >= bb2.field_1322 && bb1.field_1321 <= bb2.field_1324 && bb1.field_1324 >= bb2.field_1321;
    }

    public static class_243 sideCenter(class_238 bb, class_2350 side) {
        class_2382 dir = side.method_10163();
        return new class_243((bb.field_1323 + bb.field_1320 + (bb.field_1320 - bb.field_1323) * (double)dir.method_10263()) * 0.5, (bb.field_1322 + bb.field_1325 + (bb.field_1325 - bb.field_1322) * (double)dir.method_10264()) * 0.5, (bb.field_1321 + bb.field_1324 + (bb.field_1324 - bb.field_1321) * (double)dir.method_10260()) * 0.5);
    }

    public static class_52 mergeEntries(class_52 table, class_52 inject) {
        List<class_55> list = Arrays.asList(((LootTableAccessor)table).getPools());
        for (class_55 injectPool : ((LootTableAccessor)inject).getPools()) {
            if (list.contains(injectPool)) {
                ((LootPoolAccessor)injectPool).getEntries().addAll(((LootPoolAccessor)injectPool).getEntries());
                continue;
            }
            list.add(injectPool);
        }
        ((LootTableAccessor)inject).setPools(list.toArray(new class_55[0]));
        return table;
    }

    public static Stream<Lockable> intersecting(class_1937 world, class_2338 pos) {
        return ((ILockableHandler)LocksComponents.LOCKABLE_HANDLER.get((Object)world)).getInChunk(pos).values().stream().filter(lkb -> lkb.bb.intersects(pos));
    }

    public static boolean lockedAndRelated(class_1937 world, class_2338 pos) {
        class_2338 above = pos.method_10084();
        class_2248 aboveBlock = world.method_8320(above).method_26204();
        boolean checkAbove = LocksUtil.locked(world, above) && aboveBlock instanceof class_2323;
        return LocksUtil.locked(world, pos) || checkAbove;
    }

    public static boolean locked(class_1937 world, class_2338 pos) {
        return LocksUtil.intersecting(world, pos).anyMatch(LocksPredicates.LOCKED);
    }

    public static Lockable lockWhenGen(class_1936 levelAccessor, class_3218 level, class_2338 blockPos, class_5819 randomSource) {
        class_2680 state = levelAccessor.method_8320(blockPos);
        class_2248 block = state.method_26204();
        if (!LocksConfig.canGen(randomSource, block)) {
            return null;
        }
        class_2338 pos1 = blockPos;
        class_2350 dir = null;
        if (state.method_28498((class_2769)class_2741.field_12525)) {
            dir = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
        } else if (state.method_28498((class_2769)class_2741.field_12481)) {
            dir = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        } else {
            return null;
        }
        if (state.method_28498((class_2769)class_2741.field_12506)) {
            switch ((class_2745)state.method_11654((class_2769)class_2741.field_12506)) {
                case field_12574: {
                    pos1 = blockPos.method_10093(class_2281.method_9758((class_2680)state));
                    break;
                }
                case field_12571: {
                    return null;
                }
            }
        }
        if (state.method_28498((class_2769)class_2741.field_12533)) {
            if (state.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12607) {
                return null;
            }
            pos1 = blockPos.method_10074();
            if (state.method_28498((class_2769)class_2741.field_12520)) {
                class_2338 pos2;
                if (state.method_28498((class_2769)class_2741.field_12520) && state.method_28498((class_2769)class_2741.field_12481) && levelAccessor.method_8320(pos2 = pos1.method_10093(state.method_11654((class_2769)class_2741.field_12520) == class_2750.field_12588 ? dir.method_10170() : dir.method_10160())).method_27852(state.method_26204())) {
                    if (state.method_11654((class_2769)class_2741.field_12520) == class_2750.field_12588) {
                        return null;
                    }
                    pos1 = pos2;
                }
                dir = dir.method_10153();
            }
        }
        Cuboid6i bb = new Cuboid6i(blockPos, pos1);
        class_1799 stack = LocksConfig.getRandomLock(randomSource);
        Lock lock = Lock.from(stack);
        Transform tr = Transform.fromDirection(dir, dir);
        return new Lockable(bb, lock, tr, stack, (class_1937)level);
    }

    public static Lockable lockCheck(class_1936 levelAccessor, class_3218 level, class_2338 blockPos, class_5819 randomSource) {
        if (levelAccessor.method_8393(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4)) {
            return LocksUtil.lockWhenGen(levelAccessor, level, blockPos, randomSource);
        }
        return null;
    }

    public static boolean lockChunk(class_1936 levelAccessor, class_3218 level, class_2338 blockPos, class_5819 randomSource, class_2791 chunkAccess) {
        Lockable lkb = LocksUtil.lockCheck(levelAccessor, level, blockPos, randomSource);
        if (lkb == null) {
            return false;
        }
        ((ILockableProvider)chunkAccess).getLockables().add(lkb);
        return true;
    }

    public static boolean lockChunk(class_1936 levelAccessor, class_3218 level, class_2338 blockPos, class_5819 randomSource) {
        Lockable lkb = LocksUtil.lockCheck(levelAccessor, level, blockPos, randomSource);
        if (lkb == null) {
            return false;
        }
        lkb.bb.getContainedChunks((x, z) -> {
            ((ILockableProvider)levelAccessor.method_8392(x, z)).getLockables().add(lkb);
            return true;
        });
        return true;
    }
}

