/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.mixin.addlock;

import java.util.ArrayList;
import java.util.List;
import melonslise.locks.Locks;
import melonslise.locks.common.components.interfaces.ILockableHandler;
import melonslise.locks.common.config.LocksConfig;
import melonslise.locks.common.init.LocksComponents;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LockableInfo;
import melonslise.locks.common.util.LocksUtil;
import melonslise.locks.common.util.Transform;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7871;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3499.class})
public class StructureTemplateMixin {
    private final List<LockableInfo> lockableInfos = new ArrayList<LockableInfo>();
    @Unique
    private static final String KEY_LOCKABLES = "Lockables";

    @Inject(at={@At(value="HEAD")}, method={"fillFromWorld"})
    private void fillFromWorld(class_1937 world, class_2338 start, class_2382 size, boolean takeEntities, @Nullable class_2248 toIgnore, CallbackInfo ci) {
        if (size.method_10263() >= 1 && size.method_10264() >= 1 && size.method_10260() >= 1) {
            this.lockableInfos.clear();
            ILockableHandler handler = (ILockableHandler)LocksComponents.LOCKABLE_HANDLER.get((Object)world);
            Cuboid6i bb = new Cuboid6i(start, start.method_10069(size.method_10263() - 1, size.method_10264() - 1, size.method_10260() - 1));
            handler.getLoaded().values().stream().filter(lkb -> lkb.bb.intersects(bb)).forEach(lkb -> {
                Cuboid6i newBB = bb.intersection(lkb.bb).offset(-start.method_10263(), -start.method_10264(), -start.method_10260());
                this.lockableInfos.add(new LockableInfo(newBB, lkb.lock, lkb.tr, lkb.stack, lkb.id));
            });
        }
    }

    @Inject(at={@At(value="RETURN", ordinal=1)}, method={"placeInWorld"})
    private void placeInWorld(class_5425 world, class_2338 start, class_2338 size, class_3492 settings, class_5819 rng, int i, CallbackInfoReturnable<Boolean> cir) {
        class_3218 level;
        try {
            level = world.method_8410();
        }
        catch (Exception e) {
            Locks.LOGGER.warn(String.valueOf(world) + "#getLevel threw an error! Skipping lockable placement for this template ");
            return;
        }
        ILockableHandler handler = (ILockableHandler)LocksComponents.LOCKABLE_HANDLER.get((Object)level);
        for (LockableInfo lkb : this.lockableInfos) {
            class_2338 pos1 = LocksUtil.transform(lkb.bb.x1, lkb.bb.y1, lkb.bb.z1, settings);
            class_2338 pos2 = LocksUtil.transform(lkb.bb.x2, lkb.bb.y2, lkb.bb.z2, settings);
            Cuboid6i bb = new Cuboid6i(pos1.method_10263() + start.method_10263(), pos1.method_10264() + start.method_10264(), pos1.method_10260() + start.method_10260(), pos2.method_10263() + start.method_10263(), pos2.method_10264() + start.method_10264(), pos2.method_10260() + start.method_10260());
            class_1799 stack = (Boolean)LocksConfig.RANDOMIZE_LOADED_LOCKS.get() != false ? LocksConfig.getRandomLock(rng) : lkb.stack;
            Lock lock = (Boolean)LocksConfig.RANDOMIZE_LOADED_LOCKS.get() != false ? Lock.from(stack) : lkb.lock;
            Transform tr = Transform.fromDirectionAndFace(settings.method_15113().method_10503(settings.method_15114().method_10345(lkb.tr.dir).method_10503(lkb.tr.dir)), lkb.tr.face, class_2350.field_11043);
            handler.add(new Lockable(bb, lock, tr, stack, (class_1937)level), (class_1937)level);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"save"})
    private void save(class_2487 nbt, CallbackInfoReturnable<class_2487> cir) {
        class_2499 list = new class_2499();
        for (LockableInfo lkb : this.lockableInfos) {
            list.add((Object)LockableInfo.toNbt(lkb));
        }
        nbt.method_10566(KEY_LOCKABLES, (class_2520)list);
    }

    @Inject(at={@At(value="HEAD")}, method={"load"})
    private void read(class_7871<class_2248> pBlockGetter, class_2487 nbt, CallbackInfo ci) {
        this.lockableInfos.clear();
        class_2499 list = nbt.method_10554(KEY_LOCKABLES, 10);
        int b = list.size();
        for (int a = 0; a < b; ++a) {
            this.lockableInfos.add(LockableInfo.fromNbt(list.method_10602(a)));
        }
    }
}

