/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.portallinkingcompass.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.maxoduke.mods.portallinkingcompass.PortalLinkingCompass;
import dev.maxoduke.mods.portallinkingcompass.item.component.LinkedPortalTracker;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10480;
import net.minecraft.class_11566;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_4208;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PortalLinkingCompassAngleState
extends class_10480 {
    public static final MapCodec<PortalLinkingCompassAngleState> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("wobble", (Object)true).forGetter(o -> o.method_65661()), (App)CompassTarget.CODEC.fieldOf("target").forGetter(angleState -> angleState.target)).apply((Applicative)instance, PortalLinkingCompassAngleState::new));
    private final class_10480.class_10481 wobbler;
    private final class_10480.class_10481 noTargetWobbler;
    private final CompassTarget target;
    private final class_5819 random = class_5819.method_43047();

    protected PortalLinkingCompassAngleState(boolean wobble, CompassTarget target) {
        super(wobble);
        this.wobbler = super.method_65660(0.8f);
        this.noTargetWobbler = super.method_65660(0.8f);
        this.target = target;
    }

    protected float method_65654(class_1799 itemStack, class_638 clientLevel, int seed, @Nullable class_11566 itemOwner) {
        long gameTime = clientLevel.method_8510();
        class_4208 targetPos = this.target.get(clientLevel, itemStack, itemOwner);
        return !PortalLinkingCompassAngleState.isValidCompassTargetPos(itemOwner, targetPos) ? this.getRandomlySpinningRotation(seed, gameTime) : this.getRotationTowardsCompassTarget(itemOwner, gameTime, targetPos.comp_2208());
    }

    private float getRandomlySpinningRotation(int i, long l) {
        if (this.noTargetWobbler.method_65665(l)) {
            this.noTargetWobbler.method_65666(l, this.random.method_43057());
        }
        float f = this.noTargetWobbler.method_65664() + (float)PortalLinkingCompassAngleState.hash(i) / 2.1474836E9f;
        return class_3532.method_15341((float)f, (float)1.0f);
    }

    private float getRotationTowardsCompassTarget(class_11566 itemOwner, long gameTime, class_2338 blockPos) {
        class_1657 player;
        float f = (float)PortalLinkingCompassAngleState.getAngleFromEntityToPos(itemOwner, blockPos);
        float g = PortalLinkingCompassAngleState.getWrappedVisualRotationY(itemOwner);
        class_1309 livingEntity = itemOwner.method_72393();
        if (livingEntity instanceof class_1657 && (player = (class_1657)livingEntity).method_7340() && player.method_73183().method_54719().method_54751()) {
            if (this.wobbler.method_65665(gameTime)) {
                this.wobbler.method_65666(gameTime, 0.5f - (g - 0.25f));
            }
            float h = f + this.wobbler.method_65664();
            return class_3532.method_15341((float)h, (float)1.0f);
        }
        float h = 0.5f - (g - 0.25f - f);
        return class_3532.method_15341((float)h, (float)1.0f);
    }

    private static boolean isValidCompassTargetPos(@Nullable class_11566 itemOwner, @Nullable class_4208 globalPos) {
        return globalPos != null && itemOwner != null && !(globalPos.comp_2208().method_19770((class_2374)itemOwner.method_73189()) < (double)1.0E-5f);
    }

    private static double getAngleFromEntityToPos(class_11566 itemOwner, class_2338 blockPos) {
        class_243 vec3 = class_243.method_24953((class_2382)blockPos);
        class_243 vec32 = itemOwner.method_73189();
        return Math.atan2(vec3.method_10215() - vec32.method_10215(), vec3.method_10216() - vec32.method_10216()) / 6.2831854820251465;
    }

    private static float getWrappedVisualRotationY(class_11566 itemOwner) {
        return class_3532.method_15341((float)(itemOwner.method_73188() / 360.0f), (float)1.0f);
    }

    private static int hash(int i) {
        return i * 1327217883;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum CompassTarget implements class_3542
    {
        NONE("none"){

            @Override
            @Nullable
            public class_4208 get(class_638 clientLevel, class_1799 itemStack, @Nullable class_11566 itemOwner) {
                return null;
            }
        }
        ,
        PORTAL("portal"){

            @Override
            @Nullable
            public class_4208 get(class_638 clientLevel, class_1799 itemStack, @Nullable class_11566 itemOwner) {
                LinkedPortalTracker linkedPortalTracker = (LinkedPortalTracker)itemStack.method_58694(PortalLinkingCompass.LINKED_PORTAL_TRACKER_COMPONENT);
                return linkedPortalTracker != null ? (class_4208)linkedPortalTracker.getTargetPos(clientLevel).orElse(null) : null;
            }
        };

        public static final Codec<CompassTarget> CODEC;
        private final String name;

        private CompassTarget(String string2) {
            this.name = string2;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        @Nullable
        abstract class_4208 get(class_638 var1, class_1799 var2, @Nullable class_11566 var3);

        static {
            CODEC = class_3542.method_53955(() -> new CompassTarget[]{NONE, PORTAL});
        }
    }
}

