/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.portallinkingcompass.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4153;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7477;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public record LinkedPortalTracker(Optional<class_2338> originalPosition, Optional<class_5321<class_1937>> originalDimension, Optional<class_2338> targetPosition, Optional<class_5321<class_1937>> targetDimension) {
    public static final Codec<LinkedPortalTracker> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.optionalFieldOf("originalPosition").forGetter(LinkedPortalTracker::originalPosition), (App)class_1937.field_25178.optionalFieldOf("originalDimension").forGetter(LinkedPortalTracker::originalDimension), (App)class_2338.field_25064.optionalFieldOf("targetPosition").forGetter(LinkedPortalTracker::targetPosition), (App)class_1937.field_25178.optionalFieldOf("targetDimension").forGetter(LinkedPortalTracker::targetDimension)).apply((Applicative)instance, LinkedPortalTracker::new));
    public static final class_9139<ByteBuf, LinkedPortalTracker> STREAM_CODEC = class_9139.method_56905((class_9139)class_9135.method_56382((class_9139)class_2338.field_48404), LinkedPortalTracker::originalPosition, (class_9139)class_9135.method_56382((class_9139)class_9135.method_56368((Codec)class_1937.field_25178)), LinkedPortalTracker::originalDimension, (class_9139)class_9135.method_56382((class_9139)class_2338.field_48404), LinkedPortalTracker::targetPosition, (class_9139)class_9135.method_56382((class_9139)class_9135.method_56368((Codec)class_1937.field_25178)), LinkedPortalTracker::targetDimension, LinkedPortalTracker::new);

    public LinkedPortalTracker(class_2338 originalPosition, class_1937 level) {
        this(Optional.of(originalPosition), Optional.of(level.method_27983()), Optional.of(LinkedPortalTracker.determineTargetPosition(originalPosition, level)), Optional.of(level.method_27983() == class_1937.field_25180 ? class_1937.field_25179 : class_1937.field_25180));
    }

    public static LinkedPortalTracker empty() {
        return new LinkedPortalTracker(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public LinkedPortalTracker tick(class_1937 level) {
        if (this.originalDimension.isEmpty() || this.originalPosition.isEmpty()) {
            return this;
        }
        MinecraftServer server = level.method_8503();
        class_3218 originalDimension = server.method_3847(this.originalDimension.get());
        if (originalDimension == null) {
            return this;
        }
        class_4153 poiManager = originalDimension.method_19494();
        boolean originalPortalBlockExists = poiManager.method_26339(class_7477.field_39295, this.originalPosition.get());
        if (originalPortalBlockExists) {
            return this;
        }
        return LinkedPortalTracker.empty();
    }

    public boolean isNotLinked() {
        return this.originalPosition.isEmpty() || this.originalDimension.isEmpty() || this.targetPosition.isEmpty() || this.targetDimension.isEmpty();
    }

    private static class_2338 determineTargetPosition(class_2338 originalPosition, class_1937 level) {
        double overworldCoordinateScale = 1.0;
        double netherCoordinateScale = 8.0;
        double coordinateScale = level.method_27983() == class_3218.field_25180 ? netherCoordinateScale / overworldCoordinateScale : overworldCoordinateScale / netherCoordinateScale;
        double x = (double)originalPosition.method_10263() * coordinateScale;
        double y = Math.max((double)originalPosition.method_10264(), 0.0);
        double z = (double)originalPosition.method_10260() * coordinateScale;
        return level.method_8621().method_39538(x, y, z);
    }

    public Optional<class_4208> getTargetPos(class_638 clientLevel) {
        if (this.isNotLinked() || this.originalPosition().isEmpty() || this.originalDimension().isEmpty() || this.targetPosition().isEmpty() || this.targetDimension().isEmpty()) {
            return Optional.empty();
        }
        class_5321 currentDimension = clientLevel.method_27983();
        class_5321<class_1937> originalDimension = this.originalDimension().get();
        class_5321<class_1937> targetDimension = this.targetDimension().get();
        class_2338 originalPosition = this.originalPosition().get();
        class_2338 targetPosition = this.targetPosition().get();
        if (currentDimension == originalDimension) {
            return Optional.of(class_4208.method_19443(originalDimension, (class_2338)originalPosition));
        }
        if (currentDimension == targetDimension) {
            return Optional.of(class_4208.method_19443(targetDimension, (class_2338)targetPosition));
        }
        return Optional.empty();
    }
}

