/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.portallinkingcompass.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.maxoduke.mods.portallinkingcompass.PortalLinkingCompass;
import dev.maxoduke.mods.portallinkingcompass.item.component.LinkedPortalTracker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.NeedleDirectionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PortalLinkingCompassAngleState
extends NeedleDirectionHelper {
    public static final MapCodec<PortalLinkingCompassAngleState> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("wobble", (Object)true).forGetter(o -> o.wobble()), (App)CompassTarget.CODEC.fieldOf("target").forGetter(angleState -> angleState.target)).apply((Applicative)instance, PortalLinkingCompassAngleState::new));
    private final NeedleDirectionHelper.Wobbler wobbler;
    private final NeedleDirectionHelper.Wobbler noTargetWobbler;
    private final CompassTarget target;
    private final RandomSource random = RandomSource.create();

    protected PortalLinkingCompassAngleState(boolean wobble, CompassTarget target) {
        super(wobble);
        this.wobbler = super.newWobbler(0.8f);
        this.noTargetWobbler = super.newWobbler(0.8f);
        this.target = target;
    }

    protected float calculate(@NotNull ItemStack itemStack, ClientLevel clientLevel, int seed, @Nullable ItemOwner itemOwner) {
        Entity entity;
        long gameTime = clientLevel.getGameTime();
        if (itemOwner == null) {
            entity = itemStack.getEntityRepresentation();
        } else {
            entity = itemOwner.asLivingEntity();
            if (entity == null) {
                entity = itemStack.getEntityRepresentation();
            }
        }
        GlobalPos targetPos = this.target.get(clientLevel, itemStack, entity);
        return !PortalLinkingCompassAngleState.isValidCompassTargetPos(entity, targetPos) ? this.getRandomlySpinningRotation(seed, gameTime) : this.getRotationTowardsCompassTarget(entity, gameTime, targetPos.pos());
    }

    private float getRandomlySpinningRotation(int i, long l) {
        if (this.noTargetWobbler.shouldUpdate(l)) {
            this.noTargetWobbler.update(l, this.random.nextFloat());
        }
        float f = this.noTargetWobbler.rotation() + (float)PortalLinkingCompassAngleState.hash(i) / 2.1474836E9f;
        return Mth.positiveModulo((float)f, (float)1.0f);
    }

    private float getRotationTowardsCompassTarget(Entity entity, long gameTime, BlockPos blockPos) {
        float f = (float)PortalLinkingCompassAngleState.getAngleFromEntityToPos(entity, blockPos);
        float g = PortalLinkingCompassAngleState.getWrappedVisualRotationY(entity);
        if (this.wobbler.shouldUpdate(gameTime)) {
            this.wobbler.update(gameTime, 0.5f - (g - 0.25f));
        }
        float h = f + this.wobbler.rotation();
        return Mth.positiveModulo((float)h, (float)1.0f);
    }

    private static boolean isValidCompassTargetPos(Entity entity, @Nullable GlobalPos globalPos) {
        return globalPos != null && !(globalPos.pos().distToCenterSqr((Position)entity.position()) < (double)1.0E-5f);
    }

    private static double getAngleFromEntityToPos(Entity entity, BlockPos blockPos) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)blockPos);
        return Math.atan2(vec3.z() - entity.getZ(), vec3.x() - entity.getX()) / 6.2831854820251465;
    }

    private static float getWrappedVisualRotationY(Entity entity) {
        return Mth.positiveModulo((float)(entity.getVisualRotationYInDegrees() / 360.0f), (float)1.0f);
    }

    private static int hash(int i) {
        return i * 1327217883;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum CompassTarget implements StringRepresentable
    {
        NONE("none"){

            @Override
            @Nullable
            public GlobalPos get(ClientLevel clientLevel, ItemStack itemStack, Entity entity) {
                return null;
            }
        }
        ,
        PORTAL("portal"){

            @Override
            @Nullable
            public GlobalPos get(ClientLevel clientLevel, ItemStack itemStack, Entity entity) {
                LinkedPortalTracker linkedPortalTracker = (LinkedPortalTracker)itemStack.get(PortalLinkingCompass.LINKED_PORTAL_TRACKER_COMPONENT);
                return linkedPortalTracker != null ? (GlobalPos)linkedPortalTracker.getTargetPos(clientLevel).orElse(null) : null;
            }
        };

        public static final Codec<CompassTarget> CODEC;
        private final String name;

        private CompassTarget(String string2) {
            this.name = string2;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        @Nullable
        abstract GlobalPos get(ClientLevel var1, ItemStack var2, Entity var3);

        static {
            CODEC = StringRepresentable.fromValues(() -> new CompassTarget[]{NONE, PORTAL});
        }
    }
}

