/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.portallinkingcompass.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.maxoduke.mods.portallinkingcompass.PortalLinkingCompass;
import dev.maxoduke.mods.portallinkingcompass.item.component.LinkedPortalTracker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.NeedleDirectionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PortalLinkingCompassAngleState
extends NeedleDirectionHelper {
    public static final MapCodec<PortalLinkingCompassAngleState> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("wobble", (Object)true).forGetter(o -> o.wobble()), (App)CompassTarget.CODEC.fieldOf("target").forGetter(angleState -> angleState.target)).apply((Applicative)instance, PortalLinkingCompassAngleState::new));
    private final NeedleDirectionHelper.Wobbler wobbler;
    private final NeedleDirectionHelper.Wobbler noTargetWobbler;
    private final CompassTarget target;
    private final RandomSource random = RandomSource.create();

    protected PortalLinkingCompassAngleState(boolean wobble, CompassTarget target) {
        super(wobble);
        this.wobbler = super.newWobbler(0.8f);
        this.noTargetWobbler = super.newWobbler(0.8f);
        this.target = target;
    }

    protected float calculate(@NotNull ItemStack itemStack, ClientLevel clientLevel, int seed, @Nullable ItemOwner itemOwner) {
        long gameTime = clientLevel.getGameTime();
        GlobalPos targetPos = this.target.get(clientLevel, itemStack, itemOwner);
        return !PortalLinkingCompassAngleState.isValidCompassTargetPos(itemOwner, targetPos) ? this.getRandomlySpinningRotation(seed, gameTime) : this.getRotationTowardsCompassTarget(itemOwner, gameTime, targetPos.pos());
    }

    private float getRandomlySpinningRotation(int i, long l) {
        if (this.noTargetWobbler.shouldUpdate(l)) {
            this.noTargetWobbler.update(l, this.random.nextFloat());
        }
        float f = this.noTargetWobbler.rotation() + (float)PortalLinkingCompassAngleState.hash(i) / 2.1474836E9f;
        return Mth.positiveModulo((float)f, (float)1.0f);
    }

    private float getRotationTowardsCompassTarget(ItemOwner itemOwner, long gameTime, BlockPos blockPos) {
        Player player;
        float f = (float)PortalLinkingCompassAngleState.getAngleFromEntityToPos(itemOwner, blockPos);
        float g = PortalLinkingCompassAngleState.getWrappedVisualRotationY(itemOwner);
        LivingEntity livingEntity = itemOwner.asLivingEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).isLocalPlayer() && player.level().tickRateManager().runsNormally()) {
            if (this.wobbler.shouldUpdate(gameTime)) {
                this.wobbler.update(gameTime, 0.5f - (g - 0.25f));
            }
            float h = f + this.wobbler.rotation();
            return Mth.positiveModulo((float)h, (float)1.0f);
        }
        float h = 0.5f - (g - 0.25f - f);
        return Mth.positiveModulo((float)h, (float)1.0f);
    }

    private static boolean isValidCompassTargetPos(@Nullable ItemOwner itemOwner, @Nullable GlobalPos globalPos) {
        return globalPos != null && itemOwner != null && !(globalPos.pos().distToCenterSqr((Position)itemOwner.position()) < (double)1.0E-5f);
    }

    private static double getAngleFromEntityToPos(ItemOwner itemOwner, BlockPos blockPos) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)blockPos);
        Vec3 vec32 = itemOwner.position();
        return Math.atan2(vec3.z() - vec32.z(), vec3.x() - vec32.x()) / 6.2831854820251465;
    }

    private static float getWrappedVisualRotationY(ItemOwner itemOwner) {
        return Mth.positiveModulo((float)(itemOwner.getVisualRotationYInDegrees() / 360.0f), (float)1.0f);
    }

    private static int hash(int i) {
        return i * 1327217883;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum CompassTarget implements StringRepresentable
    {
        NONE("none"){

            @Override
            @Nullable
            public GlobalPos get(ClientLevel clientLevel, ItemStack itemStack, @Nullable ItemOwner itemOwner) {
                return null;
            }
        }
        ,
        PORTAL("portal"){

            @Override
            @Nullable
            public GlobalPos get(ClientLevel clientLevel, ItemStack itemStack, @Nullable ItemOwner itemOwner) {
                LinkedPortalTracker linkedPortalTracker = (LinkedPortalTracker)itemStack.get(PortalLinkingCompass.LINKED_PORTAL_TRACKER_COMPONENT);
                return linkedPortalTracker != null ? (GlobalPos)linkedPortalTracker.getTargetPos(clientLevel).orElse(null) : null;
            }
        };

        public static final Codec<CompassTarget> CODEC;
        private final String name;

        private CompassTarget(String string2) {
            this.name = string2;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        @Nullable
        abstract GlobalPos get(ClientLevel var1, ItemStack var2, @Nullable ItemOwner var3);

        static {
            CODEC = StringRepresentable.fromValues(() -> new CompassTarget[]{NONE, PORTAL});
        }
    }
}

